/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.Address;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BillingEntity {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TAX_ID = "taxId";
    @SerializedName(value="taxId")
    private String taxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BillingEntity address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public BillingEntity email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="The email address of the billing entity.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BillingEntity id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the billing entity, for use as `billingEntityId` when creating an order.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BillingEntity name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The unique name of the billing entity.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingEntity taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax number of the billing entity.")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingEntity billingEntity = (BillingEntity)o;
        return Objects.equals(this.address, billingEntity.address) && Objects.equals(this.email, billingEntity.email) && Objects.equals(this.id, billingEntity.id) && Objects.equals(this.name, billingEntity.name) && Objects.equals(this.taxId, billingEntity.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.email, this.id, this.name, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingEntity {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BillingEntity is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BillingEntity` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `taxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_ID).toString()));
        }
    }

    public static BillingEntity fromJson(String jsonString) throws IOException {
        return (BillingEntity)JSON.getGson().fromJson(jsonString, BillingEntity.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TAX_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(BillingEntity.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BillingEntity.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BillingEntity.class));
            return new TypeAdapter<BillingEntity>(){

                public void write(JsonWriter out, BillingEntity value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BillingEntity read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BillingEntity.validateJsonObject(jsonObj);
                    return (BillingEntity)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

