/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.BankAccountInfoAccountIdentification;
import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BankAccountInfo {
    public static final String SERIALIZED_NAME_ACCOUNT_IDENTIFICATION = "accountIdentification";
    @SerializedName(value="accountIdentification")
    private BankAccountInfoAccountIdentification accountIdentification;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @Deprecated
    @SerializedName(value="accountType")
    private String accountType;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_TRUSTED_SOURCE = "trustedSource";
    @SerializedName(value="trustedSource")
    private Boolean trustedSource;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public BankAccountInfo() {
    }

    public BankAccountInfo(Boolean trustedSource) {
        this();
        this.trustedSource = trustedSource;
    }

    public BankAccountInfo accountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
        this.accountIdentification = accountIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    public BankAccountInfoAccountIdentification getAccountIdentification() {
        return this.accountIdentification;
    }

    public void setAccountIdentification(BankAccountInfoAccountIdentification accountIdentification) {
        this.accountIdentification = accountIdentification;
    }

    @Deprecated
    public BankAccountInfo accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The type of bank account.")
    public String getAccountType() {
        return this.accountType;
    }

    @Deprecated
    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public BankAccountInfo countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The two-character [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country code where the bank account is registered. For example, **NL**.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @ApiModelProperty(value="Identifies if the bank account was created through [instant bank verification](https://docs.adyen.com/release-notes/platforms-and-financial-products#releaseNote=2023-05-08-hosted-onboarding).")
    public Boolean getTrustedSource() {
        return this.trustedSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BankAccountInfo bankAccountInfo = (BankAccountInfo)o;
        return Objects.equals(this.accountIdentification, bankAccountInfo.accountIdentification) && Objects.equals(this.accountType, bankAccountInfo.accountType) && Objects.equals(this.countryCode, bankAccountInfo.countryCode) && Objects.equals(this.trustedSource, bankAccountInfo.trustedSource);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdentification, this.accountType, this.countryCode, this.trustedSource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BankAccountInfo {\n");
        sb.append("    accountIdentification: ").append(this.toIndentedString(this.accountIdentification)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    trustedSource: ").append(this.toIndentedString(this.trustedSource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BankAccountInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `BankAccountInfo` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_IDENTIFICATION) != null) {
            BankAccountInfoAccountIdentification.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ACCOUNT_IDENTIFICATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
    }

    public static BankAccountInfo fromJson(String jsonString) throws IOException {
        return (BankAccountInfo)JSON.getGson().fromJson(jsonString, BankAccountInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_IDENTIFICATION);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_TRUSTED_SOURCE);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(BankAccountInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BankAccountInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BankAccountInfo.class));
            return new TypeAdapter<BankAccountInfo>(){

                public void write(JsonWriter out, BankAccountInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BankAccountInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BankAccountInfo.validateJsonObject(jsonObj);
                    return (BankAccountInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

