/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.adyen.model.configurationwebhooks.SweepConfigurationV2;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SweepConfigurationNotificationData {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "accountId";
    @SerializedName(value="accountId")
    private String accountId;
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_SWEEP = "sweep";
    @SerializedName(value="sweep")
    private SweepConfigurationV2 sweep;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public SweepConfigurationNotificationData accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance account for which the sweep was configured.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public SweepConfigurationNotificationData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public SweepConfigurationNotificationData sweep(SweepConfigurationV2 sweep) {
        this.sweep = sweep;
        return this;
    }

    @ApiModelProperty(value="")
    public SweepConfigurationV2 getSweep() {
        return this.sweep;
    }

    public void setSweep(SweepConfigurationV2 sweep) {
        this.sweep = sweep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SweepConfigurationNotificationData sweepConfigurationNotificationData = (SweepConfigurationNotificationData)o;
        return Objects.equals(this.accountId, sweepConfigurationNotificationData.accountId) && Objects.equals(this.balancePlatform, sweepConfigurationNotificationData.balancePlatform) && Objects.equals(this.sweep, sweepConfigurationNotificationData.sweep);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.balancePlatform, this.sweep);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SweepConfigurationNotificationData {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    sweep: ").append(this.toIndentedString(this.sweep)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SweepConfigurationNotificationData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `SweepConfigurationNotificationData` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `accountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP) != null) {
            SweepConfigurationV2.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SWEEP));
        }
    }

    public static SweepConfigurationNotificationData fromJson(String jsonString) throws IOException {
        return (SweepConfigurationNotificationData)JSON.getGson().fromJson(jsonString, SweepConfigurationNotificationData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_SWEEP);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(SweepConfigurationNotificationData.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SweepConfigurationNotificationData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SweepConfigurationNotificationData.class));
            return new TypeAdapter<SweepConfigurationNotificationData>(){

                public void write(JsonWriter out, SweepConfigurationNotificationData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SweepConfigurationNotificationData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SweepConfigurationNotificationData.validateJsonObject(jsonObj);
                    return (SweepConfigurationNotificationData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

