/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.configurationwebhooks;

import com.adyen.model.configurationwebhooks.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Resource {
    public static final String SERIALIZED_NAME_BALANCE_PLATFORM = "balancePlatform";
    @SerializedName(value="balancePlatform")
    private String balancePlatform;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    private OffsetDateTime creationDate;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public Resource balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance platform.")
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public Resource creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="The date and time when the event was triggered, in ISO 8601 extended format. For example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public Resource id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The ID of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return Objects.equals(this.balancePlatform, resource.balancePlatform) && Objects.equals(this.creationDate, resource.creationDate) && Objects.equals(this.id, resource.id);
    }

    public int hashCode() {
        return Objects.hash(this.balancePlatform, this.creationDate, this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Resource {\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Resource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `Resource` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `balancePlatform` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_PLATFORM).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
    }

    public static Resource fromJson(String jsonString) throws IOException {
        return (Resource)JSON.getGson().fromJson(jsonString, Resource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_PLATFORM);
        openapiFields.add(SERIALIZED_NAME_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(Resource.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Resource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Resource.class));
            return new TypeAdapter<Resource>(){

                public void write(JsonWriter out, Resource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Resource read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Resource.validateJsonObject(jsonObj);
                    return (Resource)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

