/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThreeDSRequestorAuthenticationInfo {
    public static final String SERIALIZED_NAME_THREE_D_S_REQ_AUTH_DATA = "threeDSReqAuthData";
    @SerializedName(value="threeDSReqAuthData")
    private String threeDSReqAuthData;
    public static final String SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD = "threeDSReqAuthMethod";
    @SerializedName(value="threeDSReqAuthMethod")
    private ThreeDSReqAuthMethodEnum threeDSReqAuthMethod;
    public static final String SERIALIZED_NAME_THREE_D_S_REQ_AUTH_TIMESTAMP = "threeDSReqAuthTimestamp";
    @SerializedName(value="threeDSReqAuthTimestamp")
    private String threeDSReqAuthTimestamp;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthData(String threeDSReqAuthData) {
        this.threeDSReqAuthData = threeDSReqAuthData;
        return this;
    }

    @ApiModelProperty(value="Data that documents and supports a specific authentication process. Maximum length: 2048 bytes.")
    public String getThreeDSReqAuthData() {
        return this.threeDSReqAuthData;
    }

    public void setThreeDSReqAuthData(String threeDSReqAuthData) {
        this.threeDSReqAuthData = threeDSReqAuthData;
    }

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
        this.threeDSReqAuthMethod = threeDSReqAuthMethod;
        return this;
    }

    @ApiModelProperty(value="Mechanism used by the Cardholder to authenticate to the 3DS Requestor. Allowed values: * **01** \u2014 No 3DS Requestor authentication occurred (for example, cardholder \u201clogged in\u201d as guest). * **02** \u2014 Login to the cardholder account at the 3DS Requestor system using 3DS Requestor\u2019s own credentials. * **03** \u2014 Login to the cardholder account at the 3DS Requestor system using federated ID. * **04** \u2014 Login to the cardholder account at the 3DS Requestor system using issuer credentials. * **05** \u2014 Login to the cardholder account at the 3DS Requestor system using third-party authentication. * **06** \u2014 Login to the cardholder account at the 3DS Requestor system using FIDO Authenticator.")
    public ThreeDSReqAuthMethodEnum getThreeDSReqAuthMethod() {
        return this.threeDSReqAuthMethod;
    }

    public void setThreeDSReqAuthMethod(ThreeDSReqAuthMethodEnum threeDSReqAuthMethod) {
        this.threeDSReqAuthMethod = threeDSReqAuthMethod;
    }

    public ThreeDSRequestorAuthenticationInfo threeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
        this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
        return this;
    }

    @ApiModelProperty(value="Date and time in UTC of the cardholder authentication. Format: YYYYMMDDHHMM")
    public String getThreeDSReqAuthTimestamp() {
        return this.threeDSReqAuthTimestamp;
    }

    public void setThreeDSReqAuthTimestamp(String threeDSReqAuthTimestamp) {
        this.threeDSReqAuthTimestamp = threeDSReqAuthTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSRequestorAuthenticationInfo threeDSRequestorAuthenticationInfo = (ThreeDSRequestorAuthenticationInfo)o;
        return Objects.equals(this.threeDSReqAuthData, threeDSRequestorAuthenticationInfo.threeDSReqAuthData) && Objects.equals((Object)this.threeDSReqAuthMethod, (Object)threeDSRequestorAuthenticationInfo.threeDSReqAuthMethod) && Objects.equals(this.threeDSReqAuthTimestamp, threeDSRequestorAuthenticationInfo.threeDSReqAuthTimestamp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.threeDSReqAuthData, this.threeDSReqAuthMethod, this.threeDSReqAuthTimestamp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSRequestorAuthenticationInfo {\n");
        sb.append("    threeDSReqAuthData: ").append(this.toIndentedString(this.threeDSReqAuthData)).append("\n");
        sb.append("    threeDSReqAuthMethod: ").append(this.toIndentedString((Object)this.threeDSReqAuthMethod)).append("\n");
        sb.append("    threeDSReqAuthTimestamp: ").append(this.toIndentedString(this.threeDSReqAuthTimestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ThreeDSRequestorAuthenticationInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ThreeDSRequestorAuthenticationInfo` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_DATA) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `threeDSReqAuthData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_DATA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `threeDSReqAuthMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD).toString()));
            }
            ThreeDSReqAuthMethodEnum.fromValue(jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_TIMESTAMP) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_TIMESTAMP).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `threeDSReqAuthTimestamp` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_TIMESTAMP).toString()));
        }
    }

    public static ThreeDSRequestorAuthenticationInfo fromJson(String jsonString) throws IOException {
        return (ThreeDSRequestorAuthenticationInfo)JSON.getGson().fromJson(jsonString, ThreeDSRequestorAuthenticationInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_DATA);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_METHOD);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_REQ_AUTH_TIMESTAMP);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ThreeDSRequestorAuthenticationInfo.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ThreeDSRequestorAuthenticationInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ThreeDSRequestorAuthenticationInfo.class));
            return new TypeAdapter<ThreeDSRequestorAuthenticationInfo>(){

                public void write(JsonWriter out, ThreeDSRequestorAuthenticationInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ThreeDSRequestorAuthenticationInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ThreeDSRequestorAuthenticationInfo.validateJsonObject(jsonObj);
                    return (ThreeDSRequestorAuthenticationInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ThreeDSReqAuthMethodEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06");

        private String value;

        private ThreeDSReqAuthMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ThreeDSReqAuthMethodEnum fromValue(String value) {
            for (ThreeDSReqAuthMethodEnum b : ThreeDSReqAuthMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ThreeDSReqAuthMethodEnum> {
            public void write(JsonWriter jsonWriter, ThreeDSReqAuthMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ThreeDSReqAuthMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ThreeDSReqAuthMethodEnum.fromValue(value);
            }
        }
    }
}

