/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShopperInput {
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private BillingAddressEnum billingAddress;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
    @SerializedName(value="deliveryAddress")
    private DeliveryAddressEnum deliveryAddress;
    public static final String SERIALIZED_NAME_PERSONAL_DETAILS = "personalDetails";
    @SerializedName(value="personalDetails")
    private PersonalDetailsEnum personalDetails;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ShopperInput billingAddress(BillingAddressEnum billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of billing address fields.  Permitted values: * editable * hidden * readOnly")
    public BillingAddressEnum getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(BillingAddressEnum billingAddress) {
        this.billingAddress = billingAddress;
    }

    public ShopperInput deliveryAddress(DeliveryAddressEnum deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of delivery address fields.  Permitted values: * editable * hidden * readOnly")
    public DeliveryAddressEnum getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(DeliveryAddressEnum deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public ShopperInput personalDetails(PersonalDetailsEnum personalDetails) {
        this.personalDetails = personalDetails;
        return this;
    }

    @ApiModelProperty(value="Specifies visibility of personal details.  Permitted values: * editable * hidden * readOnly")
    public PersonalDetailsEnum getPersonalDetails() {
        return this.personalDetails;
    }

    public void setPersonalDetails(PersonalDetailsEnum personalDetails) {
        this.personalDetails = personalDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShopperInput shopperInput = (ShopperInput)o;
        return Objects.equals((Object)this.billingAddress, (Object)shopperInput.billingAddress) && Objects.equals((Object)this.deliveryAddress, (Object)shopperInput.deliveryAddress) && Objects.equals((Object)this.personalDetails, (Object)shopperInput.personalDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.billingAddress, this.deliveryAddress, this.personalDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShopperInput {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString((Object)this.billingAddress)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString((Object)this.deliveryAddress)).append("\n");
        sb.append("    personalDetails: ").append(this.toIndentedString((Object)this.personalDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ShopperInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ShopperInput` properties.", entry.getKey()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_BILLING_ADDRESS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `billingAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BILLING_ADDRESS).toString()));
            }
            BillingAddressEnum.fromValue(jsonObj.get(SERIALIZED_NAME_BILLING_ADDRESS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `deliveryAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS).toString()));
            }
            DeliveryAddressEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PERSONAL_DETAILS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PERSONAL_DETAILS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `personalDetails` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERSONAL_DETAILS).toString()));
            }
            PersonalDetailsEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PERSONAL_DETAILS).getAsString());
        }
    }

    public static ShopperInput fromJson(String jsonString) throws IOException {
        return (ShopperInput)JSON.getGson().fromJson(jsonString, ShopperInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_PERSONAL_DETAILS);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(ShopperInput.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ShopperInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ShopperInput.class));
            return new TypeAdapter<ShopperInput>(){

                public void write(JsonWriter out, ShopperInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ShopperInput read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ShopperInput.validateJsonObject(jsonObj);
                    return (ShopperInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PersonalDetailsEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private PersonalDetailsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PersonalDetailsEnum fromValue(String value) {
            for (PersonalDetailsEnum b : PersonalDetailsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PersonalDetailsEnum> {
            public void write(JsonWriter jsonWriter, PersonalDetailsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PersonalDetailsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PersonalDetailsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryAddressEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private DeliveryAddressEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryAddressEnum fromValue(String value) {
            for (DeliveryAddressEnum b : DeliveryAddressEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DeliveryAddressEnum> {
            public void write(JsonWriter jsonWriter, DeliveryAddressEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryAddressEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryAddressEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum BillingAddressEnum {
        EDITABLE("editable"),
        HIDDEN("hidden"),
        READONLY("readOnly");

        private String value;

        private BillingAddressEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static BillingAddressEnum fromValue(String value) {
            for (BillingAddressEnum b : BillingAddressEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<BillingAddressEnum> {
            public void write(JsonWriter jsonWriter, BillingAddressEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public BillingAddressEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return BillingAddressEnum.fromValue(value);
            }
        }
    }
}

