/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.CheckoutOrderResponse;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ResponsePaymentMethod;
import com.adyen.model.checkout.ThreeDS2ResponseData;
import com.adyen.model.checkout.ThreeDS2Result;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PaymentDetailsResponse {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_DONATION_TOKEN = "donationToken";
    @SerializedName(value="donationToken")
    private String donationToken;
    public static final String SERIALIZED_NAME_FRAUD_RESULT = "fraudResult";
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult;
    public static final String SERIALIZED_NAME_MERCHANT_REFERENCE = "merchantReference";
    @SerializedName(value="merchantReference")
    private String merchantReference;
    public static final String SERIALIZED_NAME_ORDER = "order";
    @SerializedName(value="order")
    private CheckoutOrderResponse order;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
    @SerializedName(value="paymentMethod")
    private ResponsePaymentMethod paymentMethod;
    public static final String SERIALIZED_NAME_PSP_REFERENCE = "pspReference";
    @SerializedName(value="pspReference")
    private String pspReference;
    public static final String SERIALIZED_NAME_REFUSAL_REASON = "refusalReason";
    @SerializedName(value="refusalReason")
    private String refusalReason;
    public static final String SERIALIZED_NAME_REFUSAL_REASON_CODE = "refusalReasonCode";
    @SerializedName(value="refusalReasonCode")
    private String refusalReasonCode;
    public static final String SERIALIZED_NAME_RESULT_CODE = "resultCode";
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode;
    public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
    @SerializedName(value="shopperLocale")
    private String shopperLocale;
    public static final String SERIALIZED_NAME_THREE_D_S2_RESPONSE_DATA = "threeDS2ResponseData";
    @SerializedName(value="threeDS2ResponseData")
    private ThreeDS2ResponseData threeDS2ResponseData;
    public static final String SERIALIZED_NAME_THREE_D_S2_RESULT = "threeDS2Result";
    @SerializedName(value="threeDS2Result")
    private ThreeDS2Result threeDS2Result;
    public static final String SERIALIZED_NAME_THREE_D_S_PAYMENT_DATA = "threeDSPaymentData";
    @SerializedName(value="threeDSPaymentData")
    private String threeDSPaymentData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public PaymentDetailsResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public PaymentDetailsResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="Contains additional information about the payment. Some data fields are included only if you select them first: Go to **Customer Area** > **Developers** > **Additional data**.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentDetailsResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentDetailsResponse donationToken(String donationToken) {
        this.donationToken = donationToken;
        return this;
    }

    @ApiModelProperty(value="Donation Token containing payment details for Adyen Giving.")
    public String getDonationToken() {
        return this.donationToken;
    }

    public void setDonationToken(String donationToken) {
        this.donationToken = donationToken;
    }

    public PaymentDetailsResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    @ApiModelProperty(value="")
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public PaymentDetailsResponse merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The reference used during the /payments request.")
    public String getMerchantReference() {
        return this.merchantReference;
    }

    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public PaymentDetailsResponse order(CheckoutOrderResponse order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="")
    public CheckoutOrderResponse getOrder() {
        return this.order;
    }

    public void setOrder(CheckoutOrderResponse order) {
        this.order = order;
    }

    public PaymentDetailsResponse paymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="")
    public ResponsePaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentDetailsResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    @ApiModelProperty(value="Adyen's 16-character string reference associated with the transaction/request. This value is globally unique; quote it when communicating with us about this request.")
    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentDetailsResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    @ApiModelProperty(value="If the payment's authorisation is refused or an error occurs during authorisation, this field holds Adyen's mapped reason for the refusal or a description of the error. When a transaction fails, the authorisation response includes `resultCode` and `refusalReason` values.  For more information, see [Refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentDetailsResponse refusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
        return this;
    }

    @ApiModelProperty(value="Code that specifies the refusal reason. For more information, see [Authorisation refusal reasons](https://docs.adyen.com/development-resources/refusal-reasons).")
    public String getRefusalReasonCode() {
        return this.refusalReasonCode;
    }

    public void setRefusalReasonCode(String refusalReasonCode) {
        this.refusalReasonCode = refusalReasonCode;
    }

    public PaymentDetailsResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    @ApiModelProperty(value="The result of the payment. For more information, see [Result codes](https://docs.adyen.com/online-payments/payment-result-codes).  Possible values:  * **AuthenticationFinished** \u2013 The payment has been successfully authenticated with 3D Secure 2. Returned for 3D Secure 2 authentication-only transactions. * **AuthenticationNotRequired** \u2013 The transaction does not require 3D Secure authentication. Returned for [standalone authentication-only integrations](https://docs.adyen.com/online-payments/3d-secure/other-3ds-flows/authentication-only). * **Authorised** \u2013 The payment was successfully authorised. This state serves as an indicator to proceed with the delivery of goods and services. This is a final state. * **Cancelled** \u2013 Indicates the payment has been cancelled (either by the shopper or the merchant) before processing was completed. This is a final state. * **ChallengeShopper** \u2013 The issuer requires further shopper interaction before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Error** \u2013 There was an error when the payment was being processed. The reason is given in the `refusalReason` field. This is a final state. * **IdentifyShopper** \u2013 The issuer requires the shopper's device fingerprint before the payment can be authenticated. Returned for 3D Secure 2 transactions. * **Pending** \u2013 Indicates that it is not possible to obtain the final status of the payment. This can happen if the systems providing final status information for the payment are unavailable, or if the shopper needs to take further action to complete the payment. * **PresentToShopper** \u2013 Indicates that the response contains additional information that you need to present to a shopper, so that they can use it to complete a payment. * **Received** \u2013 Indicates the payment has successfully been received by Adyen, and will be processed. This is the initial state for all payments. * **RedirectShopper** \u2013 Indicates the shopper should be redirected to an external web page or app to complete the authorisation. * **Refused** \u2013 Indicates the payment was refused. The reason is given in the `refusalReason` field. This is a final state.")
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public PaymentDetailsResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The shopperLocale.")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentDetailsResponse threeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDS2ResponseData getThreeDS2ResponseData() {
        return this.threeDS2ResponseData;
    }

    public void setThreeDS2ResponseData(ThreeDS2ResponseData threeDS2ResponseData) {
        this.threeDS2ResponseData = threeDS2ResponseData;
    }

    public PaymentDetailsResponse threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return this;
    }

    @ApiModelProperty(value="")
    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public PaymentDetailsResponse threeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
        return this;
    }

    @ApiModelProperty(value="When non-empty, contains a value that you must submit to the `/payments/details` endpoint as `paymentData`.")
    public String getThreeDSPaymentData() {
        return this.threeDSPaymentData;
    }

    public void setThreeDSPaymentData(String threeDSPaymentData) {
        this.threeDSPaymentData = threeDSPaymentData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentDetailsResponse paymentDetailsResponse = (PaymentDetailsResponse)o;
        return Objects.equals(this.additionalData, paymentDetailsResponse.additionalData) && Objects.equals(this.amount, paymentDetailsResponse.amount) && Objects.equals(this.donationToken, paymentDetailsResponse.donationToken) && Objects.equals(this.fraudResult, paymentDetailsResponse.fraudResult) && Objects.equals(this.merchantReference, paymentDetailsResponse.merchantReference) && Objects.equals(this.order, paymentDetailsResponse.order) && Objects.equals(this.paymentMethod, paymentDetailsResponse.paymentMethod) && Objects.equals(this.pspReference, paymentDetailsResponse.pspReference) && Objects.equals(this.refusalReason, paymentDetailsResponse.refusalReason) && Objects.equals(this.refusalReasonCode, paymentDetailsResponse.refusalReasonCode) && Objects.equals((Object)this.resultCode, (Object)paymentDetailsResponse.resultCode) && Objects.equals(this.shopperLocale, paymentDetailsResponse.shopperLocale) && Objects.equals(this.threeDS2ResponseData, paymentDetailsResponse.threeDS2ResponseData) && Objects.equals(this.threeDS2Result, paymentDetailsResponse.threeDS2Result) && Objects.equals(this.threeDSPaymentData, paymentDetailsResponse.threeDSPaymentData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.amount, this.donationToken, this.fraudResult, this.merchantReference, this.order, this.paymentMethod, this.pspReference, this.refusalReason, this.refusalReasonCode, this.resultCode, this.shopperLocale, this.threeDS2ResponseData, this.threeDS2Result, this.threeDSPaymentData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentDetailsResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    donationToken: ").append(this.toIndentedString(this.donationToken)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    refusalReasonCode: ").append(this.toIndentedString(this.refusalReasonCode)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    threeDS2ResponseData: ").append(this.toIndentedString(this.threeDS2ResponseData)).append("\n");
        sb.append("    threeDS2Result: ").append(this.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    threeDSPaymentData: ").append(this.toIndentedString(this.threeDSPaymentData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentDetailsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `PaymentDetailsResponse` properties.", entry.getKey()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_DONATION_TOKEN) != null && !jsonObj.get(SERIALIZED_NAME_DONATION_TOKEN).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `donationToken` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DONATION_TOKEN).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT) != null) {
            FraudResult.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FRAUD_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `merchantReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORDER) != null) {
            CheckoutOrderResponse.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORDER));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD) != null) {
            ResponsePaymentMethod.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYMENT_METHOD));
        }
        if (jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pspReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PSP_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `refusalReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON_CODE) != null && !jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON_CODE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `refusalReasonCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFUSAL_REASON_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESULT_CODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESULT_CODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `resultCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESULT_CODE).toString()));
            }
            ResultCodeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RESULT_CODE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_RESPONSE_DATA) != null) {
            ThreeDS2ResponseData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_RESPONSE_DATA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_RESULT) != null) {
            ThreeDS2Result.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_THREE_D_S2_RESULT));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S_PAYMENT_DATA) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S_PAYMENT_DATA).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `threeDSPaymentData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S_PAYMENT_DATA).toString()));
        }
    }

    public static PaymentDetailsResponse fromJson(String jsonString) throws IOException {
        return (PaymentDetailsResponse)JSON.getGson().fromJson(jsonString, PaymentDetailsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DONATION_TOKEN);
        openapiFields.add(SERIALIZED_NAME_FRAUD_RESULT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_ORDER);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_PSP_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON);
        openapiFields.add(SERIALIZED_NAME_REFUSAL_REASON_CODE);
        openapiFields.add(SERIALIZED_NAME_RESULT_CODE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_LOCALE);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_RESPONSE_DATA);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_RESULT);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S_PAYMENT_DATA);
        openapiRequiredFields = new HashSet();
        log = Logger.getLogger(PaymentDetailsResponse.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentDetailsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentDetailsResponse.class));
            return new TypeAdapter<PaymentDetailsResponse>(){

                public void write(JsonWriter out, PaymentDetailsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentDetailsResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentDetailsResponse.validateJsonObject(jsonObj);
                    return (PaymentDetailsResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResultCodeEnum {
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired"),
        AUTHORISED("Authorised"),
        CANCELLED("Cancelled"),
        CHALLENGESHOPPER("ChallengeShopper"),
        ERROR("Error"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        PENDING("Pending"),
        PRESENTTOSHOPPER("PresentToShopper"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        REFUSED("Refused"),
        SUCCESS("Success");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResultCodeEnum> {
            public void write(JsonWriter jsonWriter, ResultCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResultCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResultCodeEnum.fromValue(value);
            }
        }
    }
}

