/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Address;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Phone;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContactDetails {
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private Address address;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private Phone phone;
    public static final String SERIALIZED_NAME_WEB_ADDRESS = "webAddress";
    @SerializedName(value="webAddress")
    private String webAddress;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public ContactDetails address(Address address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public ContactDetails email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the account holder.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public ContactDetails phone(Phone phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Phone getPhone() {
        return this.phone;
    }

    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public ContactDetails webAddress(String webAddress) {
        this.webAddress = webAddress;
        return this;
    }

    @ApiModelProperty(value="The URL of the account holder's website.")
    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactDetails contactDetails = (ContactDetails)o;
        return Objects.equals(this.address, contactDetails.address) && Objects.equals(this.email, contactDetails.email) && Objects.equals(this.phone, contactDetails.phone) && Objects.equals(this.webAddress, contactDetails.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.email, this.phone, this.webAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactDetails {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    webAddress: ").append(this.toIndentedString(this.webAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContactDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `ContactDetails` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE) != null) {
            Phone.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PHONE));
        }
        if (jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `webAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WEB_ADDRESS).toString()));
        }
    }

    public static ContactDetails fromJson(String jsonString) throws IOException {
        return (ContactDetails)JSON.getGson().fromJson(jsonString, ContactDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_EMAIL);
        openapiFields.add(SERIALIZED_NAME_PHONE);
        openapiFields.add(SERIALIZED_NAME_WEB_ADDRESS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ADDRESS);
        openapiRequiredFields.add(SERIALIZED_NAME_EMAIL);
        openapiRequiredFields.add(SERIALIZED_NAME_PHONE);
        log = Logger.getLogger(ContactDetails.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContactDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContactDetails.class));
            return new TypeAdapter<ContactDetails>(){

                public void write(JsonWriter out, ContactDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContactDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ContactDetails.validateJsonObject(jsonObj);
                    return (ContactDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

