/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.BulkAddress;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CardConfiguration {
    public static final String SERIALIZED_NAME_ACTIVATION = "activation";
    @SerializedName(value="activation")
    private String activation;
    public static final String SERIALIZED_NAME_ACTIVATION_URL = "activationUrl";
    @SerializedName(value="activationUrl")
    private String activationUrl;
    public static final String SERIALIZED_NAME_BULK_ADDRESS = "bulkAddress";
    @SerializedName(value="bulkAddress")
    private BulkAddress bulkAddress;
    public static final String SERIALIZED_NAME_CARD_IMAGE_ID = "cardImageId";
    @SerializedName(value="cardImageId")
    private String cardImageId;
    public static final String SERIALIZED_NAME_CARRIER = "carrier";
    @SerializedName(value="carrier")
    private String carrier;
    public static final String SERIALIZED_NAME_CARRIER_IMAGE_ID = "carrierImageId";
    @SerializedName(value="carrierImageId")
    private String carrierImageId;
    public static final String SERIALIZED_NAME_CONFIGURATION_PROFILE_ID = "configurationProfileId";
    @SerializedName(value="configurationProfileId")
    private String configurationProfileId;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_ENVELOPE = "envelope";
    @SerializedName(value="envelope")
    private String envelope;
    public static final String SERIALIZED_NAME_INSERT = "insert";
    @SerializedName(value="insert")
    private String insert;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    public static final String SERIALIZED_NAME_LOGO_IMAGE_ID = "logoImageId";
    @SerializedName(value="logoImageId")
    private String logoImageId;
    public static final String SERIALIZED_NAME_PIN_MAILER = "pinMailer";
    @SerializedName(value="pinMailer")
    private String pinMailer;
    public static final String SERIALIZED_NAME_SHIPMENT_METHOD = "shipmentMethod";
    @SerializedName(value="shipmentMethod")
    private String shipmentMethod;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;
    private static final Logger log;

    public CardConfiguration activation(String activation) {
        this.activation = activation;
        return this;
    }

    @ApiModelProperty(value="Overrides the activation label design ID defined in the `configurationProfileId`. The activation label is attached to the card and contains the activation instructions.")
    public String getActivation() {
        return this.activation;
    }

    public void setActivation(String activation) {
        this.activation = activation;
    }

    public CardConfiguration activationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    @ApiModelProperty(value="Your app's URL, if you want to activate cards through your app. For example, **my-app://ref1236a7d**. A QR code is created based on this URL, and is included in the carrier. Before you use this field, reach out to your Adyen contact to set up the QR code process.   Maximum length: 255 characters.")
    public String getActivationUrl() {
        return this.activationUrl;
    }

    public void setActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
    }

    public CardConfiguration bulkAddress(BulkAddress bulkAddress) {
        this.bulkAddress = bulkAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public BulkAddress getBulkAddress() {
        return this.bulkAddress;
    }

    public void setBulkAddress(BulkAddress bulkAddress) {
        this.bulkAddress = bulkAddress;
    }

    public CardConfiguration cardImageId(String cardImageId) {
        this.cardImageId = cardImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the card image. This is the image that will be printed on the full front of the card.")
    public String getCardImageId() {
        return this.cardImageId;
    }

    public void setCardImageId(String cardImageId) {
        this.cardImageId = cardImageId;
    }

    public CardConfiguration carrier(String carrier) {
        this.carrier = carrier;
        return this;
    }

    @ApiModelProperty(value="Overrides the carrier design ID defined in the `configurationProfileId`. The carrier is the letter or packaging to which the card is attached.")
    public String getCarrier() {
        return this.carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public CardConfiguration carrierImageId(String carrierImageId) {
        this.carrierImageId = carrierImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the carrier image. This is the image that will printed on the letter to which the card is attached.")
    public String getCarrierImageId() {
        return this.carrierImageId;
    }

    public void setCarrierImageId(String carrierImageId) {
        this.carrierImageId = carrierImageId;
    }

    public CardConfiguration configurationProfileId(String configurationProfileId) {
        this.configurationProfileId = configurationProfileId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the card configuration profile that contains the settings of the card. For example, the envelope and PIN mailer designs or the logistics company handling the shipment. All the settings in the profile are applied to the card, unless you provide other fields to override them.  For example, send the `shipmentMethod` to override the logistics company defined in the card configuration profile.")
    public String getConfigurationProfileId() {
        return this.configurationProfileId;
    }

    public void setConfigurationProfileId(String configurationProfileId) {
        this.configurationProfileId = configurationProfileId;
    }

    public CardConfiguration currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="The three-letter [ISO-4217](https://en.wikipedia.org/wiki/ISO_4217) currency code of the card. For example, **EUR**.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CardConfiguration envelope(String envelope) {
        this.envelope = envelope;
        return this;
    }

    @ApiModelProperty(value="Overrides the envelope design ID defined in the `configurationProfileId`. ")
    public String getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public CardConfiguration insert(String insert) {
        this.insert = insert;
        return this;
    }

    @ApiModelProperty(value="Overrides the insert design ID defined in the `configurationProfileId`. An insert is any additional material, such as marketing materials, that are shipped together with the card.")
    public String getInsert() {
        return this.insert;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }

    public CardConfiguration language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The two-letter [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code of the card. For example, **en**.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public CardConfiguration logoImageId(String logoImageId) {
        this.logoImageId = logoImageId;
        return this;
    }

    @ApiModelProperty(value="The ID of the logo image. This is the image that will be printed on the partial front of the card, such as a logo on the upper right corner.")
    public String getLogoImageId() {
        return this.logoImageId;
    }

    public void setLogoImageId(String logoImageId) {
        this.logoImageId = logoImageId;
    }

    public CardConfiguration pinMailer(String pinMailer) {
        this.pinMailer = pinMailer;
        return this;
    }

    @ApiModelProperty(value="Overrides the PIN mailer design ID defined in the `configurationProfileId`. The PIN mailer is the letter on which the PIN is printed.")
    public String getPinMailer() {
        return this.pinMailer;
    }

    public void setPinMailer(String pinMailer) {
        this.pinMailer = pinMailer;
    }

    public CardConfiguration shipmentMethod(String shipmentMethod) {
        this.shipmentMethod = shipmentMethod;
        return this;
    }

    @ApiModelProperty(value="Overrides the logistics company defined in the `configurationProfileId`.")
    public String getShipmentMethod() {
        return this.shipmentMethod;
    }

    public void setShipmentMethod(String shipmentMethod) {
        this.shipmentMethod = shipmentMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardConfiguration cardConfiguration = (CardConfiguration)o;
        return Objects.equals(this.activation, cardConfiguration.activation) && Objects.equals(this.activationUrl, cardConfiguration.activationUrl) && Objects.equals(this.bulkAddress, cardConfiguration.bulkAddress) && Objects.equals(this.cardImageId, cardConfiguration.cardImageId) && Objects.equals(this.carrier, cardConfiguration.carrier) && Objects.equals(this.carrierImageId, cardConfiguration.carrierImageId) && Objects.equals(this.configurationProfileId, cardConfiguration.configurationProfileId) && Objects.equals(this.currency, cardConfiguration.currency) && Objects.equals(this.envelope, cardConfiguration.envelope) && Objects.equals(this.insert, cardConfiguration.insert) && Objects.equals(this.language, cardConfiguration.language) && Objects.equals(this.logoImageId, cardConfiguration.logoImageId) && Objects.equals(this.pinMailer, cardConfiguration.pinMailer) && Objects.equals(this.shipmentMethod, cardConfiguration.shipmentMethod);
    }

    public int hashCode() {
        return Objects.hash(this.activation, this.activationUrl, this.bulkAddress, this.cardImageId, this.carrier, this.carrierImageId, this.configurationProfileId, this.currency, this.envelope, this.insert, this.language, this.logoImageId, this.pinMailer, this.shipmentMethod);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardConfiguration {\n");
        sb.append("    activation: ").append(this.toIndentedString(this.activation)).append("\n");
        sb.append("    activationUrl: ").append(this.toIndentedString(this.activationUrl)).append("\n");
        sb.append("    bulkAddress: ").append(this.toIndentedString(this.bulkAddress)).append("\n");
        sb.append("    cardImageId: ").append(this.toIndentedString(this.cardImageId)).append("\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    carrierImageId: ").append(this.toIndentedString(this.carrierImageId)).append("\n");
        sb.append("    configurationProfileId: ").append(this.toIndentedString(this.configurationProfileId)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    envelope: ").append(this.toIndentedString(this.envelope)).append("\n");
        sb.append("    insert: ").append(this.toIndentedString(this.insert)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    logoImageId: ").append(this.toIndentedString(this.logoImageId)).append("\n");
        sb.append("    pinMailer: ").append(this.toIndentedString(this.pinMailer)).append("\n");
        sb.append("    shipmentMethod: ").append(this.toIndentedString(this.shipmentMethod)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CardConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            log.log(Level.WARNING, String.format("The field `%s` in the JSON string is not defined in the `CardConfiguration` properties.", entry.getKey()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIVATION) != null && !jsonObj.get(SERIALIZED_NAME_ACTIVATION).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `activation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIVATION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACTIVATION_URL) != null && !jsonObj.get(SERIALIZED_NAME_ACTIVATION_URL).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `activationUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIVATION_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BULK_ADDRESS) != null) {
            BulkAddress.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BULK_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_IMAGE_ID) != null && !jsonObj.get(SERIALIZED_NAME_CARD_IMAGE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `cardImageId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_IMAGE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARRIER) != null && !jsonObj.get(SERIALIZED_NAME_CARRIER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `carrier` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARRIER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARRIER_IMAGE_ID) != null && !jsonObj.get(SERIALIZED_NAME_CARRIER_IMAGE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `carrierImageId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARRIER_IMAGE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONFIGURATION_PROFILE_ID) != null && !jsonObj.get(SERIALIZED_NAME_CONFIGURATION_PROFILE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `configurationProfileId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIGURATION_PROFILE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCY).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVELOPE) != null && !jsonObj.get(SERIALIZED_NAME_ENVELOPE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `envelope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVELOPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INSERT) != null && !jsonObj.get(SERIALIZED_NAME_INSERT).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `insert` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSERT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO_IMAGE_ID) != null && !jsonObj.get(SERIALIZED_NAME_LOGO_IMAGE_ID).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `logoImageId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO_IMAGE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PIN_MAILER) != null && !jsonObj.get(SERIALIZED_NAME_PIN_MAILER).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `pinMailer` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PIN_MAILER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHIPMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_SHIPMENT_METHOD).isJsonPrimitive()) {
            log.log(Level.WARNING, String.format("Expected the field `shipmentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHIPMENT_METHOD).toString()));
        }
    }

    public static CardConfiguration fromJson(String jsonString) throws IOException {
        return (CardConfiguration)JSON.getGson().fromJson(jsonString, CardConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVATION);
        openapiFields.add(SERIALIZED_NAME_ACTIVATION_URL);
        openapiFields.add(SERIALIZED_NAME_BULK_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CARD_IMAGE_ID);
        openapiFields.add(SERIALIZED_NAME_CARRIER);
        openapiFields.add(SERIALIZED_NAME_CARRIER_IMAGE_ID);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION_PROFILE_ID);
        openapiFields.add(SERIALIZED_NAME_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_ENVELOPE);
        openapiFields.add(SERIALIZED_NAME_INSERT);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_LOGO_IMAGE_ID);
        openapiFields.add(SERIALIZED_NAME_PIN_MAILER);
        openapiFields.add(SERIALIZED_NAME_SHIPMENT_METHOD);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONFIGURATION_PROFILE_ID);
        log = Logger.getLogger(CardConfiguration.class.getName());
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CardConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CardConfiguration.class));
            return new TypeAdapter<CardConfiguration>(){

                public void write(JsonWriter out, CardConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CardConfiguration read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CardConfiguration.validateJsonObject(jsonObj);
                    return (CardConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

