/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.posterminalmanagement;

import com.adyen.model.posterminalmanagement.JSON;
import com.adyen.model.posterminalmanagement.MerchantAccount;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GetTerminalsUnderAccountResponse {
    public static final String SERIALIZED_NAME_COMPANY_ACCOUNT = "companyAccount";
    @SerializedName(value="companyAccount")
    private String companyAccount;
    public static final String SERIALIZED_NAME_INVENTORY_TERMINALS = "inventoryTerminals";
    @SerializedName(value="inventoryTerminals")
    private List<String> inventoryTerminals = null;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNTS = "merchantAccounts";
    @SerializedName(value="merchantAccounts")
    private List<MerchantAccount> merchantAccounts = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GetTerminalsUnderAccountResponse companyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="Your company account.")
    public String getCompanyAccount() {
        return this.companyAccount;
    }

    public void setCompanyAccount(String companyAccount) {
        this.companyAccount = companyAccount;
    }

    public GetTerminalsUnderAccountResponse inventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
        return this;
    }

    public GetTerminalsUnderAccountResponse addInventoryTerminalsItem(String inventoryTerminalsItem) {
        if (this.inventoryTerminals == null) {
            this.inventoryTerminals = new ArrayList<String>();
        }
        this.inventoryTerminals.add(inventoryTerminalsItem);
        return this;
    }

    @ApiModelProperty(value="Array that returns a list of all terminals that are in the inventory of the company account.")
    public List<String> getInventoryTerminals() {
        return this.inventoryTerminals;
    }

    public void setInventoryTerminals(List<String> inventoryTerminals) {
        this.inventoryTerminals = inventoryTerminals;
    }

    public GetTerminalsUnderAccountResponse merchantAccounts(List<MerchantAccount> merchantAccounts) {
        this.merchantAccounts = merchantAccounts;
        return this;
    }

    public GetTerminalsUnderAccountResponse addMerchantAccountsItem(MerchantAccount merchantAccountsItem) {
        if (this.merchantAccounts == null) {
            this.merchantAccounts = new ArrayList<MerchantAccount>();
        }
        this.merchantAccounts.add(merchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="Array that returns a list of all merchant accounts belonging to the company account.")
    public List<MerchantAccount> getMerchantAccounts() {
        return this.merchantAccounts;
    }

    public void setMerchantAccounts(List<MerchantAccount> merchantAccounts) {
        this.merchantAccounts = merchantAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetTerminalsUnderAccountResponse getTerminalsUnderAccountResponse = (GetTerminalsUnderAccountResponse)o;
        return Objects.equals(this.companyAccount, getTerminalsUnderAccountResponse.companyAccount) && Objects.equals(this.inventoryTerminals, getTerminalsUnderAccountResponse.inventoryTerminals) && Objects.equals(this.merchantAccounts, getTerminalsUnderAccountResponse.merchantAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.companyAccount, this.inventoryTerminals, this.merchantAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetTerminalsUnderAccountResponse {\n");
        sb.append("    companyAccount: ").append(this.toIndentedString(this.companyAccount)).append("\n");
        sb.append("    inventoryTerminals: ").append(this.toIndentedString(this.inventoryTerminals)).append("\n");
        sb.append("    merchantAccounts: ").append(this.toIndentedString(this.merchantAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GetTerminalsUnderAccountResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GetTerminalsUnderAccountResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `companyAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMPANY_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS) != null && !jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `inventoryTerminals` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INVENTORY_TERMINALS).toString()));
        }
        JsonArray jsonArraymerchantAccounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_MERCHANT_ACCOUNTS);
        if (jsonArraymerchantAccounts != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `merchantAccounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNTS).toString()));
            }
            for (int i = 0; i < jsonArraymerchantAccounts.size(); ++i) {
                MerchantAccount.validateJsonObject(jsonArraymerchantAccounts.get(i).getAsJsonObject());
            }
        }
    }

    public static GetTerminalsUnderAccountResponse fromJson(String jsonString) throws IOException {
        return (GetTerminalsUnderAccountResponse)JSON.getGson().fromJson(jsonString, GetTerminalsUnderAccountResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_INVENTORY_TERMINALS);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNTS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_COMPANY_ACCOUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GetTerminalsUnderAccountResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GetTerminalsUnderAccountResponse.class));
            return new TypeAdapter<GetTerminalsUnderAccountResponse>(){

                public void write(JsonWriter out, GetTerminalsUnderAccountResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GetTerminalsUnderAccountResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GetTerminalsUnderAccountResponse.validateJsonObject(jsonObj);
                    return (GetTerminalsUnderAccountResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

