/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SubMerchant {
    public static final String SERIALIZED_NAME_CITY = "city";
    @SerializedName(value="city")
    private String city;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TAX_ID = "taxId";
    @SerializedName(value="taxId")
    private String taxId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SubMerchant city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="The city of the sub-merchant's address. * Format: Alphanumeric * Maximum length: 13 characters")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public SubMerchant country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="The three-letter country code of the sub-merchant's address. For example, **BRA** for Brazil.  * Format: [ISO 3166-1 alpha-3](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) * Fixed length: 3 characters")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public SubMerchant mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The sub-merchant's 4-digit Merchant Category Code (MCC).  * Format: Numeric * Fixed length: 4 digits")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public SubMerchant name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the sub-merchant. Based on scheme specifications, this value will overwrite the shopper statement  that will appear in the card statement. * Format: Alphanumeric * Maximum length: 22 characters")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubMerchant taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    @ApiModelProperty(value="The tax ID of the sub-merchant. * Format: Numeric * Fixed length: 11 digits for the CPF or 14 digits for the CNPJ")
    public String getTaxId() {
        return this.taxId;
    }

    public void setTaxId(String taxId) {
        this.taxId = taxId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubMerchant subMerchant = (SubMerchant)o;
        return Objects.equals(this.city, subMerchant.city) && Objects.equals(this.country, subMerchant.country) && Objects.equals(this.mcc, subMerchant.mcc) && Objects.equals(this.name, subMerchant.name) && Objects.equals(this.taxId, subMerchant.taxId);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.mcc, this.name, this.taxId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubMerchant {\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    taxId: ").append(this.toIndentedString(this.taxId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SubMerchant is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SubMerchant` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CITY) != null && !jsonObj.get(SERIALIZED_NAME_CITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAX_ID) != null && !jsonObj.get(SERIALIZED_NAME_TAX_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `taxId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAX_ID).toString()));
        }
    }

    public static SubMerchant fromJson(String jsonString) throws IOException {
        return (SubMerchant)JSON.getGson().fromJson(jsonString, SubMerchant.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CITY);
        openapiFields.add(SERIALIZED_NAME_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TAX_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SubMerchant.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SubMerchant.class));
            return new TypeAdapter<SubMerchant>(){

                public void write(JsonWriter out, SubMerchant value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SubMerchant read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SubMerchant.validateJsonObject(jsonObj);
                    return (SubMerchant)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

