/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Address;
import com.adyen.model.payment.Card;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.Name;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FundSource {
    public static final String SERIALIZED_NAME_ADDITIONAL_DATA = "additionalData";
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private Card card;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FundSource additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public FundSource putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @ApiModelProperty(value="A map of name-value pairs for passing additional or industry-specific data.")
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public FundSource billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public FundSource card(Card card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public FundSource shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="Email address of the person.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public FundSource shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public FundSource telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="Phone number of the person")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FundSource fundSource = (FundSource)o;
        return Objects.equals(this.additionalData, fundSource.additionalData) && Objects.equals(this.billingAddress, fundSource.billingAddress) && Objects.equals(this.card, fundSource.card) && Objects.equals(this.shopperEmail, fundSource.shopperEmail) && Objects.equals(this.shopperName, fundSource.shopperName) && Objects.equals(this.telephoneNumber, fundSource.telephoneNumber);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.billingAddress, this.card, this.shopperEmail, this.shopperName, this.telephoneNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FundSource {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in FundSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FundSource` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD) != null) {
            Card.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
    }

    public static FundSource fromJson(String jsonString) throws IOException {
        return (FundSource)JSON.getGson().fromJson(jsonString, FundSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_DATA);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_CARD);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FundSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FundSource.class));
            return new TypeAdapter<FundSource>(){

                public void write(JsonWriter out, FundSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FundSource read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    FundSource.validateJsonObject(jsonObj);
                    return (FundSource)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

