/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.ApplePayInfo;
import com.adyen.model.management.BcmcInfo;
import com.adyen.model.management.CartesBancairesInfo;
import com.adyen.model.management.GiroPayInfo;
import com.adyen.model.management.GooglePayInfo;
import com.adyen.model.management.JSON;
import com.adyen.model.management.KlarnaInfo;
import com.adyen.model.management.MealVoucherFRInfo;
import com.adyen.model.management.PayPalInfo;
import com.adyen.model.management.SofortInfo;
import com.adyen.model.management.SwishInfo;
import com.adyen.model.management.VippsInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentMethod {
    public static final String SERIALIZED_NAME_ALLOWED = "allowed";
    @SerializedName(value="allowed")
    private Boolean allowed;
    public static final String SERIALIZED_NAME_APPLE_PAY = "applePay";
    @SerializedName(value="applePay")
    private ApplePayInfo applePay;
    public static final String SERIALIZED_NAME_BCMC = "bcmc";
    @SerializedName(value="bcmc")
    private BcmcInfo bcmc;
    public static final String SERIALIZED_NAME_BUSINESS_LINE_ID = "businessLineId";
    @SerializedName(value="businessLineId")
    private String businessLineId;
    public static final String SERIALIZED_NAME_CARTES_BANCAIRES = "cartesBancaires";
    @SerializedName(value="cartesBancaires")
    private CartesBancairesInfo cartesBancaires;
    public static final String SERIALIZED_NAME_COUNTRIES = "countries";
    @SerializedName(value="countries")
    private List<String> countries = null;
    public static final String SERIALIZED_NAME_CURRENCIES = "currencies";
    @SerializedName(value="currencies")
    private List<String> currencies = null;
    public static final String SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
    @SerializedName(value="customRoutingFlags")
    private List<String> customRoutingFlags = null;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_GIRO_PAY = "giroPay";
    @SerializedName(value="giroPay")
    private GiroPayInfo giroPay;
    public static final String SERIALIZED_NAME_GOOGLE_PAY = "googlePay";
    @SerializedName(value="googlePay")
    private GooglePayInfo googlePay;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_KLARNA = "klarna";
    @SerializedName(value="klarna")
    private KlarnaInfo klarna;
    public static final String SERIALIZED_NAME_MEAL_VOUCHER_F_R = "mealVoucher_FR";
    @SerializedName(value="mealVoucher_FR")
    private MealVoucherFRInfo mealVoucherFR;
    public static final String SERIALIZED_NAME_PAYPAL = "paypal";
    @SerializedName(value="paypal")
    private PayPalInfo paypal;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
    @SerializedName(value="shopperInteraction")
    private String shopperInteraction;
    public static final String SERIALIZED_NAME_SOFORT = "sofort";
    @SerializedName(value="sofort")
    private SofortInfo sofort;
    public static final String SERIALIZED_NAME_STORE_ID = "storeId";
    @SerializedName(value="storeId")
    private String storeId;
    public static final String SERIALIZED_NAME_SWISH = "swish";
    @SerializedName(value="swish")
    private SwishInfo swish;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VERIFICATION_STATUS = "verificationStatus";
    @SerializedName(value="verificationStatus")
    private VerificationStatusEnum verificationStatus;
    public static final String SERIALIZED_NAME_VIPPS = "vipps";
    @SerializedName(value="vipps")
    private VippsInfo vipps;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentMethod allowed(Boolean allowed) {
        this.allowed = allowed;
        return this;
    }

    @ApiModelProperty(value="Indicates whether receiving payments is allowed. This value is set to **true** by Adyen after screening your merchant account.")
    public Boolean getAllowed() {
        return this.allowed;
    }

    public void setAllowed(Boolean allowed) {
        this.allowed = allowed;
    }

    public PaymentMethod applePay(ApplePayInfo applePay) {
        this.applePay = applePay;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplePayInfo getApplePay() {
        return this.applePay;
    }

    public void setApplePay(ApplePayInfo applePay) {
        this.applePay = applePay;
    }

    public PaymentMethod bcmc(BcmcInfo bcmc) {
        this.bcmc = bcmc;
        return this;
    }

    @ApiModelProperty(value="")
    public BcmcInfo getBcmc() {
        return this.bcmc;
    }

    public void setBcmc(BcmcInfo bcmc) {
        this.bcmc = bcmc;
    }

    public PaymentMethod businessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the business line.")
    public String getBusinessLineId() {
        return this.businessLineId;
    }

    public void setBusinessLineId(String businessLineId) {
        this.businessLineId = businessLineId;
    }

    public PaymentMethod cartesBancaires(CartesBancairesInfo cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
        return this;
    }

    @ApiModelProperty(value="")
    public CartesBancairesInfo getCartesBancaires() {
        return this.cartesBancaires;
    }

    public void setCartesBancaires(CartesBancairesInfo cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
    }

    public PaymentMethod countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    public PaymentMethod addCountriesItem(String countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @ApiModelProperty(value="The list of countries where a payment method is available. By default, all countries supported by the payment method.")
    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public PaymentMethod currencies(List<String> currencies) {
        this.currencies = currencies;
        return this;
    }

    public PaymentMethod addCurrenciesItem(String currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new ArrayList<String>();
        }
        this.currencies.add(currenciesItem);
        return this;
    }

    @ApiModelProperty(value="The list of currencies that a payment method supports. By default, all currencies supported by the payment method.")
    public List<String> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<String> currencies) {
        this.currencies = currencies;
    }

    public PaymentMethod customRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
        return this;
    }

    public PaymentMethod addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
        if (this.customRoutingFlags == null) {
            this.customRoutingFlags = new ArrayList<String>();
        }
        this.customRoutingFlags.add(customRoutingFlagsItem);
        return this;
    }

    @ApiModelProperty(value="The list of custom routing flags to route payment to the intended acquirer.")
    public List<String> getCustomRoutingFlags() {
        return this.customRoutingFlags;
    }

    public void setCustomRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
    }

    public PaymentMethod enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the payment method is enabled (**true**) or disabled (**false**).")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public PaymentMethod giroPay(GiroPayInfo giroPay) {
        this.giroPay = giroPay;
        return this;
    }

    @ApiModelProperty(value="")
    public GiroPayInfo getGiroPay() {
        return this.giroPay;
    }

    public void setGiroPay(GiroPayInfo giroPay) {
        this.giroPay = giroPay;
    }

    public PaymentMethod googlePay(GooglePayInfo googlePay) {
        this.googlePay = googlePay;
        return this;
    }

    @ApiModelProperty(value="")
    public GooglePayInfo getGooglePay() {
        return this.googlePay;
    }

    public void setGooglePay(GooglePayInfo googlePay) {
        this.googlePay = googlePay;
    }

    public PaymentMethod id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the resource.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public PaymentMethod klarna(KlarnaInfo klarna) {
        this.klarna = klarna;
        return this;
    }

    @ApiModelProperty(value="")
    public KlarnaInfo getKlarna() {
        return this.klarna;
    }

    public void setKlarna(KlarnaInfo klarna) {
        this.klarna = klarna;
    }

    public PaymentMethod mealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
        this.mealVoucherFR = mealVoucherFR;
        return this;
    }

    @ApiModelProperty(value="")
    public MealVoucherFRInfo getMealVoucherFR() {
        return this.mealVoucherFR;
    }

    public void setMealVoucherFR(MealVoucherFRInfo mealVoucherFR) {
        this.mealVoucherFR = mealVoucherFR;
    }

    public PaymentMethod paypal(PayPalInfo paypal) {
        this.paypal = paypal;
        return this;
    }

    @ApiModelProperty(value="")
    public PayPalInfo getPaypal() {
        return this.paypal;
    }

    public void setPaypal(PayPalInfo paypal) {
        this.paypal = paypal;
    }

    public PaymentMethod reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the payment method. Supported characters a-z, A-Z, 0-9.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentMethod shopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="The sales channel.")
    public String getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(String shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public PaymentMethod sofort(SofortInfo sofort) {
        this.sofort = sofort;
        return this;
    }

    @ApiModelProperty(value="")
    public SofortInfo getSofort() {
        return this.sofort;
    }

    public void setSofort(SofortInfo sofort) {
        this.sofort = sofort;
    }

    public PaymentMethod storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @ApiModelProperty(value="The ID of the [store](https://docs.adyen.com/api-explorer/#/ManagementService/latest/post/stores__resParam_id), if any.")
    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public PaymentMethod swish(SwishInfo swish) {
        this.swish = swish;
        return this;
    }

    @ApiModelProperty(value="")
    public SwishInfo getSwish() {
        return this.swish;
    }

    public void setSwish(SwishInfo swish) {
        this.swish = swish;
    }

    public PaymentMethod type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Payment method [variant](https://docs.adyen.com/development-resources/paymentmethodvariant#management-api).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public PaymentMethod verificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
        return this;
    }

    @ApiModelProperty(value="Payment method status. Possible values: * **valid** * **pending** * **invalid** * **rejected**")
    public VerificationStatusEnum getVerificationStatus() {
        return this.verificationStatus;
    }

    public void setVerificationStatus(VerificationStatusEnum verificationStatus) {
        this.verificationStatus = verificationStatus;
    }

    public PaymentMethod vipps(VippsInfo vipps) {
        this.vipps = vipps;
        return this;
    }

    @ApiModelProperty(value="")
    public VippsInfo getVipps() {
        return this.vipps;
    }

    public void setVipps(VippsInfo vipps) {
        this.vipps = vipps;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentMethod paymentMethod = (PaymentMethod)o;
        return Objects.equals(this.allowed, paymentMethod.allowed) && Objects.equals(this.applePay, paymentMethod.applePay) && Objects.equals(this.bcmc, paymentMethod.bcmc) && Objects.equals(this.businessLineId, paymentMethod.businessLineId) && Objects.equals(this.cartesBancaires, paymentMethod.cartesBancaires) && Objects.equals(this.countries, paymentMethod.countries) && Objects.equals(this.currencies, paymentMethod.currencies) && Objects.equals(this.customRoutingFlags, paymentMethod.customRoutingFlags) && Objects.equals(this.enabled, paymentMethod.enabled) && Objects.equals(this.giroPay, paymentMethod.giroPay) && Objects.equals(this.googlePay, paymentMethod.googlePay) && Objects.equals(this.id, paymentMethod.id) && Objects.equals(this.klarna, paymentMethod.klarna) && Objects.equals(this.mealVoucherFR, paymentMethod.mealVoucherFR) && Objects.equals(this.paypal, paymentMethod.paypal) && Objects.equals(this.reference, paymentMethod.reference) && Objects.equals(this.shopperInteraction, paymentMethod.shopperInteraction) && Objects.equals(this.sofort, paymentMethod.sofort) && Objects.equals(this.storeId, paymentMethod.storeId) && Objects.equals(this.swish, paymentMethod.swish) && Objects.equals(this.type, paymentMethod.type) && Objects.equals((Object)this.verificationStatus, (Object)paymentMethod.verificationStatus) && Objects.equals(this.vipps, paymentMethod.vipps);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowed, this.applePay, this.bcmc, this.businessLineId, this.cartesBancaires, this.countries, this.currencies, this.customRoutingFlags, this.enabled, this.giroPay, this.googlePay, this.id, this.klarna, this.mealVoucherFR, this.paypal, this.reference, this.shopperInteraction, this.sofort, this.storeId, this.swish, this.type, this.verificationStatus, this.vipps});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentMethod {\n");
        sb.append("    allowed: ").append(this.toIndentedString(this.allowed)).append("\n");
        sb.append("    applePay: ").append(this.toIndentedString(this.applePay)).append("\n");
        sb.append("    bcmc: ").append(this.toIndentedString(this.bcmc)).append("\n");
        sb.append("    businessLineId: ").append(this.toIndentedString(this.businessLineId)).append("\n");
        sb.append("    cartesBancaires: ").append(this.toIndentedString(this.cartesBancaires)).append("\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    customRoutingFlags: ").append(this.toIndentedString(this.customRoutingFlags)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    giroPay: ").append(this.toIndentedString(this.giroPay)).append("\n");
        sb.append("    googlePay: ").append(this.toIndentedString(this.googlePay)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    klarna: ").append(this.toIndentedString(this.klarna)).append("\n");
        sb.append("    mealVoucherFR: ").append(this.toIndentedString(this.mealVoucherFR)).append("\n");
        sb.append("    paypal: ").append(this.toIndentedString(this.paypal)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString(this.shopperInteraction)).append("\n");
        sb.append("    sofort: ").append(this.toIndentedString(this.sofort)).append("\n");
        sb.append("    storeId: ").append(this.toIndentedString(this.storeId)).append("\n");
        sb.append("    swish: ").append(this.toIndentedString(this.swish)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    verificationStatus: ").append(this.toIndentedString((Object)this.verificationStatus)).append("\n");
        sb.append("    vipps: ").append(this.toIndentedString(this.vipps)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentMethod is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentMethod` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLE_PAY) != null) {
            ApplePayInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLE_PAY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BCMC) != null) {
            BcmcInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BCMC));
        }
        if (jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID) != null && !jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `businessLineId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BUSINESS_LINE_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARTES_BANCAIRES) != null) {
            CartesBancairesInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARTES_BANCAIRES));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRIES) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `countries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCIES) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `currencies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoutingFlags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GIRO_PAY) != null) {
            GiroPayInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GIRO_PAY));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GOOGLE_PAY) != null) {
            GooglePayInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GOOGLE_PAY));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_KLARNA) != null) {
            KlarnaInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_KLARNA));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MEAL_VOUCHER_F_R) != null) {
            MealVoucherFRInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEAL_VOUCHER_F_R));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYPAL) != null) {
            PayPalInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PAYPAL));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SOFORT) != null) {
            SofortInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SOFORT));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SWISH) != null) {
            SwishInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SWISH));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `verificationStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).toString()));
            }
            VerificationStatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_VERIFICATION_STATUS).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_VIPPS) != null) {
            VippsInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_VIPPS));
        }
    }

    public static PaymentMethod fromJson(String jsonString) throws IOException {
        return (PaymentMethod)JSON.getGson().fromJson(jsonString, PaymentMethod.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED);
        openapiFields.add(SERIALIZED_NAME_APPLE_PAY);
        openapiFields.add(SERIALIZED_NAME_BCMC);
        openapiFields.add(SERIALIZED_NAME_BUSINESS_LINE_ID);
        openapiFields.add(SERIALIZED_NAME_CARTES_BANCAIRES);
        openapiFields.add(SERIALIZED_NAME_COUNTRIES);
        openapiFields.add(SERIALIZED_NAME_CURRENCIES);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_GIRO_PAY);
        openapiFields.add(SERIALIZED_NAME_GOOGLE_PAY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_KLARNA);
        openapiFields.add(SERIALIZED_NAME_MEAL_VOUCHER_F_R);
        openapiFields.add(SERIALIZED_NAME_PAYPAL);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_SOFORT);
        openapiFields.add(SERIALIZED_NAME_STORE_ID);
        openapiFields.add(SERIALIZED_NAME_SWISH);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_VERIFICATION_STATUS);
        openapiFields.add(SERIALIZED_NAME_VIPPS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentMethod.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentMethod.class));
            return new TypeAdapter<PaymentMethod>(){

                public void write(JsonWriter out, PaymentMethod value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentMethod read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentMethod.validateJsonObject(jsonObj);
                    return (PaymentMethod)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerificationStatusEnum {
        VALID("valid"),
        PENDING("pending"),
        INVALID("invalid"),
        REJECTED("rejected");

        private String value;

        private VerificationStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerificationStatusEnum fromValue(String value) {
            for (VerificationStatusEnum b : VerificationStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VerificationStatusEnum> {
            public void write(JsonWriter jsonWriter, VerificationStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerificationStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerificationStatusEnum.fromValue(value);
            }
        }
    }
}

