/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SourceOfFunds {
    public static final String SERIALIZED_NAME_ACQUIRING_BUSINESS_LINE_ID = "acquiringBusinessLineId";
    @Deprecated
    @SerializedName(value="acquiringBusinessLineId")
    private String acquiringBusinessLineId;
    public static final String SERIALIZED_NAME_ADYEN_PROCESSED_FUNDS = "adyenProcessedFunds";
    @SerializedName(value="adyenProcessedFunds")
    private Boolean adyenProcessedFunds;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    @Deprecated
    public SourceOfFunds acquiringBusinessLineId(String acquiringBusinessLineId) {
        this.acquiringBusinessLineId = acquiringBusinessLineId;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The unique identifier of the business line that will be the source of funds.This must be a business line for a **receivePayments** or **receiveFromPlatformPayments** capability.")
    public String getAcquiringBusinessLineId() {
        return this.acquiringBusinessLineId;
    }

    @Deprecated
    public void setAcquiringBusinessLineId(String acquiringBusinessLineId) {
        this.acquiringBusinessLineId = acquiringBusinessLineId;
    }

    public SourceOfFunds adyenProcessedFunds(Boolean adyenProcessedFunds) {
        this.adyenProcessedFunds = adyenProcessedFunds;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the funds are coming from transactions processed by Adyen. If **false**, a `description` is required.")
    public Boolean getAdyenProcessedFunds() {
        return this.adyenProcessedFunds;
    }

    public void setAdyenProcessedFunds(Boolean adyenProcessedFunds) {
        this.adyenProcessedFunds = adyenProcessedFunds;
    }

    public SourceOfFunds description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Text describing the source of funds. For example, for `type` **business**, provide a description of where the business transactions come from, such as payments through bank transfer. Required when `adyenProcessedFunds` is **false**.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SourceOfFunds type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the source of funds. Possible value: **business**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceOfFunds sourceOfFunds = (SourceOfFunds)o;
        return Objects.equals(this.acquiringBusinessLineId, sourceOfFunds.acquiringBusinessLineId) && Objects.equals(this.adyenProcessedFunds, sourceOfFunds.adyenProcessedFunds) && Objects.equals(this.description, sourceOfFunds.description) && Objects.equals((Object)this.type, (Object)sourceOfFunds.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acquiringBusinessLineId, this.adyenProcessedFunds, this.description, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SourceOfFunds {\n");
        sb.append("    acquiringBusinessLineId: ").append(this.toIndentedString(this.acquiringBusinessLineId)).append("\n");
        sb.append("    adyenProcessedFunds: ").append(this.toIndentedString(this.adyenProcessedFunds)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SourceOfFunds is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SourceOfFunds` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACQUIRING_BUSINESS_LINE_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACQUIRING_BUSINESS_LINE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acquiringBusinessLineId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACQUIRING_BUSINESS_LINE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static SourceOfFunds fromJson(String jsonString) throws IOException {
        return (SourceOfFunds)JSON.getGson().fromJson(jsonString, SourceOfFunds.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACQUIRING_BUSINESS_LINE_ID);
        openapiFields.add(SERIALIZED_NAME_ADYEN_PROCESSED_FUNDS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SourceOfFunds.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SourceOfFunds.class));
            return new TypeAdapter<SourceOfFunds>(){

                public void write(JsonWriter out, SourceOfFunds value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SourceOfFunds read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SourceOfFunds.validateJsonObject(jsonObj);
                    return (SourceOfFunds)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BUSINESS("business");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

