/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LegalEntityAssociation {
    public static final String SERIALIZED_NAME_ASSOCIATOR_ID = "associatorId";
    @SerializedName(value="associatorId")
    private String associatorId;
    public static final String SERIALIZED_NAME_ENTITY_TYPE = "entityType";
    @SerializedName(value="entityType")
    private String entityType;
    public static final String SERIALIZED_NAME_JOB_TITLE = "jobTitle";
    @SerializedName(value="jobTitle")
    private String jobTitle;
    public static final String SERIALIZED_NAME_LEGAL_ENTITY_ID = "legalEntityId";
    @SerializedName(value="legalEntityId")
    private String legalEntityId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LegalEntityAssociation() {
    }

    public LegalEntityAssociation(String associatorId, String entityType, String name) {
        this();
        this.associatorId = associatorId;
        this.entityType = entityType;
        this.name = name;
    }

    @ApiModelProperty(value="The unique identifier of another legal entity with which the `legalEntityId` is associated. When the `legalEntityId` is associated to legal entities other than the current one, the response returns all the associations.")
    public String getAssociatorId() {
        return this.associatorId;
    }

    @ApiModelProperty(value="The legal entity type of associated legal entity.  For example, **organization**, **soleProprietorship** or **individual**.")
    public String getEntityType() {
        return this.entityType;
    }

    public LegalEntityAssociation jobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ApiModelProperty(value="The individual's job title if the `type` is **uboThroughControl** or **signatory**.")
    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public LegalEntityAssociation legalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).")
    public String getLegalEntityId() {
        return this.legalEntityId;
    }

    public void setLegalEntityId(String legalEntityId) {
        this.legalEntityId = legalEntityId;
    }

    @ApiModelProperty(value="The name of the associated [legal entity](https://docs.adyen.com/api-explorer/legalentity/latest/post/legalEntities#responses-200-id).  - For **individual**, `name.firstName` and `name.lastName`. - For **organization**, `legalName`. - For **soleProprietorship**, `name`.")
    public String getName() {
        return this.name;
    }

    public LegalEntityAssociation type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="Defines the relationship of the legal entity to the current legal entity.  Possible values for organizations: **uboThroughOwnership**, **uboThroughControl**, **signatory**, or **ultimateParentCompany**.  Possible values for sole proprietorships: **soleProprietorship**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityAssociation legalEntityAssociation = (LegalEntityAssociation)o;
        return Objects.equals(this.associatorId, legalEntityAssociation.associatorId) && Objects.equals(this.entityType, legalEntityAssociation.entityType) && Objects.equals(this.jobTitle, legalEntityAssociation.jobTitle) && Objects.equals(this.legalEntityId, legalEntityAssociation.legalEntityId) && Objects.equals(this.name, legalEntityAssociation.name) && Objects.equals((Object)this.type, (Object)legalEntityAssociation.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.associatorId, this.entityType, this.jobTitle, this.legalEntityId, this.name, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityAssociation {\n");
        sb.append("    associatorId: ").append(this.toIndentedString(this.associatorId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString(this.entityType)).append("\n");
        sb.append("    jobTitle: ").append(this.toIndentedString(this.jobTitle)).append("\n");
        sb.append("    legalEntityId: ").append(this.toIndentedString(this.legalEntityId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LegalEntityAssociation is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LegalEntityAssociation` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSOCIATOR_ID) != null && !jsonObj.get(SERIALIZED_NAME_ASSOCIATOR_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `associatorId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ASSOCIATOR_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `entityType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENTITY_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JOB_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_JOB_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `jobTitle` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JOB_TITLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID) != null && !jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `legalEntityId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LEGAL_ENTITY_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static LegalEntityAssociation fromJson(String jsonString) throws IOException {
        return (LegalEntityAssociation)JSON.getGson().fromJson(jsonString, LegalEntityAssociation.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ASSOCIATOR_ID);
        openapiFields.add(SERIALIZED_NAME_ENTITY_TYPE);
        openapiFields.add(SERIALIZED_NAME_JOB_TITLE);
        openapiFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LEGAL_ENTITY_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LegalEntityAssociation.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LegalEntityAssociation.class));
            return new TypeAdapter<LegalEntityAssociation>(){

                public void write(JsonWriter out, LegalEntityAssociation value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LegalEntityAssociation read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LegalEntityAssociation.validateJsonObject(jsonObj);
                    return (LegalEntityAssociation)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PCISIGNATORY("pciSignatory"),
        SIGNATORY("signatory"),
        SOLEPROPRIETORSHIP("soleProprietorship"),
        UBOTHROUGHCONTROL("uboThroughControl"),
        UBOTHROUGHOWNERSHIP("uboThroughOwnership"),
        ULTIMATEPARENTCOMPANY("ultimateParentCompany");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

