/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.adyen.model.checkout.StoredDetails;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RecurringDetail {
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private String brand;
    public static final String SERIALIZED_NAME_BRANDS = "brands";
    @SerializedName(value="brands")
    private List<String> brands = null;
    public static final String SERIALIZED_NAME_CONFIGURATION = "configuration";
    @SerializedName(value="configuration")
    private Map<String, String> configuration = null;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private PaymentMethodGroup group;
    public static final String SERIALIZED_NAME_INPUT_DETAILS = "inputDetails";
    @Deprecated
    @SerializedName(value="inputDetails")
    private List<InputDetail> inputDetails = null;
    public static final String SERIALIZED_NAME_ISSUERS = "issuers";
    @SerializedName(value="issuers")
    private List<PaymentMethodIssuer> issuers = null;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_STORED_DETAILS = "storedDetails";
    @SerializedName(value="storedDetails")
    private StoredDetails storedDetails;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public RecurringDetail brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="Brand for the selected gift card. For example: plastix, hmclub.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public RecurringDetail brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public RecurringDetail addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @ApiModelProperty(value="List of possible brands. For example: visa, mc.")
    public List<String> getBrands() {
        return this.brands;
    }

    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public RecurringDetail configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public RecurringDetail putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @ApiModelProperty(value="The configuration of the payment method.")
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public RecurringDetail fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source of the payment method.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public RecurringDetail group(PaymentMethodGroup group) {
        this.group = group;
        return this;
    }

    @ApiModelProperty(value="")
    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
    }

    @Deprecated
    public RecurringDetail inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public RecurringDetail addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="All input details to be provided to complete the payment with this payment method.")
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    @Deprecated
    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public RecurringDetail issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        return this;
    }

    public RecurringDetail addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    @ApiModelProperty(value="A list of issuers for this payment method.")
    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
    }

    public RecurringDetail name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The displayable name of this payment method.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecurringDetail recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The reference that uniquely identifies the recurring detail.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public RecurringDetail storedDetails(StoredDetails storedDetails) {
        this.storedDetails = storedDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public StoredDetails getStoredDetails() {
        return this.storedDetails;
    }

    public void setStoredDetails(StoredDetails storedDetails) {
        this.storedDetails = storedDetails;
    }

    public RecurringDetail type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The unique payment method code.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringDetail recurringDetail = (RecurringDetail)o;
        return Objects.equals(this.brand, recurringDetail.brand) && Objects.equals(this.brands, recurringDetail.brands) && Objects.equals(this.configuration, recurringDetail.configuration) && Objects.equals((Object)this.fundingSource, (Object)recurringDetail.fundingSource) && Objects.equals(this.group, recurringDetail.group) && Objects.equals(this.inputDetails, recurringDetail.inputDetails) && Objects.equals(this.issuers, recurringDetail.issuers) && Objects.equals(this.name, recurringDetail.name) && Objects.equals(this.recurringDetailReference, recurringDetail.recurringDetailReference) && Objects.equals(this.storedDetails, recurringDetail.storedDetails) && Objects.equals(this.type, recurringDetail.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.brands, this.configuration, this.fundingSource, this.group, this.inputDetails, this.issuers, this.name, this.recurringDetailReference, this.storedDetails, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringDetail {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    issuers: ").append(this.toIndentedString(this.issuers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedDetails: ").append(this.toIndentedString(this.storedDetails)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayissuers;
        JsonArray jsonArrayinputDetails;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in RecurringDetail is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `RecurringDetail` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRANDS) != null && !jsonObj.get(SERIALIZED_NAME_BRANDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `brands` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRANDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
            }
            FundingSourceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GROUP) != null) {
            PaymentMethodGroup.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GROUP));
        }
        if ((jsonArrayinputDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_INPUT_DETAILS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INPUT_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `inputDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INPUT_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArrayinputDetails.size(); ++i) {
                InputDetail.validateJsonObject(jsonArrayinputDetails.get(i).getAsJsonObject());
            }
        }
        if ((jsonArrayissuers = jsonObj.getAsJsonArray(SERIALIZED_NAME_ISSUERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ISSUERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `issuers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUERS).toString()));
            }
            for (int i = 0; i < jsonArrayissuers.size(); ++i) {
                PaymentMethodIssuer.validateJsonObject(jsonArrayissuers.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_STORED_DETAILS) != null) {
            StoredDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_STORED_DETAILS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static RecurringDetail fromJson(String jsonString) throws IOException {
        return (RecurringDetail)JSON.getGson().fromJson(jsonString, RecurringDetail.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BRAND);
        openapiFields.add(SERIALIZED_NAME_BRANDS);
        openapiFields.add(SERIALIZED_NAME_CONFIGURATION);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_INPUT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_ISSUERS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_DETAILS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RecurringDetail.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RecurringDetail.class));
            return new TypeAdapter<RecurringDetail>(){

                public void write(JsonWriter out, RecurringDetail value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RecurringDetail read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    RecurringDetail.validateJsonObject(jsonObj);
                    return (RecurringDetail)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

