/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.RecurringDetail;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentSetupResponse {
    public static final String SERIALIZED_NAME_PAYMENT_SESSION = "paymentSession";
    @SerializedName(value="paymentSession")
    private String paymentSession;
    public static final String SERIALIZED_NAME_RECURRING_DETAILS = "recurringDetails";
    @Deprecated
    @SerializedName(value="recurringDetails")
    private List<RecurringDetail> recurringDetails = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentSetupResponse paymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
        return this;
    }

    @ApiModelProperty(value="The encoded payment session that you need to pass to the SDK.")
    public String getPaymentSession() {
        return this.paymentSession;
    }

    public void setPaymentSession(String paymentSession) {
        this.paymentSession = paymentSession;
    }

    @Deprecated
    public PaymentSetupResponse recurringDetails(List<RecurringDetail> recurringDetails) {
        this.recurringDetails = recurringDetails;
        return this;
    }

    public PaymentSetupResponse addRecurringDetailsItem(RecurringDetail recurringDetailsItem) {
        if (this.recurringDetails == null) {
            this.recurringDetails = new ArrayList<RecurringDetail>();
        }
        this.recurringDetails.add(recurringDetailsItem);
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The detailed list of stored payment details required to generate payment forms. Will be empty if oneClick is set to false in the request.")
    public List<RecurringDetail> getRecurringDetails() {
        return this.recurringDetails;
    }

    @Deprecated
    public void setRecurringDetails(List<RecurringDetail> recurringDetails) {
        this.recurringDetails = recurringDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentSetupResponse paymentSetupResponse = (PaymentSetupResponse)o;
        return Objects.equals(this.paymentSession, paymentSetupResponse.paymentSession) && Objects.equals(this.recurringDetails, paymentSetupResponse.recurringDetails);
    }

    public int hashCode() {
        return Objects.hash(this.paymentSession, this.recurringDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentSetupResponse {\n");
        sb.append("    paymentSession: ").append(this.toIndentedString(this.paymentSession)).append("\n");
        sb.append("    recurringDetails: ").append(this.toIndentedString(this.recurringDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentSetupResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentSetupResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_SESSION) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_SESSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentSession` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_SESSION).toString()));
        }
        JsonArray jsonArrayrecurringDetails = jsonObj.getAsJsonArray(SERIALIZED_NAME_RECURRING_DETAILS);
        if (jsonArrayrecurringDetails != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECURRING_DETAILS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `recurringDetails` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAILS).toString()));
            }
            for (int i = 0; i < jsonArrayrecurringDetails.size(); ++i) {
                RecurringDetail.validateJsonObject(jsonArrayrecurringDetails.get(i).getAsJsonObject());
            }
        }
    }

    public static PaymentSetupResponse fromJson(String jsonString) throws IOException {
        return (PaymentSetupResponse)JSON.getGson().fromJson(jsonString, PaymentSetupResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PAYMENT_SESSION);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAILS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentSetupResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentSetupResponse.class));
            return new TypeAdapter<PaymentSetupResponse>(){

                public void write(JsonWriter out, PaymentSetupResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentSetupResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentSetupResponse.validateJsonObject(jsonObj);
                    return (PaymentSetupResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

