/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Address;
import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.ApplicationInfo;
import com.adyen.model.checkout.InstallmentOption;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.Name;
import com.adyen.model.checkout.RiskData;
import com.adyen.model.checkout.Split;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentLinkResponse {
    public static final String SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS = "allowedPaymentMethods";
    @SerializedName(value="allowedPaymentMethods")
    private List<String> allowedPaymentMethods = null;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_APPLICATION_INFO = "applicationInfo";
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo;
    public static final String SERIALIZED_NAME_BILLING_ADDRESS = "billingAddress";
    @SerializedName(value="billingAddress")
    private Address billingAddress;
    public static final String SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS = "blockedPaymentMethods";
    @SerializedName(value="blockedPaymentMethods")
    private List<String> blockedPaymentMethods = null;
    public static final String SERIALIZED_NAME_CAPTURE_DELAY_HOURS = "captureDelayHours";
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "countryCode";
    @SerializedName(value="countryCode")
    private String countryCode;
    public static final String SERIALIZED_NAME_DATE_OF_BIRTH = "dateOfBirth";
    @SerializedName(value="dateOfBirth")
    private LocalDate dateOfBirth;
    public static final String SERIALIZED_NAME_DELIVER_AT = "deliverAt";
    @SerializedName(value="deliverAt")
    private OffsetDateTime deliverAt;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS = "deliveryAddress";
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private String expiresAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_INSTALLMENT_OPTIONS = "installmentOptions";
    @SerializedName(value="installmentOptions")
    private Map<String, InstallmentOption> installmentOptions = null;
    public static final String SERIALIZED_NAME_LINE_ITEMS = "lineItems";
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    public static final String SERIALIZED_NAME_MANUAL_CAPTURE = "manualCapture";
    @SerializedName(value="manualCapture")
    private Boolean manualCapture;
    public static final String SERIALIZED_NAME_MCC = "mcc";
    @SerializedName(value="mcc")
    private String mcc;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE = "merchantOrderReference";
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    public static final String SERIALIZED_NAME_RECURRING_PROCESSING_MODEL = "recurringProcessingModel";
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS = "requiredShopperFields";
    @SerializedName(value="requiredShopperFields")
    private List<RequiredShopperFieldsEnum> requiredShopperFields = null;
    public static final String SERIALIZED_NAME_RETURN_URL = "returnUrl";
    @SerializedName(value="returnUrl")
    private String returnUrl;
    public static final String SERIALIZED_NAME_REUSABLE = "reusable";
    @SerializedName(value="reusable")
    private Boolean reusable;
    public static final String SERIALIZED_NAME_RISK_DATA = "riskData";
    @SerializedName(value="riskData")
    private RiskData riskData;
    public static final String SERIALIZED_NAME_SHOPPER_EMAIL = "shopperEmail";
    @SerializedName(value="shopperEmail")
    private String shopperEmail;
    public static final String SERIALIZED_NAME_SHOPPER_LOCALE = "shopperLocale";
    @SerializedName(value="shopperLocale")
    private String shopperLocale;
    public static final String SERIALIZED_NAME_SHOPPER_NAME = "shopperName";
    @SerializedName(value="shopperName")
    private Name shopperName;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private String shopperStatement;
    public static final String SERIALIZED_NAME_SHOW_REMOVE_PAYMENT_METHOD_BUTTON = "showRemovePaymentMethodButton";
    @SerializedName(value="showRemovePaymentMethodButton")
    private Boolean showRemovePaymentMethodButton = true;
    public static final String SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber;
    public static final String SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES = "splitCardFundingSources";
    @SerializedName(value="splitCardFundingSources")
    private Boolean splitCardFundingSources = false;
    public static final String SERIALIZED_NAME_SPLITS = "splits";
    @SerializedName(value="splits")
    private List<Split> splits = null;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_STORE = "store";
    @SerializedName(value="store")
    private String store;
    public static final String SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE = "storePaymentMethodMode";
    @SerializedName(value="storePaymentMethodMode")
    private StorePaymentMethodModeEnum storePaymentMethodMode;
    public static final String SERIALIZED_NAME_TELEPHONE_NUMBER = "telephoneNumber";
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber;
    public static final String SERIALIZED_NAME_THEME_ID = "themeId";
    @SerializedName(value="themeId")
    private String themeId;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentLinkResponse() {
    }

    public PaymentLinkResponse(String id, String url) {
        this();
        this.id = id;
        this.url = url;
    }

    public PaymentLinkResponse allowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
        return this;
    }

    public PaymentLinkResponse addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
        if (this.allowedPaymentMethods == null) {
            this.allowedPaymentMethods = new ArrayList<String>();
        }
        this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be presented to the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getAllowedPaymentMethods() {
        return this.allowedPaymentMethods;
    }

    public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
    }

    public PaymentLinkResponse amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public PaymentLinkResponse applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @ApiModelProperty(value="")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public PaymentLinkResponse billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public PaymentLinkResponse blockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
        return this;
    }

    public PaymentLinkResponse addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
        if (this.blockedPaymentMethods == null) {
            this.blockedPaymentMethods = new ArrayList<String>();
        }
        this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
        return this;
    }

    @ApiModelProperty(value="List of payment methods to be hidden from the shopper. To refer to payment methods, use their [payment method type](https://docs.adyen.com/payment-methods/payment-method-types).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getBlockedPaymentMethods() {
        return this.blockedPaymentMethods;
    }

    public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
    }

    public PaymentLinkResponse captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @ApiModelProperty(value="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public PaymentLinkResponse countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(value="The shopper's two-letter country code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PaymentLinkResponse dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @ApiModelProperty(value="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public PaymentLinkResponse deliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @ApiModelProperty(value="The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getDeliverAt() {
        return this.deliverAt;
    }

    public void setDeliverAt(OffsetDateTime deliverAt) {
        this.deliverAt = deliverAt;
    }

    public PaymentLinkResponse deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @ApiModelProperty(value="")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public PaymentLinkResponse description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A short description visible on the payment page. Maximum length: 280 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PaymentLinkResponse expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    @ApiModelProperty(required=true, value="A unique identifier of the payment link.")
    public String getId() {
        return this.id;
    }

    public PaymentLinkResponse installmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
        return this;
    }

    public PaymentLinkResponse putInstallmentOptionsItem(String key, InstallmentOption installmentOptionsItem) {
        if (this.installmentOptions == null) {
            this.installmentOptions = new HashMap<String, InstallmentOption>();
        }
        this.installmentOptions.put(key, installmentOptionsItem);
        return this;
    }

    @ApiModelProperty(value="A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")
    public Map<String, InstallmentOption> getInstallmentOptions() {
        return this.installmentOptions;
    }

    public void setInstallmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
    }

    public PaymentLinkResponse lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public PaymentLinkResponse addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @ApiModelProperty(value="Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public PaymentLinkResponse manualCapture(Boolean manualCapture) {
        this.manualCapture = manualCapture;
        return this;
    }

    @ApiModelProperty(value="Indicates if the payment must be [captured manually](https://docs.adyen.com/online-payments/capture).")
    public Boolean getManualCapture() {
        return this.manualCapture;
    }

    public void setManualCapture(Boolean manualCapture) {
        this.manualCapture = manualCapture;
    }

    public PaymentLinkResponse mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @ApiModelProperty(value="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public PaymentLinkResponse merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier for which the payment link is created.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public PaymentLinkResponse merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @ApiModelProperty(value="This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.")
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public PaymentLinkResponse metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public PaymentLinkResponse putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \"177\" occurs: \"Metadata size exceeds limit\" * Maximum 20 characters per key. Otherwise, error \"178\" occurs: \"Metadata key size exceeds limit\" * A key cannot have the name `checkout.linkId`. Any value that you provide with this key is going to be replaced by the real payment link ID.")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public PaymentLinkResponse recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @ApiModelProperty(value="Defines a recurring payment type. Required when creating a token to store payment details. Possible values: * **Subscription** \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public PaymentLinkResponse reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(required=true, value="A reference that is used to uniquely identify the payment in future communications about the payment status.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public PaymentLinkResponse requiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
        return this;
    }

    public PaymentLinkResponse addRequiredShopperFieldsItem(RequiredShopperFieldsEnum requiredShopperFieldsItem) {
        if (this.requiredShopperFields == null) {
            this.requiredShopperFields = new ArrayList<RequiredShopperFieldsEnum>();
        }
        this.requiredShopperFields.add(requiredShopperFieldsItem);
        return this;
    }

    @ApiModelProperty(value="List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** \u2013 The address where to send the invoice. * **deliveryAddress** \u2013 The address where the purchased goods should be delivered. * **shopperEmail** \u2013 The shopper's email address. * **shopperName** \u2013 The shopper's full name. * **telephoneNumber** \u2013 The shopper's phone number. ")
    public List<RequiredShopperFieldsEnum> getRequiredShopperFields() {
        return this.requiredShopperFields;
    }

    public void setRequiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
    }

    public PaymentLinkResponse returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(value="Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public PaymentLinkResponse reusable(Boolean reusable) {
        this.reusable = reusable;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.")
    public Boolean getReusable() {
        return this.reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public PaymentLinkResponse riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @ApiModelProperty(value="")
    public RiskData getRiskData() {
        return this.riskData;
    }

    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public PaymentLinkResponse shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @ApiModelProperty(value="The shopper's email address.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public PaymentLinkResponse shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @ApiModelProperty(value="The language to be used in the payment page, specified by a combination of a language and country code. For example, `en-US`.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#language).")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public PaymentLinkResponse shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @ApiModelProperty(value="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public PaymentLinkResponse shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public PaymentLinkResponse shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public PaymentLinkResponse showRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
        this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
        return this;
    }

    @ApiModelProperty(value="Set to **false** to hide the button that lets the shopper remove a stored payment method.")
    public Boolean getShowRemovePaymentMethodButton() {
        return this.showRemovePaymentMethodButton;
    }

    public void setShowRemovePaymentMethodButton(Boolean showRemovePaymentMethodButton) {
        this.showRemovePaymentMethodButton = showRemovePaymentMethodButton;
    }

    public PaymentLinkResponse socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public PaymentLinkResponse splitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
        return this;
    }

    @ApiModelProperty(value="Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
    public Boolean getSplitCardFundingSources() {
        return this.splitCardFundingSources;
    }

    public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
    }

    public PaymentLinkResponse splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public PaymentLinkResponse addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @ApiModelProperty(value="An array of objects specifying how the payment should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/marketplaces-and-platforms/processing-payments#providing-split-information).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentLinkResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="Status of the payment link. Possible values: * **active**: The link can be used to make payments. * **expired**: The expiry date for the payment link has passed. Shoppers can no longer use the link to make payments. * **completed**: The shopper completed the payment. * **paymentPending**: The shopper is in the process of making the payment. Applies to payment methods with an asynchronous flow.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PaymentLinkResponse store(String store) {
        this.store = store;
        return this;
    }

    @ApiModelProperty(value="The physical store, for which this payment is processed.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public PaymentLinkResponse storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
        return this;
    }

    @ApiModelProperty(value="Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** \u2013 No details will be stored (default). * **askForConsent** \u2013 If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** \u2013 If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.")
    public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
        return this.storePaymentMethodMode;
    }

    public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
    }

    public PaymentLinkResponse telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @ApiModelProperty(value="The shopper's telephone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public PaymentLinkResponse themeId(String themeId) {
        this.themeId = themeId;
        return this;
    }

    @ApiModelProperty(value="A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.")
    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public PaymentLinkResponse updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="The date when the payment link status was updated.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @ApiModelProperty(required=true, value="The URL at which the shopper can complete the payment.")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentLinkResponse paymentLinkResponse = (PaymentLinkResponse)o;
        return Objects.equals(this.allowedPaymentMethods, paymentLinkResponse.allowedPaymentMethods) && Objects.equals(this.amount, paymentLinkResponse.amount) && Objects.equals(this.applicationInfo, paymentLinkResponse.applicationInfo) && Objects.equals(this.billingAddress, paymentLinkResponse.billingAddress) && Objects.equals(this.blockedPaymentMethods, paymentLinkResponse.blockedPaymentMethods) && Objects.equals(this.captureDelayHours, paymentLinkResponse.captureDelayHours) && Objects.equals(this.countryCode, paymentLinkResponse.countryCode) && Objects.equals(this.dateOfBirth, paymentLinkResponse.dateOfBirth) && Objects.equals(this.deliverAt, paymentLinkResponse.deliverAt) && Objects.equals(this.deliveryAddress, paymentLinkResponse.deliveryAddress) && Objects.equals(this.description, paymentLinkResponse.description) && Objects.equals(this.expiresAt, paymentLinkResponse.expiresAt) && Objects.equals(this.id, paymentLinkResponse.id) && Objects.equals(this.installmentOptions, paymentLinkResponse.installmentOptions) && Objects.equals(this.lineItems, paymentLinkResponse.lineItems) && Objects.equals(this.manualCapture, paymentLinkResponse.manualCapture) && Objects.equals(this.mcc, paymentLinkResponse.mcc) && Objects.equals(this.merchantAccount, paymentLinkResponse.merchantAccount) && Objects.equals(this.merchantOrderReference, paymentLinkResponse.merchantOrderReference) && Objects.equals(this.metadata, paymentLinkResponse.metadata) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentLinkResponse.recurringProcessingModel) && Objects.equals(this.reference, paymentLinkResponse.reference) && Objects.equals(this.requiredShopperFields, paymentLinkResponse.requiredShopperFields) && Objects.equals(this.returnUrl, paymentLinkResponse.returnUrl) && Objects.equals(this.reusable, paymentLinkResponse.reusable) && Objects.equals(this.riskData, paymentLinkResponse.riskData) && Objects.equals(this.shopperEmail, paymentLinkResponse.shopperEmail) && Objects.equals(this.shopperLocale, paymentLinkResponse.shopperLocale) && Objects.equals(this.shopperName, paymentLinkResponse.shopperName) && Objects.equals(this.shopperReference, paymentLinkResponse.shopperReference) && Objects.equals(this.shopperStatement, paymentLinkResponse.shopperStatement) && Objects.equals(this.showRemovePaymentMethodButton, paymentLinkResponse.showRemovePaymentMethodButton) && Objects.equals(this.socialSecurityNumber, paymentLinkResponse.socialSecurityNumber) && Objects.equals(this.splitCardFundingSources, paymentLinkResponse.splitCardFundingSources) && Objects.equals(this.splits, paymentLinkResponse.splits) && Objects.equals((Object)this.status, (Object)paymentLinkResponse.status) && Objects.equals(this.store, paymentLinkResponse.store) && Objects.equals((Object)this.storePaymentMethodMode, (Object)paymentLinkResponse.storePaymentMethodMode) && Objects.equals(this.telephoneNumber, paymentLinkResponse.telephoneNumber) && Objects.equals(this.themeId, paymentLinkResponse.themeId) && Objects.equals(this.updatedAt, paymentLinkResponse.updatedAt) && Objects.equals(this.url, paymentLinkResponse.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethods, this.amount, this.applicationInfo, this.billingAddress, this.blockedPaymentMethods, this.captureDelayHours, this.countryCode, this.dateOfBirth, this.deliverAt, this.deliveryAddress, this.description, this.expiresAt, this.id, this.installmentOptions, this.lineItems, this.manualCapture, this.mcc, this.merchantAccount, this.merchantOrderReference, this.metadata, this.recurringProcessingModel, this.reference, this.requiredShopperFields, this.returnUrl, this.reusable, this.riskData, this.shopperEmail, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.showRemovePaymentMethodButton, this.socialSecurityNumber, this.splitCardFundingSources, this.splits, this.status, this.store, this.storePaymentMethodMode, this.telephoneNumber, this.themeId, this.updatedAt, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentLinkResponse {\n");
        sb.append("    allowedPaymentMethods: ").append(this.toIndentedString(this.allowedPaymentMethods)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    blockedPaymentMethods: ").append(this.toIndentedString(this.blockedPaymentMethods)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    installmentOptions: ").append(this.toIndentedString(this.installmentOptions)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    manualCapture: ").append(this.toIndentedString(this.manualCapture)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    requiredShopperFields: ").append(this.toIndentedString(this.requiredShopperFields)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    reusable: ").append(this.toIndentedString(this.reusable)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    showRemovePaymentMethodButton: ").append(this.toIndentedString(this.showRemovePaymentMethodButton)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splitCardFundingSources: ").append(this.toIndentedString(this.splitCardFundingSources)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethodMode: ").append(this.toIndentedString((Object)this.storePaymentMethodMode)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    themeId: ").append(this.toIndentedString(this.themeId)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentLinkResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentLinkResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS) != null && !jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `allowedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO) != null) {
            ApplicationInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_APPLICATION_INFO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BILLING_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS) != null && !jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `blockedPaymentMethods` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `countryCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRY_CODE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS) != null) {
            Address.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_DELIVERY_ADDRESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRES_AT) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiresAt` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRES_AT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        JsonArray jsonArraylineItems = jsonObj.getAsJsonArray(SERIALIZED_NAME_LINE_ITEMS);
        if (jsonArraylineItems != null) {
            if (!jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `lineItems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LINE_ITEMS).toString()));
            }
            for (int i = 0; i < jsonArraylineItems.size(); ++i) {
                LineItem.validateJsonObject(jsonArraylineItems.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MCC) != null && !jsonObj.get(SERIALIZED_NAME_MCC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MCC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantOrderReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `recurringProcessingModel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).toString()));
            }
            RecurringProcessingModelEnum.fromValue(jsonObj.get(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS) != null && !jsonObj.get(SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requiredShopperFields` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RETURN_URL) != null && !jsonObj.get(SERIALIZED_NAME_RETURN_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `returnUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RETURN_URL).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA) != null) {
            RiskData.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RISK_DATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperLocale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_LOCALE).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME) != null) {
            Name.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_NAME));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperStatement` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_STATEMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `socialSecurityNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER).toString()));
        }
        JsonArray jsonArraysplits = jsonObj.getAsJsonArray(SERIALIZED_NAME_SPLITS);
        if (jsonArraysplits != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SPLITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `splits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SPLITS).toString()));
            }
            for (int i = 0; i < jsonArraysplits.size(); ++i) {
                Split.validateJsonObject(jsonArraysplits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE) != null && !jsonObj.get(SERIALIZED_NAME_STORE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `store` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `storePaymentMethodMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).toString()));
            }
            StorePaymentMethodModeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `telephoneNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TELEPHONE_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THEME_ID) != null && !jsonObj.get(SERIALIZED_NAME_THEME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `themeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THEME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static PaymentLinkResponse fromJson(String jsonString) throws IOException {
        return (PaymentLinkResponse)JSON.getGson().fromJson(jsonString, PaymentLinkResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOWED_PAYMENT_METHODS);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_APPLICATION_INFO);
        openapiFields.add(SERIALIZED_NAME_BILLING_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_BLOCKED_PAYMENT_METHODS);
        openapiFields.add(SERIALIZED_NAME_CAPTURE_DELAY_HOURS);
        openapiFields.add(SERIALIZED_NAME_COUNTRY_CODE);
        openapiFields.add(SERIALIZED_NAME_DATE_OF_BIRTH);
        openapiFields.add(SERIALIZED_NAME_DELIVER_AT);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INSTALLMENT_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_LINE_ITEMS);
        openapiFields.add(SERIALIZED_NAME_MANUAL_CAPTURE);
        openapiFields.add(SERIALIZED_NAME_MCC);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ORDER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_RECURRING_PROCESSING_MODEL);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_REQUIRED_SHOPPER_FIELDS);
        openapiFields.add(SERIALIZED_NAME_RETURN_URL);
        openapiFields.add(SERIALIZED_NAME_REUSABLE);
        openapiFields.add(SERIALIZED_NAME_RISK_DATA);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_EMAIL);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_LOCALE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NAME);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiFields.add(SERIALIZED_NAME_SHOW_REMOVE_PAYMENT_METHOD_BUTTON);
        openapiFields.add(SERIALIZED_NAME_SOCIAL_SECURITY_NUMBER);
        openapiFields.add(SERIALIZED_NAME_SPLIT_CARD_FUNDING_SOURCES);
        openapiFields.add(SERIALIZED_NAME_SPLITS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STORE);
        openapiFields.add(SERIALIZED_NAME_STORE_PAYMENT_METHOD_MODE);
        openapiFields.add(SERIALIZED_NAME_TELEPHONE_NUMBER);
        openapiFields.add(SERIALIZED_NAME_THEME_ID);
        openapiFields.add(SERIALIZED_NAME_UPDATED_AT);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentLinkResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentLinkResponse.class));
            return new TypeAdapter<PaymentLinkResponse>(){

                public void write(JsonWriter out, PaymentLinkResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentLinkResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentLinkResponse.validateJsonObject(jsonObj);
                    return (PaymentLinkResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StorePaymentMethodModeEnum {
        ASKFORCONSENT("askForConsent"),
        DISABLED("disabled"),
        ENABLED("enabled");

        private String value;

        private StorePaymentMethodModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StorePaymentMethodModeEnum fromValue(String value) {
            for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StorePaymentMethodModeEnum> {
            public void write(JsonWriter jsonWriter, StorePaymentMethodModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StorePaymentMethodModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StorePaymentMethodModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        COMPLETED("completed"),
        EXPIRED("expired"),
        PAID("paid"),
        PAYMENTPENDING("paymentPending");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequiredShopperFieldsEnum {
        BILLINGADDRESS("billingAddress"),
        DELIVERYADDRESS("deliveryAddress"),
        SHOPPEREMAIL("shopperEmail"),
        SHOPPERNAME("shopperName"),
        TELEPHONENUMBER("telephoneNumber");

        private String value;

        private RequiredShopperFieldsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequiredShopperFieldsEnum fromValue(String value) {
            for (RequiredShopperFieldsEnum b : RequiredShopperFieldsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RequiredShopperFieldsEnum> {
            public void write(JsonWriter jsonWriter, RequiredShopperFieldsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RequiredShopperFieldsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequiredShopperFieldsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        private String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String value) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(value);
            }
        }
    }
}

