/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MerchantRiskIndicator {
    public static final String SERIALIZED_NAME_ADDRESS_MATCH = "addressMatch";
    @SerializedName(value="addressMatch")
    private Boolean addressMatch;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR = "deliveryAddressIndicator";
    @SerializedName(value="deliveryAddressIndicator")
    private DeliveryAddressIndicatorEnum deliveryAddressIndicator;
    public static final String SERIALIZED_NAME_DELIVERY_EMAIL = "deliveryEmail";
    @Deprecated
    @SerializedName(value="deliveryEmail")
    private String deliveryEmail;
    public static final String SERIALIZED_NAME_DELIVERY_EMAIL_ADDRESS = "deliveryEmailAddress";
    @SerializedName(value="deliveryEmailAddress")
    private String deliveryEmailAddress;
    public static final String SERIALIZED_NAME_DELIVERY_TIMEFRAME = "deliveryTimeframe";
    @SerializedName(value="deliveryTimeframe")
    private DeliveryTimeframeEnum deliveryTimeframe;
    public static final String SERIALIZED_NAME_GIFT_CARD_AMOUNT = "giftCardAmount";
    @SerializedName(value="giftCardAmount")
    private Amount giftCardAmount;
    public static final String SERIALIZED_NAME_GIFT_CARD_COUNT = "giftCardCount";
    @SerializedName(value="giftCardCount")
    private Integer giftCardCount;
    public static final String SERIALIZED_NAME_GIFT_CARD_CURR = "giftCardCurr";
    @SerializedName(value="giftCardCurr")
    private String giftCardCurr;
    public static final String SERIALIZED_NAME_PRE_ORDER_DATE = "preOrderDate";
    @SerializedName(value="preOrderDate")
    private OffsetDateTime preOrderDate;
    public static final String SERIALIZED_NAME_PRE_ORDER_PURCHASE = "preOrderPurchase";
    @SerializedName(value="preOrderPurchase")
    private Boolean preOrderPurchase;
    public static final String SERIALIZED_NAME_PRE_ORDER_PURCHASE_IND = "preOrderPurchaseInd";
    @SerializedName(value="preOrderPurchaseInd")
    private String preOrderPurchaseInd;
    public static final String SERIALIZED_NAME_REORDER_ITEMS = "reorderItems";
    @SerializedName(value="reorderItems")
    private Boolean reorderItems;
    public static final String SERIALIZED_NAME_REORDER_ITEMS_IND = "reorderItemsInd";
    @SerializedName(value="reorderItemsInd")
    private String reorderItemsInd;
    public static final String SERIALIZED_NAME_SHIP_INDICATOR = "shipIndicator";
    @SerializedName(value="shipIndicator")
    private String shipIndicator;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MerchantRiskIndicator addressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
        return this;
    }

    @ApiModelProperty(value="Whether the chosen delivery address is identical to the billing address.")
    public Boolean getAddressMatch() {
        return this.addressMatch;
    }

    public void setAddressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
    }

    public MerchantRiskIndicator deliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator regarding the delivery address. Allowed values: * `shipToBillingAddress` * `shipToVerifiedAddress` * `shipToNewAddress` * `shipToStore` * `digitalGoods` * `goodsNotShipped` * `other`")
    public DeliveryAddressIndicatorEnum getDeliveryAddressIndicator() {
        return this.deliveryAddressIndicator;
    }

    public void setDeliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
    }

    @Deprecated
    public MerchantRiskIndicator deliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="The delivery email address (for digital goods).")
    public String getDeliveryEmail() {
        return this.deliveryEmail;
    }

    @Deprecated
    public void setDeliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
    }

    public MerchantRiskIndicator deliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
        return this;
    }

    @ApiModelProperty(value="For Electronic delivery, the email address to which the merchandise was delivered. Maximum length: 254 characters.")
    public String getDeliveryEmailAddress() {
        return this.deliveryEmailAddress;
    }

    public void setDeliveryEmailAddress(String deliveryEmailAddress) {
        this.deliveryEmailAddress = deliveryEmailAddress;
    }

    public MerchantRiskIndicator deliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
        return this;
    }

    @ApiModelProperty(value="The estimated delivery time for the shopper to receive the goods. Allowed values: * `electronicDelivery` * `sameDayShipping` * `overnightShipping` * `twoOrMoreDaysShipping`")
    public DeliveryTimeframeEnum getDeliveryTimeframe() {
        return this.deliveryTimeframe;
    }

    public void setDeliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
    }

    public MerchantRiskIndicator giftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getGiftCardAmount() {
        return this.giftCardAmount;
    }

    public void setGiftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public MerchantRiskIndicator giftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
        return this;
    }

    @ApiModelProperty(value="For prepaid or gift card purchase, total count of individual prepaid or gift cards/codes purchased.")
    public Integer getGiftCardCount() {
        return this.giftCardCount;
    }

    public void setGiftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
    }

    public MerchantRiskIndicator giftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
        return this;
    }

    @ApiModelProperty(value="For prepaid or gift card purchase, [ISO 4217](https://www.iso.org/iso-4217-currency-codes.html) three-digit currency code of the gift card, other than those listed in Table A.5 of the EMVCo 3D Secure Protocol and Core Functions Specification.")
    public String getGiftCardCurr() {
        return this.giftCardCurr;
    }

    public void setGiftCardCurr(String giftCardCurr) {
        this.giftCardCurr = giftCardCurr;
    }

    public MerchantRiskIndicator preOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
        return this;
    }

    @ApiModelProperty(value="For pre-order purchases, the expected date this product will be available to the shopper.")
    public OffsetDateTime getPreOrderDate() {
        return this.preOrderDate;
    }

    public void setPreOrderDate(OffsetDateTime preOrderDate) {
        this.preOrderDate = preOrderDate;
    }

    public MerchantRiskIndicator preOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
        return this;
    }

    @ApiModelProperty(value="Indicator for whether this transaction is for pre-ordering a product.")
    public Boolean getPreOrderPurchase() {
        return this.preOrderPurchase;
    }

    public void setPreOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
    }

    public MerchantRiskIndicator preOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
        return this;
    }

    @ApiModelProperty(value="Indicates whether Cardholder is placing an order for merchandise with a future availability or release date.")
    public String getPreOrderPurchaseInd() {
        return this.preOrderPurchaseInd;
    }

    public void setPreOrderPurchaseInd(String preOrderPurchaseInd) {
        this.preOrderPurchaseInd = preOrderPurchaseInd;
    }

    public MerchantRiskIndicator reorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
        return this;
    }

    @ApiModelProperty(value="Indicator for whether the shopper has already purchased the same items in the past.")
    public Boolean getReorderItems() {
        return this.reorderItems;
    }

    public void setReorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
    }

    public MerchantRiskIndicator reorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the cardholder is reordering previously purchased merchandise.")
    public String getReorderItemsInd() {
        return this.reorderItemsInd;
    }

    public void setReorderItemsInd(String reorderItemsInd) {
        this.reorderItemsInd = reorderItemsInd;
    }

    public MerchantRiskIndicator shipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates shipping method chosen for the transaction.")
    public String getShipIndicator() {
        return this.shipIndicator;
    }

    public void setShipIndicator(String shipIndicator) {
        this.shipIndicator = shipIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantRiskIndicator merchantRiskIndicator = (MerchantRiskIndicator)o;
        return Objects.equals(this.addressMatch, merchantRiskIndicator.addressMatch) && Objects.equals((Object)this.deliveryAddressIndicator, (Object)merchantRiskIndicator.deliveryAddressIndicator) && Objects.equals(this.deliveryEmail, merchantRiskIndicator.deliveryEmail) && Objects.equals(this.deliveryEmailAddress, merchantRiskIndicator.deliveryEmailAddress) && Objects.equals((Object)this.deliveryTimeframe, (Object)merchantRiskIndicator.deliveryTimeframe) && Objects.equals(this.giftCardAmount, merchantRiskIndicator.giftCardAmount) && Objects.equals(this.giftCardCount, merchantRiskIndicator.giftCardCount) && Objects.equals(this.giftCardCurr, merchantRiskIndicator.giftCardCurr) && Objects.equals(this.preOrderDate, merchantRiskIndicator.preOrderDate) && Objects.equals(this.preOrderPurchase, merchantRiskIndicator.preOrderPurchase) && Objects.equals(this.preOrderPurchaseInd, merchantRiskIndicator.preOrderPurchaseInd) && Objects.equals(this.reorderItems, merchantRiskIndicator.reorderItems) && Objects.equals(this.reorderItemsInd, merchantRiskIndicator.reorderItemsInd) && Objects.equals(this.shipIndicator, merchantRiskIndicator.shipIndicator);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressMatch, this.deliveryAddressIndicator, this.deliveryEmail, this.deliveryEmailAddress, this.deliveryTimeframe, this.giftCardAmount, this.giftCardCount, this.giftCardCurr, this.preOrderDate, this.preOrderPurchase, this.preOrderPurchaseInd, this.reorderItems, this.reorderItemsInd, this.shipIndicator});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantRiskIndicator {\n");
        sb.append("    addressMatch: ").append(this.toIndentedString(this.addressMatch)).append("\n");
        sb.append("    deliveryAddressIndicator: ").append(this.toIndentedString((Object)this.deliveryAddressIndicator)).append("\n");
        sb.append("    deliveryEmail: ").append(this.toIndentedString(this.deliveryEmail)).append("\n");
        sb.append("    deliveryEmailAddress: ").append(this.toIndentedString(this.deliveryEmailAddress)).append("\n");
        sb.append("    deliveryTimeframe: ").append(this.toIndentedString((Object)this.deliveryTimeframe)).append("\n");
        sb.append("    giftCardAmount: ").append(this.toIndentedString(this.giftCardAmount)).append("\n");
        sb.append("    giftCardCount: ").append(this.toIndentedString(this.giftCardCount)).append("\n");
        sb.append("    giftCardCurr: ").append(this.toIndentedString(this.giftCardCurr)).append("\n");
        sb.append("    preOrderDate: ").append(this.toIndentedString(this.preOrderDate)).append("\n");
        sb.append("    preOrderPurchase: ").append(this.toIndentedString(this.preOrderPurchase)).append("\n");
        sb.append("    preOrderPurchaseInd: ").append(this.toIndentedString(this.preOrderPurchaseInd)).append("\n");
        sb.append("    reorderItems: ").append(this.toIndentedString(this.reorderItems)).append("\n");
        sb.append("    reorderItemsInd: ").append(this.toIndentedString(this.reorderItemsInd)).append("\n");
        sb.append("    shipIndicator: ").append(this.toIndentedString(this.shipIndicator)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in MerchantRiskIndicator is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MerchantRiskIndicator` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `deliveryAddressIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR).toString()));
            }
            DeliveryAddressIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deliveryEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deliveryEmailAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_EMAIL_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_TIMEFRAME) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DELIVERY_TIMEFRAME).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `deliveryTimeframe` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_TIMEFRAME).toString()));
            }
            DeliveryTimeframeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DELIVERY_TIMEFRAME).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GIFT_CARD_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GIFT_CARD_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_GIFT_CARD_CURR) != null && !jsonObj.get(SERIALIZED_NAME_GIFT_CARD_CURR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `giftCardCurr` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GIFT_CARD_CURR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRE_ORDER_PURCHASE_IND) != null && !jsonObj.get(SERIALIZED_NAME_PRE_ORDER_PURCHASE_IND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `preOrderPurchaseInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRE_ORDER_PURCHASE_IND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REORDER_ITEMS_IND) != null && !jsonObj.get(SERIALIZED_NAME_REORDER_ITEMS_IND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reorderItemsInd` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REORDER_ITEMS_IND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHIP_INDICATOR) != null && !jsonObj.get(SERIALIZED_NAME_SHIP_INDICATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shipIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHIP_INDICATOR).toString()));
        }
    }

    public static MerchantRiskIndicator fromJson(String jsonString) throws IOException {
        return (MerchantRiskIndicator)JSON.getGson().fromJson(jsonString, MerchantRiskIndicator.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ADDRESS_MATCH);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_EMAIL);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_EMAIL_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_TIMEFRAME);
        openapiFields.add(SERIALIZED_NAME_GIFT_CARD_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_GIFT_CARD_COUNT);
        openapiFields.add(SERIALIZED_NAME_GIFT_CARD_CURR);
        openapiFields.add(SERIALIZED_NAME_PRE_ORDER_DATE);
        openapiFields.add(SERIALIZED_NAME_PRE_ORDER_PURCHASE);
        openapiFields.add(SERIALIZED_NAME_PRE_ORDER_PURCHASE_IND);
        openapiFields.add(SERIALIZED_NAME_REORDER_ITEMS);
        openapiFields.add(SERIALIZED_NAME_REORDER_ITEMS_IND);
        openapiFields.add(SERIALIZED_NAME_SHIP_INDICATOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MerchantRiskIndicator.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MerchantRiskIndicator.class));
            return new TypeAdapter<MerchantRiskIndicator>(){

                public void write(JsonWriter out, MerchantRiskIndicator value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MerchantRiskIndicator read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    MerchantRiskIndicator.validateJsonObject(jsonObj);
                    return (MerchantRiskIndicator)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryTimeframeEnum {
        ELECTRONICDELIVERY("electronicDelivery"),
        SAMEDAYSHIPPING("sameDayShipping"),
        OVERNIGHTSHIPPING("overnightShipping"),
        TWOORMOREDAYSSHIPPING("twoOrMoreDaysShipping");

        private String value;

        private DeliveryTimeframeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryTimeframeEnum fromValue(String value) {
            for (DeliveryTimeframeEnum b : DeliveryTimeframeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DeliveryTimeframeEnum> {
            public void write(JsonWriter jsonWriter, DeliveryTimeframeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryTimeframeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryTimeframeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryAddressIndicatorEnum {
        SHIPTOBILLINGADDRESS("shipToBillingAddress"),
        SHIPTOVERIFIEDADDRESS("shipToVerifiedAddress"),
        SHIPTONEWADDRESS("shipToNewAddress"),
        SHIPTOSTORE("shipToStore"),
        DIGITALGOODS("digitalGoods"),
        GOODSNOTSHIPPED("goodsNotShipped"),
        OTHER("other");

        private String value;

        private DeliveryAddressIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryAddressIndicatorEnum fromValue(String value) {
            for (DeliveryAddressIndicatorEnum b : DeliveryAddressIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DeliveryAddressIndicatorEnum> {
            public void write(JsonWriter jsonWriter, DeliveryAddressIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryAddressIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryAddressIndicatorEnum.fromValue(value);
            }
        }
    }
}

