/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CardBin {
    public static final String SERIALIZED_NAME_BIN = "bin";
    @SerializedName(value="bin")
    private String bin;
    public static final String SERIALIZED_NAME_COMMERCIAL = "commercial";
    @SerializedName(value="commercial")
    private Boolean commercial;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
    @SerializedName(value="fundingSource")
    private String fundingSource;
    public static final String SERIALIZED_NAME_FUNDS_AVAILABILITY = "fundsAvailability";
    @SerializedName(value="fundsAvailability")
    private String fundsAvailability;
    public static final String SERIALIZED_NAME_ISSUER_BIN = "issuerBin";
    @SerializedName(value="issuerBin")
    private String issuerBin;
    public static final String SERIALIZED_NAME_ISSUING_BANK = "issuingBank";
    @SerializedName(value="issuingBank")
    private String issuingBank;
    public static final String SERIALIZED_NAME_ISSUING_COUNTRY = "issuingCountry";
    @SerializedName(value="issuingCountry")
    private String issuingCountry;
    public static final String SERIALIZED_NAME_ISSUING_CURRENCY = "issuingCurrency";
    @SerializedName(value="issuingCurrency")
    private String issuingCurrency;
    public static final String SERIALIZED_NAME_PAYMENT_METHOD = "paymentMethod";
    @SerializedName(value="paymentMethod")
    private String paymentMethod;
    public static final String SERIALIZED_NAME_PAYOUT_ELIGIBLE = "payoutEligible";
    @SerializedName(value="payoutEligible")
    private String payoutEligible;
    public static final String SERIALIZED_NAME_SUMMARY = "summary";
    @SerializedName(value="summary")
    private String summary;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CardBin bin(String bin) {
        this.bin = bin;
        return this;
    }

    @ApiModelProperty(value="The first 6 digit of the card number. Enable this field via merchant account settings.")
    public String getBin() {
        return this.bin;
    }

    public void setBin(String bin) {
        this.bin = bin;
    }

    public CardBin commercial(Boolean commercial) {
        this.commercial = commercial;
        return this;
    }

    @ApiModelProperty(value="If true, it indicates a commercial card. Enable this field via merchant account settings.")
    public Boolean getCommercial() {
        return this.commercial;
    }

    public void setCommercial(Boolean commercial) {
        this.commercial = commercial;
    }

    public CardBin fundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The card funding source. Valid values are: * CHARGE * CREDIT * DEBIT * DEFERRED_DEBIT * PREPAID * PREPAID_RELOADABLE * PREPAID_NONRELOADABLE > Enable this field via merchant account settings.")
    public String getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
    }

    public CardBin fundsAvailability(String fundsAvailability) {
        this.fundsAvailability = fundsAvailability;
        return this;
    }

    @ApiModelProperty(value="Indicates availability of funds.  Visa: * \"I\" (fast funds are supported) * \"N\" (otherwise)  Mastercard: * \"I\" (product type is Prepaid or Debit, or issuing country is in CEE/HGEM list) * \"N\" (otherwise) > Returned when you verify a card BIN or estimate costs, and only if `payoutEligible` is different from \"N\" or \"U\".")
    public String getFundsAvailability() {
        return this.fundsAvailability;
    }

    public void setFundsAvailability(String fundsAvailability) {
        this.fundsAvailability = fundsAvailability;
    }

    public CardBin issuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
        return this;
    }

    @ApiModelProperty(value="The first 8 digit of the card number. Enable this field via merchant account settings.")
    public String getIssuerBin() {
        return this.issuerBin;
    }

    public void setIssuerBin(String issuerBin) {
        this.issuerBin = issuerBin;
    }

    public CardBin issuingBank(String issuingBank) {
        this.issuingBank = issuingBank;
        return this;
    }

    @ApiModelProperty(value="The issuing bank of the card.")
    public String getIssuingBank() {
        return this.issuingBank;
    }

    public void setIssuingBank(String issuingBank) {
        this.issuingBank = issuingBank;
    }

    public CardBin issuingCountry(String issuingCountry) {
        this.issuingCountry = issuingCountry;
        return this;
    }

    @ApiModelProperty(value="The country where the card was issued from.")
    public String getIssuingCountry() {
        return this.issuingCountry;
    }

    public void setIssuingCountry(String issuingCountry) {
        this.issuingCountry = issuingCountry;
    }

    public CardBin issuingCurrency(String issuingCurrency) {
        this.issuingCurrency = issuingCurrency;
        return this;
    }

    @ApiModelProperty(value="The currency of the card.")
    public String getIssuingCurrency() {
        return this.issuingCurrency;
    }

    public void setIssuingCurrency(String issuingCurrency) {
        this.issuingCurrency = issuingCurrency;
    }

    public CardBin paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(value="The payment method associated with the card (e.g. visa, mc, or amex).")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public CardBin payoutEligible(String payoutEligible) {
        this.payoutEligible = payoutEligible;
        return this;
    }

    @ApiModelProperty(value="Indicates whether a payout is eligible or not for this card.  Visa: * \"Y\" * \"N\"  Mastercard: * \"Y\" (domestic and cross-border) * \"D\" (only domestic) * \"N\" (no MoneySend) * \"U\" (unknown) > Returned when you verify a card BIN or estimate costs, and only if `payoutEligible` is different from \"N\" or \"U\".")
    public String getPayoutEligible() {
        return this.payoutEligible;
    }

    public void setPayoutEligible(String payoutEligible) {
        this.payoutEligible = payoutEligible;
    }

    public CardBin summary(String summary) {
        this.summary = summary;
        return this;
    }

    @ApiModelProperty(value="The last four digits of the card number.")
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardBin cardBin = (CardBin)o;
        return Objects.equals(this.bin, cardBin.bin) && Objects.equals(this.commercial, cardBin.commercial) && Objects.equals(this.fundingSource, cardBin.fundingSource) && Objects.equals(this.fundsAvailability, cardBin.fundsAvailability) && Objects.equals(this.issuerBin, cardBin.issuerBin) && Objects.equals(this.issuingBank, cardBin.issuingBank) && Objects.equals(this.issuingCountry, cardBin.issuingCountry) && Objects.equals(this.issuingCurrency, cardBin.issuingCurrency) && Objects.equals(this.paymentMethod, cardBin.paymentMethod) && Objects.equals(this.payoutEligible, cardBin.payoutEligible) && Objects.equals(this.summary, cardBin.summary);
    }

    public int hashCode() {
        return Objects.hash(this.bin, this.commercial, this.fundingSource, this.fundsAvailability, this.issuerBin, this.issuingBank, this.issuingCountry, this.issuingCurrency, this.paymentMethod, this.payoutEligible, this.summary);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardBin {\n");
        sb.append("    bin: ").append(this.toIndentedString(this.bin)).append("\n");
        sb.append("    commercial: ").append(this.toIndentedString(this.commercial)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    fundsAvailability: ").append(this.toIndentedString(this.fundsAvailability)).append("\n");
        sb.append("    issuerBin: ").append(this.toIndentedString(this.issuerBin)).append("\n");
        sb.append("    issuingBank: ").append(this.toIndentedString(this.issuingBank)).append("\n");
        sb.append("    issuingCountry: ").append(this.toIndentedString(this.issuingCountry)).append("\n");
        sb.append("    issuingCurrency: ").append(this.toIndentedString(this.issuingCurrency)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    payoutEligible: ").append(this.toIndentedString(this.payoutEligible)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CardBin is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CardBin` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIN) != null && !jsonObj.get(SERIALIZED_NAME_BIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `bin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDS_AVAILABILITY) != null && !jsonObj.get(SERIALIZED_NAME_FUNDS_AVAILABILITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fundsAvailability` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDS_AVAILABILITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUER_BIN) != null && !jsonObj.get(SERIALIZED_NAME_ISSUER_BIN).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuerBin` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUER_BIN).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUING_BANK) != null && !jsonObj.get(SERIALIZED_NAME_ISSUING_BANK).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuingBank` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUING_BANK).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUING_COUNTRY) != null && !jsonObj.get(SERIALIZED_NAME_ISSUING_COUNTRY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuingCountry` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUING_COUNTRY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ISSUING_CURRENCY) != null && !jsonObj.get(SERIALIZED_NAME_ISSUING_CURRENCY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `issuingCurrency` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ISSUING_CURRENCY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD) != null && !jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `paymentMethod` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_METHOD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYOUT_ELIGIBLE) != null && !jsonObj.get(SERIALIZED_NAME_PAYOUT_ELIGIBLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `payoutEligible` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYOUT_ELIGIBLE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUMMARY) != null && !jsonObj.get(SERIALIZED_NAME_SUMMARY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUMMARY).toString()));
        }
    }

    public static CardBin fromJson(String jsonString) throws IOException {
        return (CardBin)JSON.getGson().fromJson(jsonString, CardBin.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BIN);
        openapiFields.add(SERIALIZED_NAME_COMMERCIAL);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_FUNDS_AVAILABILITY);
        openapiFields.add(SERIALIZED_NAME_ISSUER_BIN);
        openapiFields.add(SERIALIZED_NAME_ISSUING_BANK);
        openapiFields.add(SERIALIZED_NAME_ISSUING_COUNTRY);
        openapiFields.add(SERIALIZED_NAME_ISSUING_CURRENCY);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_METHOD);
        openapiFields.add(SERIALIZED_NAME_PAYOUT_ELIGIBLE);
        openapiFields.add(SERIALIZED_NAME_SUMMARY);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CardBin.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CardBin.class));
            return new TypeAdapter<CardBin>(){

                public void write(JsonWriter out, CardBin value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CardBin read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CardBin.validateJsonObject(jsonObj);
                    return (CardBin)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

