/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class VerificationDeadline {
    public static final String SERIALIZED_NAME_CAPABILITIES = "capabilities";
    @SerializedName(value="capabilities")
    private List<CapabilitiesEnum> capabilities = new ArrayList<CapabilitiesEnum>();
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public VerificationDeadline() {
    }

    public VerificationDeadline(List<CapabilitiesEnum> capabilities, OffsetDateTime expiresAt) {
        this();
        this.capabilities = capabilities;
        this.expiresAt = expiresAt;
    }

    @ApiModelProperty(required=true, value="The names of the capabilities to be disallowed.")
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    @ApiModelProperty(required=true, value="The date that verification is due by before capabilities are disallowed.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationDeadline verificationDeadline = (VerificationDeadline)o;
        return Objects.equals(this.capabilities, verificationDeadline.capabilities) && Objects.equals(this.expiresAt, verificationDeadline.expiresAt);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.expiresAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationDeadline {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in VerificationDeadline is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `VerificationDeadline` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITIES) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `capabilities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITIES).toString()));
        }
    }

    public static VerificationDeadline fromJson(String jsonString) throws IOException {
        return (VerificationDeadline)JSON.getGson().fromJson(jsonString, VerificationDeadline.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiRequiredFields.add(SERIALIZED_NAME_EXPIRES_AT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!VerificationDeadline.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VerificationDeadline.class));
            return new TypeAdapter<VerificationDeadline>(){

                public void write(JsonWriter out, VerificationDeadline value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public VerificationDeadline read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    VerificationDeadline.validateJsonObject(jsonObj);
                    return (VerificationDeadline)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CapabilitiesEnum {
        ACCEPTEXTERNALFUNDING("acceptExternalFunding"),
        ACCEPTPSPFUNDING("acceptPspFunding"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIES("acceptTransactionInRestrictedCountries"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCOMMERCIAL("acceptTransactionInRestrictedCountriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDCOUNTRIESCONSUMER("acceptTransactionInRestrictedCountriesConsumer"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIES("acceptTransactionInRestrictedIndustries"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCOMMERCIAL("acceptTransactionInRestrictedIndustriesCommercial"),
        ACCEPTTRANSACTIONINRESTRICTEDINDUSTRIESCONSUMER("acceptTransactionInRestrictedIndustriesConsumer"),
        ACQUIRING("acquiring"),
        ATMWITHDRAWAL("atmWithdrawal"),
        ATMWITHDRAWALCOMMERCIAL("atmWithdrawalCommercial"),
        ATMWITHDRAWALCONSUMER("atmWithdrawalConsumer"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIES("atmWithdrawalInRestrictedCountries"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCOMMERCIAL("atmWithdrawalInRestrictedCountriesCommercial"),
        ATMWITHDRAWALINRESTRICTEDCOUNTRIESCONSUMER("atmWithdrawalInRestrictedCountriesConsumer"),
        AUTHORISEDPAYMENTINSTRUMENTUSER("authorisedPaymentInstrumentUser"),
        GETGRANTOFFERS("getGrantOffers"),
        ISSUEBANKACCOUNT("issueBankAccount"),
        ISSUECARD("issueCard"),
        ISSUECARDCOMMERCIAL("issueCardCommercial"),
        ISSUECARDCONSUMER("issueCardConsumer"),
        LOCALACCEPTANCE("localAcceptance"),
        PAYOUT("payout"),
        PAYOUTTOTRANSFERINSTRUMENT("payoutToTransferInstrument"),
        PROCESSING("processing"),
        RECEIVEFROMBALANCEACCOUNT("receiveFromBalanceAccount"),
        RECEIVEFROMPLATFORMPAYMENTS("receiveFromPlatformPayments"),
        RECEIVEFROMTHIRDPARTY("receiveFromThirdParty"),
        RECEIVEFROMTRANSFERINSTRUMENT("receiveFromTransferInstrument"),
        RECEIVEGRANTS("receiveGrants"),
        RECEIVEPAYMENTS("receivePayments"),
        SENDTOBALANCEACCOUNT("sendToBalanceAccount"),
        SENDTOTHIRDPARTY("sendToThirdParty"),
        SENDTOTRANSFERINSTRUMENT("sendToTransferInstrument"),
        THIRDPARTYFUNDING("thirdPartyFunding"),
        USECARD("useCard"),
        USECARDCOMMERCIAL("useCardCommercial"),
        USECARDCONSUMER("useCardConsumer"),
        USECARDINRESTRICTEDCOUNTRIES("useCardInRestrictedCountries"),
        USECARDINRESTRICTEDCOUNTRIESCOMMERCIAL("useCardInRestrictedCountriesCommercial"),
        USECARDINRESTRICTEDCOUNTRIESCONSUMER("useCardInRestrictedCountriesConsumer"),
        USECARDINRESTRICTEDINDUSTRIES("useCardInRestrictedIndustries"),
        USECARDINRESTRICTEDINDUSTRIESCOMMERCIAL("useCardInRestrictedIndustriesCommercial"),
        USECARDINRESTRICTEDINDUSTRIESCONSUMER("useCardInRestrictedIndustriesConsumer"),
        WITHDRAWFROMATM("withdrawFromAtm"),
        WITHDRAWFROMATMCOMMERCIAL("withdrawFromAtmCommercial"),
        WITHDRAWFROMATMCONSUMER("withdrawFromAtmConsumer"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIES("withdrawFromAtmInRestrictedCountries"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCOMMERCIAL("withdrawFromAtmInRestrictedCountriesCommercial"),
        WITHDRAWFROMATMINRESTRICTEDCOUNTRIESCONSUMER("withdrawFromAtmInRestrictedCountriesConsumer");

        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CapabilitiesEnum fromValue(String value) {
            for (CapabilitiesEnum b : CapabilitiesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CapabilitiesEnum> {
            public void write(JsonWriter jsonWriter, CapabilitiesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CapabilitiesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CapabilitiesEnum.fromValue(value);
            }
        }
    }
}

