/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.CardInfo;
import com.adyen.model.balanceplatform.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PaymentInstrumentUpdateRequest {
    public static final String SERIALIZED_NAME_BALANCE_ACCOUNT_ID = "balanceAccountId";
    @SerializedName(value="balanceAccountId")
    private String balanceAccountId;
    public static final String SERIALIZED_NAME_CARD = "card";
    @SerializedName(value="card")
    private CardInfo card;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_STATUS_COMMENT = "statusComment";
    @SerializedName(value="statusComment")
    private String statusComment;
    public static final String SERIALIZED_NAME_STATUS_REASON = "statusReason";
    @SerializedName(value="statusReason")
    private StatusReasonEnum statusReason;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public PaymentInstrumentUpdateRequest balanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the balance account associated with this payment instrument. >You can only change the balance account ID if the payment instrument has **inactive** status.")
    public String getBalanceAccountId() {
        return this.balanceAccountId;
    }

    public void setBalanceAccountId(String balanceAccountId) {
        this.balanceAccountId = balanceAccountId;
    }

    public PaymentInstrumentUpdateRequest card(CardInfo card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public CardInfo getCard() {
        return this.card;
    }

    public void setCard(CardInfo card) {
        this.card = card;
    }

    public PaymentInstrumentUpdateRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="The status of the payment instrument. If a status is not specified when creating a payment instrument, it is set to **active** by default. However, there can be exceptions for cards based on the `card.formFactor` and the `issuingCountryCode`. For example, when issuing physical cards in the US, the default status is **inactive**.  Possible values:    * **active**:  The payment instrument is active and can be used to make payments.    * **inactive**: The payment instrument is inactive and cannot be used to make payments.    * **suspended**: The payment instrument is suspended, either because it was stolen or lost.    * **closed**: The payment instrument is permanently closed. This action cannot be undone.   ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public PaymentInstrumentUpdateRequest statusComment(String statusComment) {
        this.statusComment = statusComment;
        return this;
    }

    @ApiModelProperty(value="Comment for the status of the payment instrument.  Required if `statusReason` is **other**.")
    public String getStatusComment() {
        return this.statusComment;
    }

    public void setStatusComment(String statusComment) {
        this.statusComment = statusComment;
    }

    public PaymentInstrumentUpdateRequest statusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
        return this;
    }

    @ApiModelProperty(value="The reason for updating the status of the payment instrument.  Possible values: **lost**, **stolen**, **damaged**, **suspectedFraud**, **expired**, **endOfLife**, **accountClosure**, **other**. If the reason is **other**, you must also send the `statusComment` parameter describing the status change.")
    public StatusReasonEnum getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(StatusReasonEnum statusReason) {
        this.statusReason = statusReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstrumentUpdateRequest paymentInstrumentUpdateRequest = (PaymentInstrumentUpdateRequest)o;
        return Objects.equals(this.balanceAccountId, paymentInstrumentUpdateRequest.balanceAccountId) && Objects.equals(this.card, paymentInstrumentUpdateRequest.card) && Objects.equals((Object)this.status, (Object)paymentInstrumentUpdateRequest.status) && Objects.equals(this.statusComment, paymentInstrumentUpdateRequest.statusComment) && Objects.equals((Object)this.statusReason, (Object)paymentInstrumentUpdateRequest.statusReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceAccountId, this.card, this.status, this.statusComment, this.statusReason});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstrumentUpdateRequest {\n");
        sb.append("    balanceAccountId: ").append(this.toIndentedString(this.balanceAccountId)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    statusComment: ").append(this.toIndentedString(this.statusComment)).append("\n");
        sb.append("    statusReason: ").append(this.toIndentedString((Object)this.statusReason)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in PaymentInstrumentUpdateRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PaymentInstrumentUpdateRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID) != null && !jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `balanceAccountId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BALANCE_ACCOUNT_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD) != null) {
            CardInfo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CARD));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
            }
            StatusEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_COMMENT) != null && !jsonObj.get(SERIALIZED_NAME_STATUS_COMMENT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `statusComment` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_COMMENT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS_REASON) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STATUS_REASON).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `statusReason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS_REASON).toString()));
            }
            StatusReasonEnum.fromValue(jsonObj.get(SERIALIZED_NAME_STATUS_REASON).getAsString());
        }
    }

    public static PaymentInstrumentUpdateRequest fromJson(String jsonString) throws IOException {
        return (PaymentInstrumentUpdateRequest)JSON.getGson().fromJson(jsonString, PaymentInstrumentUpdateRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BALANCE_ACCOUNT_ID);
        openapiFields.add(SERIALIZED_NAME_CARD);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_STATUS_COMMENT);
        openapiFields.add(SERIALIZED_NAME_STATUS_REASON);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!PaymentInstrumentUpdateRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PaymentInstrumentUpdateRequest.class));
            return new TypeAdapter<PaymentInstrumentUpdateRequest>(){

                public void write(JsonWriter out, PaymentInstrumentUpdateRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public PaymentInstrumentUpdateRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    PaymentInstrumentUpdateRequest.validateJsonObject(jsonObj);
                    return (PaymentInstrumentUpdateRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusReasonEnum {
        ACCOUNTCLOSURE("accountClosure"),
        DAMAGED("damaged"),
        ENDOFLIFE("endOfLife"),
        EXPIRED("expired"),
        LOST("lost"),
        OTHER("other"),
        STOLEN("stolen"),
        SUSPECTEDFRAUD("suspectedFraud");

        private String value;

        private StatusReasonEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusReasonEnum fromValue(String value) {
            for (StatusReasonEnum b : StatusReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusReasonEnum> {
            public void write(JsonWriter jsonWriter, StatusReasonEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusReasonEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusReasonEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        ACTIVE("active"),
        CLOSED("closed"),
        INACTIVE("inactive"),
        SUSPENDED("suspended");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

