/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.Fee;
import com.adyen.model.balanceplatform.JSON;
import com.adyen.model.balanceplatform.Repayment;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GrantOffer {
    public static final String SERIALIZED_NAME_ACCOUNT_HOLDER_ID = "accountHolderId";
    @SerializedName(value="accountHolderId")
    private String accountHolderId;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_CONTRACT_TYPE = "contractType";
    @SerializedName(value="contractType")
    private ContractTypeEnum contractType;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private Object expiresAt;
    public static final String SERIALIZED_NAME_FEE = "fee";
    @SerializedName(value="fee")
    private Fee fee;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REPAYMENT = "repayment";
    @SerializedName(value="repayment")
    private Repayment repayment;
    public static final String SERIALIZED_NAME_STARTS_AT = "startsAt";
    @SerializedName(value="startsAt")
    private Object startsAt;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public GrantOffer accountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
        return this;
    }

    @ApiModelProperty(required=true, value="The identifier of the account holder to which the grant is offered.")
    public String getAccountHolderId() {
        return this.accountHolderId;
    }

    public void setAccountHolderId(String accountHolderId) {
        this.accountHolderId = accountHolderId;
    }

    public GrantOffer amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public GrantOffer contractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
        return this;
    }

    @ApiModelProperty(value="The contract type of the grant offer. Possible value: **cashAdvance**, **loan**.")
    public ContractTypeEnum getContractType() {
        return this.contractType;
    }

    public void setContractType(ContractTypeEnum contractType) {
        this.contractType = contractType;
    }

    public GrantOffer expiresAt(Object expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @ApiModelProperty(value="")
    public Object getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Object expiresAt) {
        this.expiresAt = expiresAt;
    }

    public GrantOffer fee(Fee fee) {
        this.fee = fee;
        return this;
    }

    @ApiModelProperty(value="")
    public Fee getFee() {
        return this.fee;
    }

    public void setFee(Fee fee) {
        this.fee = fee;
    }

    public GrantOffer id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the grant offer.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GrantOffer repayment(Repayment repayment) {
        this.repayment = repayment;
        return this;
    }

    @ApiModelProperty(value="")
    public Repayment getRepayment() {
        return this.repayment;
    }

    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
    }

    public GrantOffer startsAt(Object startsAt) {
        this.startsAt = startsAt;
        return this;
    }

    @ApiModelProperty(value="")
    public Object getStartsAt() {
        return this.startsAt;
    }

    public void setStartsAt(Object startsAt) {
        this.startsAt = startsAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantOffer grantOffer = (GrantOffer)o;
        return Objects.equals(this.accountHolderId, grantOffer.accountHolderId) && Objects.equals(this.amount, grantOffer.amount) && Objects.equals((Object)this.contractType, (Object)grantOffer.contractType) && Objects.equals(this.expiresAt, grantOffer.expiresAt) && Objects.equals(this.fee, grantOffer.fee) && Objects.equals(this.id, grantOffer.id) && Objects.equals(this.repayment, grantOffer.repayment) && Objects.equals(this.startsAt, grantOffer.startsAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolderId, this.amount, this.contractType, this.expiresAt, this.fee, this.id, this.repayment, this.startsAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantOffer {\n");
        sb.append("    accountHolderId: ").append(this.toIndentedString(this.accountHolderId)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    contractType: ").append(this.toIndentedString((Object)this.contractType)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    startsAt: ").append(this.toIndentedString(this.startsAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in GrantOffer is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `GrantOffer` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `accountHolderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_HOLDER_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `contractType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPE).toString()));
            }
            ContractTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_CONTRACT_TYPE).getAsString());
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_FEE) != null) {
            Fee.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_FEE));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_REPAYMENT) != null) {
            Repayment.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_REPAYMENT));
        }
    }

    public static GrantOffer fromJson(String jsonString) throws IOException {
        return (GrantOffer)JSON.getGson().fromJson(jsonString, GrantOffer.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CONTRACT_TYPE);
        openapiFields.add(SERIALIZED_NAME_EXPIRES_AT);
        openapiFields.add(SERIALIZED_NAME_FEE);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_REPAYMENT);
        openapiFields.add(SERIALIZED_NAME_STARTS_AT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACCOUNT_HOLDER_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!GrantOffer.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(GrantOffer.class));
            return new TypeAdapter<GrantOffer>(){

                public void write(JsonWriter out, GrantOffer value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public GrantOffer read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    GrantOffer.validateJsonObject(jsonObj);
                    return (GrantOffer)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ContractTypeEnum {
        CASHADVANCE("cashAdvance"),
        LOAN("loan");

        private String value;

        private ContractTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ContractTypeEnum fromValue(String value) {
            for (ContractTypeEnum b : ContractTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ContractTypeEnum> {
            public void write(JsonWriter jsonWriter, ContractTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ContractTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ContractTypeEnum.fromValue(value);
            }
        }
    }
}

