/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balancecontrol;

import com.adyen.model.balancecontrol.Amount;
import com.adyen.model.balancecontrol.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BalanceTransferRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FROM_MERCHANT = "fromMerchant";
    @SerializedName(value="fromMerchant")
    private String fromMerchant;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    private String reference;
    public static final String SERIALIZED_NAME_TO_MERCHANT = "toMerchant";
    @SerializedName(value="toMerchant")
    private String toMerchant;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public BalanceTransferRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public BalanceTransferRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A human-readable description for the transfer. You can use alphanumeric characters and hyphens. We recommend sending a maximum of 140 characters, otherwise the description may be truncated.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BalanceTransferRequest fromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the source merchant account from which funds are deducted.")
    public String getFromMerchant() {
        return this.fromMerchant;
    }

    public void setFromMerchant(String fromMerchant) {
        this.fromMerchant = fromMerchant;
    }

    public BalanceTransferRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @ApiModelProperty(value="A reference for the balance transfer. If you don't provide this in the request, Adyen generates a unique reference. Maximum length: 80 characters.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public BalanceTransferRequest toMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
        return this;
    }

    @ApiModelProperty(required=true, value="The unique identifier of the destination merchant account from which funds are transferred.")
    public String getToMerchant() {
        return this.toMerchant;
    }

    public void setToMerchant(String toMerchant) {
        this.toMerchant = toMerchant;
    }

    public BalanceTransferRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of balance transfer. Possible values: **tax**, **fee**, **terminalSale**, **credit**, **debit**, and **adjustment**.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceTransferRequest balanceTransferRequest = (BalanceTransferRequest)o;
        return Objects.equals(this.amount, balanceTransferRequest.amount) && Objects.equals(this.description, balanceTransferRequest.description) && Objects.equals(this.fromMerchant, balanceTransferRequest.fromMerchant) && Objects.equals(this.reference, balanceTransferRequest.reference) && Objects.equals(this.toMerchant, balanceTransferRequest.toMerchant) && Objects.equals((Object)this.type, (Object)balanceTransferRequest.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.description, this.fromMerchant, this.reference, this.toMerchant, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceTransferRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromMerchant: ").append(this.toIndentedString(this.fromMerchant)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    toMerchant: ").append(this.toIndentedString(this.toMerchant)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in BalanceTransferRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `BalanceTransferRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT) != null && !jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fromMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FROM_MERCHANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TO_MERCHANT) != null && !jsonObj.get(SERIALIZED_NAME_TO_MERCHANT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `toMerchant` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TO_MERCHANT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static BalanceTransferRequest fromJson(String jsonString) throws IOException {
        return (BalanceTransferRequest)JSON.getGson().fromJson(jsonString, BalanceTransferRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_FROM_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_TO_MERCHANT);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_FROM_MERCHANT);
        openapiRequiredFields.add(SERIALIZED_NAME_TO_MERCHANT);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!BalanceTransferRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BalanceTransferRequest.class));
            return new TypeAdapter<BalanceTransferRequest>(){

                public void write(JsonWriter out, BalanceTransferRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public BalanceTransferRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    BalanceTransferRequest.validateJsonObject(jsonObj);
                    return (BalanceTransferRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        TAX("tax"),
        FEE("fee"),
        TERMINALSALE("terminalSale"),
        CREDIT("credit"),
        DEBIT("debit"),
        ADJUSTMENT("adjustment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

