/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.ApiKeyAuthenticatedService;
import com.adyen.Client;
import com.adyen.constants.ApiConstants;
import com.adyen.model.management.CompanyUser;
import com.adyen.model.management.CreateCompanyUserRequest;
import com.adyen.model.management.CreateCompanyUserResponse;
import com.adyen.model.management.JSON;
import com.adyen.model.management.ListCompanyUsersResponse;
import com.adyen.model.management.UpdateCompanyUserRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.ManagementResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class UsersCompanyLevel
extends ApiKeyAuthenticatedService {
    public UsersCompanyLevel(Client client) {
        super(client);
        new JSON();
    }

    public ListCompanyUsersResponse listUsers(String companyId, Map<String, String> queryParams) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/users");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams, queryParams);
        return ListCompanyUsersResponse.fromJson(jsonResult);
    }

    public CompanyUser getUserDetails(String companyId, String userId) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("userId", userId);
        String requestBody = null;
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/users/{userId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.GET, pathParams);
        return CompanyUser.fromJson(jsonResult);
    }

    public CompanyUser updateUserDetails(String companyId, String userId, UpdateCompanyUserRequest updateCompanyUserRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        pathParams.put("userId", userId);
        String requestBody = updateCompanyUserRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/users/{userId}");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.PATCH, pathParams);
        return CompanyUser.fromJson(jsonResult);
    }

    public CreateCompanyUserResponse createNewUser(String companyId, CreateCompanyUserRequest createCompanyUserRequest) throws ApiException, IOException {
        if (companyId == null) {
            throw new ApiException("Missing the required parameter 'companyId'", 400);
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        pathParams.put("companyId", companyId);
        String requestBody = createCompanyUserRequest.toJson();
        ManagementResource resource = new ManagementResource(this, "/companies/{companyId}/users");
        String jsonResult = resource.request(requestBody, null, ApiConstants.HttpMethod.POST, pathParams);
        return CreateCompanyUserResponse.fromJson(jsonResult);
    }
}

