/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.ShopperStatement;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UpdatePaymentMethodInfo {
    public static final String SERIALIZED_NAME_COUNTRIES = "countries";
    @SerializedName(value="countries")
    private List<String> countries = null;
    public static final String SERIALIZED_NAME_CURRENCIES = "currencies";
    @SerializedName(value="currencies")
    private List<String> currencies = null;
    public static final String SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS = "customRoutingFlags";
    @SerializedName(value="customRoutingFlags")
    private List<String> customRoutingFlags = null;
    public static final String SERIALIZED_NAME_ENABLED = "enabled";
    @SerializedName(value="enabled")
    private Boolean enabled;
    public static final String SERIALIZED_NAME_SHOPPER_STATEMENT = "shopperStatement";
    @SerializedName(value="shopperStatement")
    private ShopperStatement shopperStatement;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public UpdatePaymentMethodInfo countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    public UpdatePaymentMethodInfo addCountriesItem(String countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @ApiModelProperty(value="The list of countries where a payment method is available. By default, all countries supported by the payment method.")
    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public UpdatePaymentMethodInfo currencies(List<String> currencies) {
        this.currencies = currencies;
        return this;
    }

    public UpdatePaymentMethodInfo addCurrenciesItem(String currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new ArrayList<String>();
        }
        this.currencies.add(currenciesItem);
        return this;
    }

    @ApiModelProperty(value="The list of currencies that a payment method supports. By default, all currencies supported by the payment method.")
    public List<String> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<String> currencies) {
        this.currencies = currencies;
    }

    public UpdatePaymentMethodInfo customRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
        return this;
    }

    public UpdatePaymentMethodInfo addCustomRoutingFlagsItem(String customRoutingFlagsItem) {
        if (this.customRoutingFlags == null) {
            this.customRoutingFlags = new ArrayList<String>();
        }
        this.customRoutingFlags.add(customRoutingFlagsItem);
        return this;
    }

    @ApiModelProperty(value="Custom routing flags for acquirer routing.")
    public List<String> getCustomRoutingFlags() {
        return this.customRoutingFlags;
    }

    public void setCustomRoutingFlags(List<String> customRoutingFlags) {
        this.customRoutingFlags = customRoutingFlags;
    }

    public UpdatePaymentMethodInfo enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(value="Indicates whether the payment method is enabled (**true**) or disabled (**false**).")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public UpdatePaymentMethodInfo shopperStatement(ShopperStatement shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @ApiModelProperty(value="")
    public ShopperStatement getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(ShopperStatement shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdatePaymentMethodInfo updatePaymentMethodInfo = (UpdatePaymentMethodInfo)o;
        return Objects.equals(this.countries, updatePaymentMethodInfo.countries) && Objects.equals(this.currencies, updatePaymentMethodInfo.currencies) && Objects.equals(this.customRoutingFlags, updatePaymentMethodInfo.customRoutingFlags) && Objects.equals(this.enabled, updatePaymentMethodInfo.enabled) && Objects.equals(this.shopperStatement, updatePaymentMethodInfo.shopperStatement);
    }

    public int hashCode() {
        return Objects.hash(this.countries, this.currencies, this.customRoutingFlags, this.enabled, this.shopperStatement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdatePaymentMethodInfo {\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    customRoutingFlags: ").append(this.toIndentedString(this.customRoutingFlags)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in UpdatePaymentMethodInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `UpdatePaymentMethodInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COUNTRIES) != null && !jsonObj.get(SERIALIZED_NAME_COUNTRIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `countries` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COUNTRIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENCIES) != null && !jsonObj.get(SERIALIZED_NAME_CURRENCIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `currencies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENCIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `customRoutingFlags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_STATEMENT) != null) {
            ShopperStatement.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_SHOPPER_STATEMENT));
        }
    }

    public static UpdatePaymentMethodInfo fromJson(String jsonString) throws IOException {
        return (UpdatePaymentMethodInfo)JSON.getGson().fromJson(jsonString, UpdatePaymentMethodInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COUNTRIES);
        openapiFields.add(SERIALIZED_NAME_CURRENCIES);
        openapiFields.add(SERIALIZED_NAME_CUSTOM_ROUTING_FLAGS);
        openapiFields.add(SERIALIZED_NAME_ENABLED);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_STATEMENT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!UpdatePaymentMethodInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(UpdatePaymentMethodInfo.class));
            return new TypeAdapter<UpdatePaymentMethodInfo>(){

                public void write(JsonWriter out, UpdatePaymentMethodInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public UpdatePaymentMethodInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    UpdatePaymentMethodInfo.validateJsonObject(jsonObj);
                    return (UpdatePaymentMethodInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

