/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReceiptOptions {
    public static final String SERIALIZED_NAME_LOGO = "logo";
    @SerializedName(value="logo")
    private String logo;
    public static final String SERIALIZED_NAME_QR_CODE_DATA = "qrCodeData";
    @SerializedName(value="qrCodeData")
    private String qrCodeData;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ReceiptOptions logo(String logo) {
        this.logo = logo;
        return this;
    }

    @ApiModelProperty(value="The receipt logo converted to a Base64-encoded string. The image must be a .bmp file of < 256 KB, dimensions 240 (H) x 384 (W) px.")
    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public ReceiptOptions qrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
        return this;
    }

    @ApiModelProperty(value="Data to print on the receipt as a QR code. This can include static text and the following variables:  - `${merchantreference}`: the merchant reference of the transaction. - `${pspreference}`: the PSP reference of the transaction.   For example, **http://www.example.com/order/${pspreference}/${merchantreference}**.")
    public String getQrCodeData() {
        return this.qrCodeData;
    }

    public void setQrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiptOptions receiptOptions = (ReceiptOptions)o;
        return Objects.equals(this.logo, receiptOptions.logo) && Objects.equals(this.qrCodeData, receiptOptions.qrCodeData);
    }

    public int hashCode() {
        return Objects.hash(this.logo, this.qrCodeData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReceiptOptions {\n");
        sb.append("    logo: ").append(this.toIndentedString(this.logo)).append("\n");
        sb.append("    qrCodeData: ").append(this.toIndentedString(this.qrCodeData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ReceiptOptions is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ReceiptOptions` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOGO) != null && !jsonObj.get(SERIALIZED_NAME_LOGO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `logo` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOGO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA) != null && !jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `qrCodeData` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_QR_CODE_DATA).toString()));
        }
    }

    public static ReceiptOptions fromJson(String jsonString) throws IOException {
        return (ReceiptOptions)JSON.getGson().fromJson(jsonString, ReceiptOptions.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOGO);
        openapiFields.add(SERIALIZED_NAME_QR_CODE_DATA);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ReceiptOptions.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ReceiptOptions.class));
            return new TypeAdapter<ReceiptOptions>(){

                public void write(JsonWriter out, ReceiptOptions value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ReceiptOptions read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ReceiptOptions.validateJsonObject(jsonObj);
                    return (ReceiptOptions)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

