/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class OnboardingLinkInfo {
    public static final String SERIALIZED_NAME_LOCALE = "locale";
    @SerializedName(value="locale")
    private String locale;
    public static final String SERIALIZED_NAME_REDIRECT_URL = "redirectUrl";
    @SerializedName(value="redirectUrl")
    private String redirectUrl;
    public static final String SERIALIZED_NAME_SETTINGS = "settings";
    @SerializedName(value="settings")
    private Map<String, Boolean> settings = null;
    public static final String SERIALIZED_NAME_THEME_ID = "themeId";
    @SerializedName(value="themeId")
    private String themeId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OnboardingLinkInfo locale(String locale) {
        this.locale = locale;
        return this;
    }

    @ApiModelProperty(value="The language that will be used for the page, specified by a combination of two letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language and [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) country codes. See [possible values](https://docs.adyen.com/marketplaces-and-platforms/collect-verification-details/hosted#supported-languages).   If not specified in the request or if the language is not supported, the page uses the browser language. If the browser language is not supported, the page uses **en-US** by default.")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public OnboardingLinkInfo redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @ApiModelProperty(value="The URL where the user is redirected after they complete hosted onboarding.")
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public OnboardingLinkInfo settings(Map<String, Boolean> settings) {
        this.settings = settings;
        return this;
    }

    public OnboardingLinkInfo putSettingsItem(String key, Boolean settingsItem) {
        if (this.settings == null) {
            this.settings = new HashMap<String, Boolean>();
        }
        this.settings.put(key, settingsItem);
        return this;
    }

    @ApiModelProperty(value="Boolean key-value pairs indicating the settings for the hosted onboarding page. The keys are the settings. By default, the values are set to **true**. Set to **false** to not allow the action.  Possible keys:  - **changeLegalEntityType**: The user can change their legal entity type.  - **editPrefilledCountry**: The user can change the country of their legal entity's address, for example the registered address of an organization.  ")
    public Map<String, Boolean> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Boolean> settings) {
        this.settings = settings;
    }

    public OnboardingLinkInfo themeId(String themeId) {
        this.themeId = themeId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the hosted onboarding theme.")
    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnboardingLinkInfo onboardingLinkInfo = (OnboardingLinkInfo)o;
        return Objects.equals(this.locale, onboardingLinkInfo.locale) && Objects.equals(this.redirectUrl, onboardingLinkInfo.redirectUrl) && Objects.equals(this.settings, onboardingLinkInfo.settings) && Objects.equals(this.themeId, onboardingLinkInfo.themeId);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.redirectUrl, this.settings, this.themeId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnboardingLinkInfo {\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    themeId: ").append(this.toIndentedString(this.themeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in OnboardingLinkInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OnboardingLinkInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOCALE) != null && !jsonObj.get(SERIALIZED_NAME_LOCALE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `locale` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOCALE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REDIRECT_URL) != null && !jsonObj.get(SERIALIZED_NAME_REDIRECT_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `redirectUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REDIRECT_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THEME_ID) != null && !jsonObj.get(SERIALIZED_NAME_THEME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `themeId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THEME_ID).toString()));
        }
    }

    public static OnboardingLinkInfo fromJson(String jsonString) throws IOException {
        return (OnboardingLinkInfo)JSON.getGson().fromJson(jsonString, OnboardingLinkInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOCALE);
        openapiFields.add(SERIALIZED_NAME_REDIRECT_URL);
        openapiFields.add(SERIALIZED_NAME_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_THEME_ID);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OnboardingLinkInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OnboardingLinkInfo.class));
            return new TypeAdapter<OnboardingLinkInfo>(){

                public void write(JsonWriter out, OnboardingLinkInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OnboardingLinkInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    OnboardingLinkInfo.validateJsonObject(jsonObj);
                    return (OnboardingLinkInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

