/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AcceptTermsOfServiceResponse {
    public static final String SERIALIZED_NAME_ACCEPTED_BY = "acceptedBy";
    @SerializedName(value="acceptedBy")
    private String acceptedBy;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_IP_ADDRESS = "ipAddress";
    @SerializedName(value="ipAddress")
    private String ipAddress;
    public static final String SERIALIZED_NAME_LANGUAGE = "language";
    @SerializedName(value="language")
    private String language;
    public static final String SERIALIZED_NAME_TERMS_OF_SERVICE_DOCUMENT_ID = "termsOfServiceDocumentId";
    @SerializedName(value="termsOfServiceDocumentId")
    private String termsOfServiceDocumentId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AcceptTermsOfServiceResponse acceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the user that accepted the Terms of Service.")
    public String getAcceptedBy() {
        return this.acceptedBy;
    }

    public void setAcceptedBy(String acceptedBy) {
        this.acceptedBy = acceptedBy;
    }

    public AcceptTermsOfServiceResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Terms of Service acceptance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AcceptTermsOfServiceResponse ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    @ApiModelProperty(value="The IP address of the user that accepted the Terms of Service.")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public AcceptTermsOfServiceResponse language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The language used for the Terms of Service document, specified by the two letter [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code. For example, **nl** for Dutch.")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public AcceptTermsOfServiceResponse termsOfServiceDocumentId(String termsOfServiceDocumentId) {
        this.termsOfServiceDocumentId = termsOfServiceDocumentId;
        return this;
    }

    @ApiModelProperty(value="The unique identifier of the Terms of Service document.")
    public String getTermsOfServiceDocumentId() {
        return this.termsOfServiceDocumentId;
    }

    public void setTermsOfServiceDocumentId(String termsOfServiceDocumentId) {
        this.termsOfServiceDocumentId = termsOfServiceDocumentId;
    }

    public AcceptTermsOfServiceResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of Terms of Service.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptTermsOfServiceResponse acceptTermsOfServiceResponse = (AcceptTermsOfServiceResponse)o;
        return Objects.equals(this.acceptedBy, acceptTermsOfServiceResponse.acceptedBy) && Objects.equals(this.id, acceptTermsOfServiceResponse.id) && Objects.equals(this.ipAddress, acceptTermsOfServiceResponse.ipAddress) && Objects.equals(this.language, acceptTermsOfServiceResponse.language) && Objects.equals(this.termsOfServiceDocumentId, acceptTermsOfServiceResponse.termsOfServiceDocumentId) && Objects.equals((Object)this.type, (Object)acceptTermsOfServiceResponse.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptedBy, this.id, this.ipAddress, this.language, this.termsOfServiceDocumentId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceptTermsOfServiceResponse {\n");
        sb.append("    acceptedBy: ").append(this.toIndentedString(this.acceptedBy)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ipAddress: ").append(this.toIndentedString(this.ipAddress)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    termsOfServiceDocumentId: ").append(this.toIndentedString(this.termsOfServiceDocumentId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AcceptTermsOfServiceResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AcceptTermsOfServiceResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY) != null && !jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `acceptedBy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCEPTED_BY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_ADDRESS) != null && !jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ipAddress` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_ADDRESS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LANGUAGE) != null && !jsonObj.get(SERIALIZED_NAME_LANGUAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `language` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LANGUAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMS_OF_SERVICE_DOCUMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_TERMS_OF_SERVICE_DOCUMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `termsOfServiceDocumentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMS_OF_SERVICE_DOCUMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static AcceptTermsOfServiceResponse fromJson(String jsonString) throws IOException {
        return (AcceptTermsOfServiceResponse)JSON.getGson().fromJson(jsonString, AcceptTermsOfServiceResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPTED_BY);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_IP_ADDRESS);
        openapiFields.add(SERIALIZED_NAME_LANGUAGE);
        openapiFields.add(SERIALIZED_NAME_TERMS_OF_SERVICE_DOCUMENT_ID);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AcceptTermsOfServiceResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AcceptTermsOfServiceResponse.class));
            return new TypeAdapter<AcceptTermsOfServiceResponse>(){

                public void write(JsonWriter out, AcceptTermsOfServiceResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AcceptTermsOfServiceResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AcceptTermsOfServiceResponse.validateJsonObject(jsonObj);
                    return (AcceptTermsOfServiceResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        ADYENACCOUNT("adyenAccount"),
        ADYENCAPITAL("adyenCapital"),
        ADYENFORPLATFORMSADVANCED("adyenForPlatformsAdvanced"),
        ADYENFORPLATFORMSMANAGE("adyenForPlatformsManage"),
        ADYENISSUING("adyenIssuing");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

