/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.binlookup;

import com.adyen.model.binlookup.Amount;
import com.adyen.model.binlookup.CostEstimateAssumptions;
import com.adyen.model.binlookup.JSON;
import com.adyen.model.binlookup.MerchantDetails;
import com.adyen.model.binlookup.Recurring;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CostEstimateRequest {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Amount amount;
    public static final String SERIALIZED_NAME_ASSUMPTIONS = "assumptions";
    @SerializedName(value="assumptions")
    private CostEstimateAssumptions assumptions;
    public static final String SERIALIZED_NAME_CARD_NUMBER = "cardNumber";
    @SerializedName(value="cardNumber")
    private String cardNumber;
    public static final String SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    @SerializedName(value="encryptedCardNumber")
    private String encryptedCardNumber;
    public static final String SERIALIZED_NAME_MERCHANT_ACCOUNT = "merchantAccount";
    @SerializedName(value="merchantAccount")
    private String merchantAccount;
    public static final String SERIALIZED_NAME_MERCHANT_DETAILS = "merchantDetails";
    @SerializedName(value="merchantDetails")
    private MerchantDetails merchantDetails;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    @SerializedName(value="selectedRecurringDetailReference")
    private String selectedRecurringDetailReference;
    public static final String SERIALIZED_NAME_SHOPPER_INTERACTION = "shopperInteraction";
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction;
    public static final String SERIALIZED_NAME_SHOPPER_REFERENCE = "shopperReference";
    @SerializedName(value="shopperReference")
    private String shopperReference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CostEstimateRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CostEstimateRequest assumptions(CostEstimateAssumptions assumptions) {
        this.assumptions = assumptions;
        return this;
    }

    @ApiModelProperty(value="")
    public CostEstimateAssumptions getAssumptions() {
        return this.assumptions;
    }

    public void setAssumptions(CostEstimateAssumptions assumptions) {
        this.assumptions = assumptions;
    }

    public CostEstimateRequest cardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
        return this;
    }

    @ApiModelProperty(value="The card number (4-19 characters) for PCI compliant use cases. Do not use any separators.  > Either the `cardNumber` or `encryptedCardNumber` field must be provided in a payment request.")
    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public CostEstimateRequest encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @ApiModelProperty(value="Encrypted data that stores card information for non PCI-compliant use cases. The encrypted data must be created with the Checkout Card Component or Secured Fields Component, and must contain the `encryptedCardNumber` field.  > Either the `cardNumber` or `encryptedCardNumber` field must be provided in a payment request.")
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CostEstimateRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier you want to process the (transaction) request with.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CostEstimateRequest merchantDetails(MerchantDetails merchantDetails) {
        this.merchantDetails = merchantDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public MerchantDetails getMerchantDetails() {
        return this.merchantDetails;
    }

    public void setMerchantDetails(MerchantDetails merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public CostEstimateRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @ApiModelProperty(value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public CostEstimateRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return this;
    }

    @ApiModelProperty(value="The `recurringDetailReference` you want to use for this cost estimate. The value `LATEST` can be used to select the most recently stored recurring detail.")
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public CostEstimateRequest shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return this;
    }

    @ApiModelProperty(value="Specifies the sales channel, through which the shopper gives their card details, and whether the shopper is a returning customer. For the web service API, Adyen assumes Ecommerce shopper interaction by default.  This field has the following possible values: * `Ecommerce` - Online transactions where the cardholder is present (online). For better authorisation rates, we recommend sending the card security code (CSC) along with the request. * `ContAuth` - Card on file and/or subscription transactions, where the card holder is known to the merchant (returning customer). If the shopper is present (online), you can supply also the CSC to improve authorisation (one-click payment). * `Moto` - Mail-order and telephone-order transactions where the shopper is in contact with the merchant via email or telephone. * `POS` - Point-of-sale transactions where the shopper is physically present to make a payment using a secure payment terminal.")
    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public CostEstimateRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @ApiModelProperty(value="Required for recurring payments.  Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CostEstimateRequest costEstimateRequest = (CostEstimateRequest)o;
        return Objects.equals(this.amount, costEstimateRequest.amount) && Objects.equals(this.assumptions, costEstimateRequest.assumptions) && Objects.equals(this.cardNumber, costEstimateRequest.cardNumber) && Objects.equals(this.encryptedCardNumber, costEstimateRequest.encryptedCardNumber) && Objects.equals(this.merchantAccount, costEstimateRequest.merchantAccount) && Objects.equals(this.merchantDetails, costEstimateRequest.merchantDetails) && Objects.equals(this.recurring, costEstimateRequest.recurring) && Objects.equals(this.selectedRecurringDetailReference, costEstimateRequest.selectedRecurringDetailReference) && Objects.equals((Object)this.shopperInteraction, (Object)costEstimateRequest.shopperInteraction) && Objects.equals(this.shopperReference, costEstimateRequest.shopperReference);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.assumptions, this.cardNumber, this.encryptedCardNumber, this.merchantAccount, this.merchantDetails, this.recurring, this.selectedRecurringDetailReference, this.shopperInteraction, this.shopperReference});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CostEstimateRequest {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    assumptions: ").append(this.toIndentedString(this.assumptions)).append("\n");
        sb.append("    cardNumber: ").append(this.toIndentedString(this.cardNumber)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantDetails: ").append(this.toIndentedString(this.merchantDetails)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperInteraction: ").append(this.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CostEstimateRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CostEstimateRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT) != null) {
            Amount.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_AMOUNT));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ASSUMPTIONS) != null) {
            CostEstimateAssumptions.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ASSUMPTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_CARD_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_CARD_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cardNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CARD_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedCardNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT) != null && !jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `merchantAccount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MERCHANT_ACCOUNT).toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_DETAILS) != null) {
            MerchantDetails.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MERCHANT_DETAILS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING) != null) {
            Recurring.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_RECURRING));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectedRecurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `shopperInteraction` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).toString()));
            }
            ShopperInteractionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SHOPPER_INTERACTION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_REFERENCE).toString()));
        }
    }

    public static CostEstimateRequest fromJson(String jsonString) throws IOException {
        return (CostEstimateRequest)JSON.getGson().fromJson(jsonString, CostEstimateRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_ASSUMPTIONS);
        openapiFields.add(SERIALIZED_NAME_CARD_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
        openapiFields.add(SERIALIZED_NAME_MERCHANT_DETAILS);
        openapiFields.add(SERIALIZED_NAME_RECURRING);
        openapiFields.add(SERIALIZED_NAME_SELECTED_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_INTERACTION);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_REFERENCE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_AMOUNT);
        openapiRequiredFields.add(SERIALIZED_NAME_MERCHANT_ACCOUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CostEstimateRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CostEstimateRequest.class));
            return new TypeAdapter<CostEstimateRequest>(){

                public void write(JsonWriter out, CostEstimateRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CostEstimateRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CostEstimateRequest.validateJsonObject(jsonObj);
                    return (CostEstimateRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        private String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShopperInteractionEnum fromValue(String value) {
            for (ShopperInteractionEnum b : ShopperInteractionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(value);
            }
        }
    }
}

