/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payments;

import com.adyen.model.payments.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AccountInfo {
    public static final String SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR = "accountAgeIndicator";
    @SerializedName(value="accountAgeIndicator")
    private AccountAgeIndicatorEnum accountAgeIndicator;
    public static final String SERIALIZED_NAME_ACCOUNT_CHANGE_DATE = "accountChangeDate";
    @SerializedName(value="accountChangeDate")
    private OffsetDateTime accountChangeDate;
    public static final String SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR = "accountChangeIndicator";
    @SerializedName(value="accountChangeIndicator")
    private AccountChangeIndicatorEnum accountChangeIndicator;
    public static final String SERIALIZED_NAME_ACCOUNT_CREATION_DATE = "accountCreationDate";
    @SerializedName(value="accountCreationDate")
    private OffsetDateTime accountCreationDate;
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "accountType";
    @SerializedName(value="accountType")
    private AccountTypeEnum accountType;
    public static final String SERIALIZED_NAME_ADD_CARD_ATTEMPTS_DAY = "addCardAttemptsDay";
    @SerializedName(value="addCardAttemptsDay")
    private Integer addCardAttemptsDay;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_DATE = "deliveryAddressUsageDate";
    @SerializedName(value="deliveryAddressUsageDate")
    private OffsetDateTime deliveryAddressUsageDate;
    public static final String SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR = "deliveryAddressUsageIndicator";
    @SerializedName(value="deliveryAddressUsageIndicator")
    private DeliveryAddressUsageIndicatorEnum deliveryAddressUsageIndicator;
    public static final String SERIALIZED_NAME_HOME_PHONE = "homePhone";
    @SerializedName(value="homePhone")
    private String homePhone;
    public static final String SERIALIZED_NAME_MOBILE_PHONE = "mobilePhone";
    @SerializedName(value="mobilePhone")
    private String mobilePhone;
    public static final String SERIALIZED_NAME_PASSWORD_CHANGE_DATE = "passwordChangeDate";
    @SerializedName(value="passwordChangeDate")
    private OffsetDateTime passwordChangeDate;
    public static final String SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR = "passwordChangeIndicator";
    @SerializedName(value="passwordChangeIndicator")
    private PasswordChangeIndicatorEnum passwordChangeIndicator;
    public static final String SERIALIZED_NAME_PAST_TRANSACTIONS_DAY = "pastTransactionsDay";
    @SerializedName(value="pastTransactionsDay")
    private Integer pastTransactionsDay;
    public static final String SERIALIZED_NAME_PAST_TRANSACTIONS_YEAR = "pastTransactionsYear";
    @SerializedName(value="pastTransactionsYear")
    private Integer pastTransactionsYear;
    public static final String SERIALIZED_NAME_PAYMENT_ACCOUNT_AGE = "paymentAccountAge";
    @SerializedName(value="paymentAccountAge")
    private OffsetDateTime paymentAccountAge;
    public static final String SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR = "paymentAccountIndicator";
    @SerializedName(value="paymentAccountIndicator")
    private PaymentAccountIndicatorEnum paymentAccountIndicator;
    public static final String SERIALIZED_NAME_PURCHASES_LAST6_MONTHS = "purchasesLast6Months";
    @SerializedName(value="purchasesLast6Months")
    private Integer purchasesLast6Months;
    public static final String SERIALIZED_NAME_SUSPICIOUS_ACTIVITY = "suspiciousActivity";
    @SerializedName(value="suspiciousActivity")
    private Boolean suspiciousActivity;
    public static final String SERIALIZED_NAME_WORK_PHONE = "workPhone";
    @SerializedName(value="workPhone")
    private String workPhone;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AccountInfo accountAgeIndicator(AccountAgeIndicatorEnum accountAgeIndicator) {
        this.accountAgeIndicator = accountAgeIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator for the length of time since this shopper account was created in the merchant's environment. Allowed values: * notApplicable * thisTransaction * lessThan30Days * from30To60Days * moreThan60Days")
    public AccountAgeIndicatorEnum getAccountAgeIndicator() {
        return this.accountAgeIndicator;
    }

    public void setAccountAgeIndicator(AccountAgeIndicatorEnum accountAgeIndicator) {
        this.accountAgeIndicator = accountAgeIndicator;
    }

    public AccountInfo accountChangeDate(OffsetDateTime accountChangeDate) {
        this.accountChangeDate = accountChangeDate;
        return this;
    }

    @ApiModelProperty(value="Date when the shopper's account was last changed.")
    public OffsetDateTime getAccountChangeDate() {
        return this.accountChangeDate;
    }

    public void setAccountChangeDate(OffsetDateTime accountChangeDate) {
        this.accountChangeDate = accountChangeDate;
    }

    public AccountInfo accountChangeIndicator(AccountChangeIndicatorEnum accountChangeIndicator) {
        this.accountChangeIndicator = accountChangeIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator for the length of time since the shopper's account was last updated. Allowed values: * thisTransaction * lessThan30Days * from30To60Days * moreThan60Days")
    public AccountChangeIndicatorEnum getAccountChangeIndicator() {
        return this.accountChangeIndicator;
    }

    public void setAccountChangeIndicator(AccountChangeIndicatorEnum accountChangeIndicator) {
        this.accountChangeIndicator = accountChangeIndicator;
    }

    public AccountInfo accountCreationDate(OffsetDateTime accountCreationDate) {
        this.accountCreationDate = accountCreationDate;
        return this;
    }

    @ApiModelProperty(value="Date when the shopper's account was created.")
    public OffsetDateTime getAccountCreationDate() {
        return this.accountCreationDate;
    }

    public void setAccountCreationDate(OffsetDateTime accountCreationDate) {
        this.accountCreationDate = accountCreationDate;
    }

    public AccountInfo accountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
        return this;
    }

    @ApiModelProperty(value="Indicates the type of account. For example, for a multi-account card product. Allowed values: * notApplicable * credit * debit")
    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public AccountInfo addCardAttemptsDay(Integer addCardAttemptsDay) {
        this.addCardAttemptsDay = addCardAttemptsDay;
        return this;
    }

    @ApiModelProperty(value="Number of attempts the shopper tried to add a card to their account in the last day.")
    public Integer getAddCardAttemptsDay() {
        return this.addCardAttemptsDay;
    }

    public void setAddCardAttemptsDay(Integer addCardAttemptsDay) {
        this.addCardAttemptsDay = addCardAttemptsDay;
    }

    public AccountInfo deliveryAddressUsageDate(OffsetDateTime deliveryAddressUsageDate) {
        this.deliveryAddressUsageDate = deliveryAddressUsageDate;
        return this;
    }

    @ApiModelProperty(value="Date the selected delivery address was first used.")
    public OffsetDateTime getDeliveryAddressUsageDate() {
        return this.deliveryAddressUsageDate;
    }

    public void setDeliveryAddressUsageDate(OffsetDateTime deliveryAddressUsageDate) {
        this.deliveryAddressUsageDate = deliveryAddressUsageDate;
    }

    public AccountInfo deliveryAddressUsageIndicator(DeliveryAddressUsageIndicatorEnum deliveryAddressUsageIndicator) {
        this.deliveryAddressUsageIndicator = deliveryAddressUsageIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator for the length of time since this delivery address was first used. Allowed values: * thisTransaction * lessThan30Days * from30To60Days * moreThan60Days")
    public DeliveryAddressUsageIndicatorEnum getDeliveryAddressUsageIndicator() {
        return this.deliveryAddressUsageIndicator;
    }

    public void setDeliveryAddressUsageIndicator(DeliveryAddressUsageIndicatorEnum deliveryAddressUsageIndicator) {
        this.deliveryAddressUsageIndicator = deliveryAddressUsageIndicator;
    }

    public AccountInfo homePhone(String homePhone) {
        this.homePhone = homePhone;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Shopper's home phone number (including the country code).")
    public String getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(String homePhone) {
        this.homePhone = homePhone;
    }

    public AccountInfo mobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Shopper's mobile phone number (including the country code).")
    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public AccountInfo passwordChangeDate(OffsetDateTime passwordChangeDate) {
        this.passwordChangeDate = passwordChangeDate;
        return this;
    }

    @ApiModelProperty(value="Date when the shopper last changed their password.")
    public OffsetDateTime getPasswordChangeDate() {
        return this.passwordChangeDate;
    }

    public void setPasswordChangeDate(OffsetDateTime passwordChangeDate) {
        this.passwordChangeDate = passwordChangeDate;
    }

    public AccountInfo passwordChangeIndicator(PasswordChangeIndicatorEnum passwordChangeIndicator) {
        this.passwordChangeIndicator = passwordChangeIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator when the shopper has changed their password. Allowed values: * notApplicable * thisTransaction * lessThan30Days * from30To60Days * moreThan60Days")
    public PasswordChangeIndicatorEnum getPasswordChangeIndicator() {
        return this.passwordChangeIndicator;
    }

    public void setPasswordChangeIndicator(PasswordChangeIndicatorEnum passwordChangeIndicator) {
        this.passwordChangeIndicator = passwordChangeIndicator;
    }

    public AccountInfo pastTransactionsDay(Integer pastTransactionsDay) {
        this.pastTransactionsDay = pastTransactionsDay;
        return this;
    }

    @ApiModelProperty(value="Number of all transactions (successful and abandoned) from this shopper in the past 24 hours.")
    public Integer getPastTransactionsDay() {
        return this.pastTransactionsDay;
    }

    public void setPastTransactionsDay(Integer pastTransactionsDay) {
        this.pastTransactionsDay = pastTransactionsDay;
    }

    public AccountInfo pastTransactionsYear(Integer pastTransactionsYear) {
        this.pastTransactionsYear = pastTransactionsYear;
        return this;
    }

    @ApiModelProperty(value="Number of all transactions (successful and abandoned) from this shopper in the past year.")
    public Integer getPastTransactionsYear() {
        return this.pastTransactionsYear;
    }

    public void setPastTransactionsYear(Integer pastTransactionsYear) {
        this.pastTransactionsYear = pastTransactionsYear;
    }

    public AccountInfo paymentAccountAge(OffsetDateTime paymentAccountAge) {
        this.paymentAccountAge = paymentAccountAge;
        return this;
    }

    @ApiModelProperty(value="Date this payment method was added to the shopper's account.")
    public OffsetDateTime getPaymentAccountAge() {
        return this.paymentAccountAge;
    }

    public void setPaymentAccountAge(OffsetDateTime paymentAccountAge) {
        this.paymentAccountAge = paymentAccountAge;
    }

    public AccountInfo paymentAccountIndicator(PaymentAccountIndicatorEnum paymentAccountIndicator) {
        this.paymentAccountIndicator = paymentAccountIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicator for the length of time since this payment method was added to this shopper's account. Allowed values: * notApplicable * thisTransaction * lessThan30Days * from30To60Days * moreThan60Days")
    public PaymentAccountIndicatorEnum getPaymentAccountIndicator() {
        return this.paymentAccountIndicator;
    }

    public void setPaymentAccountIndicator(PaymentAccountIndicatorEnum paymentAccountIndicator) {
        this.paymentAccountIndicator = paymentAccountIndicator;
    }

    public AccountInfo purchasesLast6Months(Integer purchasesLast6Months) {
        this.purchasesLast6Months = purchasesLast6Months;
        return this;
    }

    @ApiModelProperty(value="Number of successful purchases in the last six months.")
    public Integer getPurchasesLast6Months() {
        return this.purchasesLast6Months;
    }

    public void setPurchasesLast6Months(Integer purchasesLast6Months) {
        this.purchasesLast6Months = purchasesLast6Months;
    }

    public AccountInfo suspiciousActivity(Boolean suspiciousActivity) {
        this.suspiciousActivity = suspiciousActivity;
        return this;
    }

    @ApiModelProperty(value="Whether suspicious activity was recorded on this account.")
    public Boolean getSuspiciousActivity() {
        return this.suspiciousActivity;
    }

    public void setSuspiciousActivity(Boolean suspiciousActivity) {
        this.suspiciousActivity = suspiciousActivity;
    }

    public AccountInfo workPhone(String workPhone) {
        this.workPhone = workPhone;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="Shopper's work phone number (including the country code).")
    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workPhone) {
        this.workPhone = workPhone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountInfo accountInfo = (AccountInfo)o;
        return Objects.equals((Object)this.accountAgeIndicator, (Object)accountInfo.accountAgeIndicator) && Objects.equals(this.accountChangeDate, accountInfo.accountChangeDate) && Objects.equals((Object)this.accountChangeIndicator, (Object)accountInfo.accountChangeIndicator) && Objects.equals(this.accountCreationDate, accountInfo.accountCreationDate) && Objects.equals((Object)this.accountType, (Object)accountInfo.accountType) && Objects.equals(this.addCardAttemptsDay, accountInfo.addCardAttemptsDay) && Objects.equals(this.deliveryAddressUsageDate, accountInfo.deliveryAddressUsageDate) && Objects.equals((Object)this.deliveryAddressUsageIndicator, (Object)accountInfo.deliveryAddressUsageIndicator) && Objects.equals(this.homePhone, accountInfo.homePhone) && Objects.equals(this.mobilePhone, accountInfo.mobilePhone) && Objects.equals(this.passwordChangeDate, accountInfo.passwordChangeDate) && Objects.equals((Object)this.passwordChangeIndicator, (Object)accountInfo.passwordChangeIndicator) && Objects.equals(this.pastTransactionsDay, accountInfo.pastTransactionsDay) && Objects.equals(this.pastTransactionsYear, accountInfo.pastTransactionsYear) && Objects.equals(this.paymentAccountAge, accountInfo.paymentAccountAge) && Objects.equals((Object)this.paymentAccountIndicator, (Object)accountInfo.paymentAccountIndicator) && Objects.equals(this.purchasesLast6Months, accountInfo.purchasesLast6Months) && Objects.equals(this.suspiciousActivity, accountInfo.suspiciousActivity) && Objects.equals(this.workPhone, accountInfo.workPhone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountAgeIndicator, this.accountChangeDate, this.accountChangeIndicator, this.accountCreationDate, this.accountType, this.addCardAttemptsDay, this.deliveryAddressUsageDate, this.deliveryAddressUsageIndicator, this.homePhone, this.mobilePhone, this.passwordChangeDate, this.passwordChangeIndicator, this.pastTransactionsDay, this.pastTransactionsYear, this.paymentAccountAge, this.paymentAccountIndicator, this.purchasesLast6Months, this.suspiciousActivity, this.workPhone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountInfo {\n");
        sb.append("    accountAgeIndicator: ").append(this.toIndentedString((Object)this.accountAgeIndicator)).append("\n");
        sb.append("    accountChangeDate: ").append(this.toIndentedString(this.accountChangeDate)).append("\n");
        sb.append("    accountChangeIndicator: ").append(this.toIndentedString((Object)this.accountChangeIndicator)).append("\n");
        sb.append("    accountCreationDate: ").append(this.toIndentedString(this.accountCreationDate)).append("\n");
        sb.append("    accountType: ").append(this.toIndentedString((Object)this.accountType)).append("\n");
        sb.append("    addCardAttemptsDay: ").append(this.toIndentedString(this.addCardAttemptsDay)).append("\n");
        sb.append("    deliveryAddressUsageDate: ").append(this.toIndentedString(this.deliveryAddressUsageDate)).append("\n");
        sb.append("    deliveryAddressUsageIndicator: ").append(this.toIndentedString((Object)this.deliveryAddressUsageIndicator)).append("\n");
        sb.append("    homePhone: ").append(this.toIndentedString(this.homePhone)).append("\n");
        sb.append("    mobilePhone: ").append(this.toIndentedString(this.mobilePhone)).append("\n");
        sb.append("    passwordChangeDate: ").append(this.toIndentedString(this.passwordChangeDate)).append("\n");
        sb.append("    passwordChangeIndicator: ").append(this.toIndentedString((Object)this.passwordChangeIndicator)).append("\n");
        sb.append("    pastTransactionsDay: ").append(this.toIndentedString(this.pastTransactionsDay)).append("\n");
        sb.append("    pastTransactionsYear: ").append(this.toIndentedString(this.pastTransactionsYear)).append("\n");
        sb.append("    paymentAccountAge: ").append(this.toIndentedString(this.paymentAccountAge)).append("\n");
        sb.append("    paymentAccountIndicator: ").append(this.toIndentedString((Object)this.paymentAccountIndicator)).append("\n");
        sb.append("    purchasesLast6Months: ").append(this.toIndentedString(this.purchasesLast6Months)).append("\n");
        sb.append("    suspiciousActivity: ").append(this.toIndentedString(this.suspiciousActivity)).append("\n");
        sb.append("    workPhone: ").append(this.toIndentedString(this.workPhone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AccountInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AccountInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `accountAgeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR).toString()));
            }
            AccountAgeIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `accountChangeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR).toString()));
            }
            AccountChangeIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `accountType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).toString()));
            }
            AccountTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_ACCOUNT_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `deliveryAddressUsageIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR).toString()));
            }
            DeliveryAddressUsageIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_HOME_PHONE) != null && !jsonObj.get(SERIALIZED_NAME_HOME_PHONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `homePhone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOME_PHONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOBILE_PHONE) != null && !jsonObj.get(SERIALIZED_NAME_MOBILE_PHONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mobilePhone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOBILE_PHONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `passwordChangeIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR).toString()));
            }
            PasswordChangeIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `paymentAccountIndicator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR).toString()));
            }
            PaymentAccountIndicatorEnum.fromValue(jsonObj.get(SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_WORK_PHONE) != null && !jsonObj.get(SERIALIZED_NAME_WORK_PHONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `workPhone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORK_PHONE).toString()));
        }
    }

    public static AccountInfo fromJson(String jsonString) throws IOException {
        return (AccountInfo)JSON.getGson().fromJson(jsonString, AccountInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_AGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_CHANGE_DATE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_CHANGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_CREATION_DATE);
        openapiFields.add(SERIALIZED_NAME_ACCOUNT_TYPE);
        openapiFields.add(SERIALIZED_NAME_ADD_CARD_ATTEMPTS_DAY);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_DATE);
        openapiFields.add(SERIALIZED_NAME_DELIVERY_ADDRESS_USAGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_HOME_PHONE);
        openapiFields.add(SERIALIZED_NAME_MOBILE_PHONE);
        openapiFields.add(SERIALIZED_NAME_PASSWORD_CHANGE_DATE);
        openapiFields.add(SERIALIZED_NAME_PASSWORD_CHANGE_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_PAST_TRANSACTIONS_DAY);
        openapiFields.add(SERIALIZED_NAME_PAST_TRANSACTIONS_YEAR);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_ACCOUNT_AGE);
        openapiFields.add(SERIALIZED_NAME_PAYMENT_ACCOUNT_INDICATOR);
        openapiFields.add(SERIALIZED_NAME_PURCHASES_LAST6_MONTHS);
        openapiFields.add(SERIALIZED_NAME_SUSPICIOUS_ACTIVITY);
        openapiFields.add(SERIALIZED_NAME_WORK_PHONE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AccountInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AccountInfo.class));
            return new TypeAdapter<AccountInfo>(){

                public void write(JsonWriter out, AccountInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AccountInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AccountInfo.validateJsonObject(jsonObj);
                    return (AccountInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PaymentAccountIndicatorEnum {
        NOTAPPLICABLE("notApplicable"),
        THISTRANSACTION("thisTransaction"),
        LESSTHAN30DAYS("lessThan30Days"),
        FROM30TO60DAYS("from30To60Days"),
        MORETHAN60DAYS("moreThan60Days");

        private String value;

        private PaymentAccountIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PaymentAccountIndicatorEnum fromValue(String value) {
            for (PaymentAccountIndicatorEnum b : PaymentAccountIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PaymentAccountIndicatorEnum> {
            public void write(JsonWriter jsonWriter, PaymentAccountIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PaymentAccountIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PaymentAccountIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PasswordChangeIndicatorEnum {
        NOTAPPLICABLE("notApplicable"),
        THISTRANSACTION("thisTransaction"),
        LESSTHAN30DAYS("lessThan30Days"),
        FROM30TO60DAYS("from30To60Days"),
        MORETHAN60DAYS("moreThan60Days");

        private String value;

        private PasswordChangeIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PasswordChangeIndicatorEnum fromValue(String value) {
            for (PasswordChangeIndicatorEnum b : PasswordChangeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PasswordChangeIndicatorEnum> {
            public void write(JsonWriter jsonWriter, PasswordChangeIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PasswordChangeIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PasswordChangeIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryAddressUsageIndicatorEnum {
        THISTRANSACTION("thisTransaction"),
        LESSTHAN30DAYS("lessThan30Days"),
        FROM30TO60DAYS("from30To60Days"),
        MORETHAN60DAYS("moreThan60Days");

        private String value;

        private DeliveryAddressUsageIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryAddressUsageIndicatorEnum fromValue(String value) {
            for (DeliveryAddressUsageIndicatorEnum b : DeliveryAddressUsageIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DeliveryAddressUsageIndicatorEnum> {
            public void write(JsonWriter jsonWriter, DeliveryAddressUsageIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryAddressUsageIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryAddressUsageIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountTypeEnum {
        NOTAPPLICABLE("notApplicable"),
        CREDIT("credit"),
        DEBIT("debit");

        private String value;

        private AccountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountTypeEnum fromValue(String value) {
            for (AccountTypeEnum b : AccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountTypeEnum> {
            public void write(JsonWriter jsonWriter, AccountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountChangeIndicatorEnum {
        THISTRANSACTION("thisTransaction"),
        LESSTHAN30DAYS("lessThan30Days"),
        FROM30TO60DAYS("from30To60Days"),
        MORETHAN60DAYS("moreThan60Days");

        private String value;

        private AccountChangeIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountChangeIndicatorEnum fromValue(String value) {
            for (AccountChangeIndicatorEnum b : AccountChangeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountChangeIndicatorEnum> {
            public void write(JsonWriter jsonWriter, AccountChangeIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountChangeIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountChangeIndicatorEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountAgeIndicatorEnum {
        NOTAPPLICABLE("notApplicable"),
        THISTRANSACTION("thisTransaction"),
        LESSTHAN30DAYS("lessThan30Days"),
        FROM30TO60DAYS("from30To60Days"),
        MORETHAN60DAYS("moreThan60Days");

        private String value;

        private AccountAgeIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountAgeIndicatorEnum fromValue(String value) {
            for (AccountAgeIndicatorEnum b : AccountAgeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountAgeIndicatorEnum> {
            public void write(JsonWriter jsonWriter, AccountAgeIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountAgeIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountAgeIndicatorEnum.fromValue(value);
            }
        }
    }
}

