/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalSettings;
import com.adyen.model.management.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CreateMerchantWebhookRequest {
    public static final String SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE = "acceptsExpiredCertificate";
    @SerializedName(value="acceptsExpiredCertificate")
    private Boolean acceptsExpiredCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE = "acceptsSelfSignedCertificate";
    @SerializedName(value="acceptsSelfSignedCertificate")
    private Boolean acceptsSelfSignedCertificate;
    public static final String SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE = "acceptsUntrustedRootCertificate";
    @SerializedName(value="acceptsUntrustedRootCertificate")
    private Boolean acceptsUntrustedRootCertificate;
    public static final String SERIALIZED_NAME_ACTIVE = "active";
    @SerializedName(value="active")
    private Boolean active;
    public static final String SERIALIZED_NAME_ADDITIONAL_SETTINGS = "additionalSettings";
    @SerializedName(value="additionalSettings")
    private AdditionalSettings additionalSettings;
    public static final String SERIALIZED_NAME_COMMUNICATION_FORMAT = "communicationFormat";
    @SerializedName(value="communicationFormat")
    private CommunicationFormatEnum communicationFormat;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_NETWORK_TYPE = "networkType";
    @SerializedName(value="networkType")
    private NetworkTypeEnum networkType;
    public static final String SERIALIZED_NAME_PASSWORD = "password";
    @SerializedName(value="password")
    private String password;
    public static final String SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER = "populateSoapActionHeader";
    @SerializedName(value="populateSoapActionHeader")
    private Boolean populateSoapActionHeader;
    public static final String SERIALIZED_NAME_SSL_VERSION = "sslVersion";
    @SerializedName(value="sslVersion")
    private SslVersionEnum sslVersion;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateMerchantWebhookRequest acceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if expired SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsExpiredCertificate() {
        return this.acceptsExpiredCertificate;
    }

    public void setAcceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
    }

    public CreateMerchantWebhookRequest acceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if self-signed SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsSelfSignedCertificate() {
        return this.acceptsSelfSignedCertificate;
    }

    public void setAcceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
    }

    public CreateMerchantWebhookRequest acceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if untrusted SSL certificates are accepted. Default value: **false**.")
    public Boolean getAcceptsUntrustedRootCertificate() {
        return this.acceptsUntrustedRootCertificate;
    }

    public void setAcceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
    }

    public CreateMerchantWebhookRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the webhook configuration is active. The field must be **true** for us to send webhooks about events related an account.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public CreateMerchantWebhookRequest additionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public AdditionalSettings getAdditionalSettings() {
        return this.additionalSettings;
    }

    public void setAdditionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public CreateMerchantWebhookRequest communicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
        return this;
    }

    @ApiModelProperty(example="SOAP", required=true, value="Format or protocol for receiving webhooks. Possible values: * **soap** * **http** * **json** ")
    public CommunicationFormatEnum getCommunicationFormat() {
        return this.communicationFormat;
    }

    public void setCommunicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
    }

    public CreateMerchantWebhookRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for this webhook configuration.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateMerchantWebhookRequest networkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
        return this;
    }

    @ApiModelProperty(value="Network type for Terminal API notification webhooks. Possible values: * **public** * **local**  Default Value: **public**.")
    public NetworkTypeEnum getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
    }

    public CreateMerchantWebhookRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Password to access the webhook URL.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CreateMerchantWebhookRequest populateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
        return this;
    }

    @ApiModelProperty(value="Indicates if the SOAP action header needs to be populated. Default value: **false**.  Only applies if `communicationFormat`: **soap**.")
    public Boolean getPopulateSoapActionHeader() {
        return this.populateSoapActionHeader;
    }

    public void setPopulateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
    }

    public CreateMerchantWebhookRequest sslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
        return this;
    }

    @ApiModelProperty(example="TLSv1.2", value="SSL version to access the public webhook URL specified in the `url` field. Possible values: * **TLSv1.3** * **TLSv1.2** * **HTTP** - Only allowed on Test environment.  If not specified, the webhook will use `sslVersion`: **TLSv1.2**.")
    public SslVersionEnum getSslVersion() {
        return this.sslVersion;
    }

    public void setSslVersion(SslVersionEnum sslVersion) {
        this.sslVersion = sslVersion;
    }

    public CreateMerchantWebhookRequest type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of webhook that is being created. Possible values are:  - **standard** - **account-settings-notification** - **banktransfer-notification** - **boletobancario-notification** - **directdebit-notification** - **pending-notification** - **ideal-notification** - **ideal-pending-notification** - **report-notification** - **rreq-notification**  Find out more about [standard notification webhooks](https://docs.adyen.com/development-resources/webhooks/understand-notifications#event-codes) and [other types of notifications](https://docs.adyen.com/development-resources/webhooks/understand-notifications#other-notifications).")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public CreateMerchantWebhookRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://www.adyen.com", required=true, value="Public URL where webhooks will be sent, for example **https://www.domain.com/webhook-endpoint**.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CreateMerchantWebhookRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="Username to access the webhook URL.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMerchantWebhookRequest createMerchantWebhookRequest = (CreateMerchantWebhookRequest)o;
        return Objects.equals(this.acceptsExpiredCertificate, createMerchantWebhookRequest.acceptsExpiredCertificate) && Objects.equals(this.acceptsSelfSignedCertificate, createMerchantWebhookRequest.acceptsSelfSignedCertificate) && Objects.equals(this.acceptsUntrustedRootCertificate, createMerchantWebhookRequest.acceptsUntrustedRootCertificate) && Objects.equals(this.active, createMerchantWebhookRequest.active) && Objects.equals(this.additionalSettings, createMerchantWebhookRequest.additionalSettings) && Objects.equals((Object)this.communicationFormat, (Object)createMerchantWebhookRequest.communicationFormat) && Objects.equals(this.description, createMerchantWebhookRequest.description) && Objects.equals((Object)this.networkType, (Object)createMerchantWebhookRequest.networkType) && Objects.equals(this.password, createMerchantWebhookRequest.password) && Objects.equals(this.populateSoapActionHeader, createMerchantWebhookRequest.populateSoapActionHeader) && Objects.equals((Object)this.sslVersion, (Object)createMerchantWebhookRequest.sslVersion) && Objects.equals(this.type, createMerchantWebhookRequest.type) && Objects.equals(this.url, createMerchantWebhookRequest.url) && Objects.equals(this.username, createMerchantWebhookRequest.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptsExpiredCertificate, this.acceptsSelfSignedCertificate, this.acceptsUntrustedRootCertificate, this.active, this.additionalSettings, this.communicationFormat, this.description, this.networkType, this.password, this.populateSoapActionHeader, this.sslVersion, this.type, this.url, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMerchantWebhookRequest {\n");
        sb.append("    acceptsExpiredCertificate: ").append(this.toIndentedString(this.acceptsExpiredCertificate)).append("\n");
        sb.append("    acceptsSelfSignedCertificate: ").append(this.toIndentedString(this.acceptsSelfSignedCertificate)).append("\n");
        sb.append("    acceptsUntrustedRootCertificate: ").append(this.toIndentedString(this.acceptsUntrustedRootCertificate)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    communicationFormat: ").append(this.toIndentedString((Object)this.communicationFormat)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    networkType: ").append(this.toIndentedString((Object)this.networkType)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    populateSoapActionHeader: ").append(this.toIndentedString(this.populateSoapActionHeader)).append("\n");
        sb.append("    sslVersion: ").append(this.toIndentedString((Object)this.sslVersion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CreateMerchantWebhookRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CreateMerchantWebhookRequest` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS) != null) {
            AdditionalSettings.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ADDITIONAL_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `communicationFormat` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).toString()));
            }
            CommunicationFormatEnum.fromValue(jsonObj.get(SERIALIZED_NAME_COMMUNICATION_FORMAT).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `networkType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).toString()));
            }
            NetworkTypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_NETWORK_TYPE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_PASSWORD) != null && !jsonObj.get(SERIALIZED_NAME_PASSWORD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `password` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PASSWORD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SSL_VERSION) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SSL_VERSION).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `sslVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SSL_VERSION).toString()));
            }
            SslVersionEnum.fromValue(jsonObj.get(SERIALIZED_NAME_SSL_VERSION).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_USERNAME) != null && !jsonObj.get(SERIALIZED_NAME_USERNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `username` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_USERNAME).toString()));
        }
    }

    public static CreateMerchantWebhookRequest fromJson(String jsonString) throws IOException {
        return (CreateMerchantWebhookRequest)JSON.getGson().fromJson(jsonString, CreateMerchantWebhookRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_EXPIRED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_SELF_SIGNED_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE);
        openapiFields.add(SERIALIZED_NAME_ACTIVE);
        openapiFields.add(SERIALIZED_NAME_ADDITIONAL_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_COMMUNICATION_FORMAT);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_NETWORK_TYPE);
        openapiFields.add(SERIALIZED_NAME_PASSWORD);
        openapiFields.add(SERIALIZED_NAME_POPULATE_SOAP_ACTION_HEADER);
        openapiFields.add(SERIALIZED_NAME_SSL_VERSION);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVE);
        openapiRequiredFields.add(SERIALIZED_NAME_COMMUNICATION_FORMAT);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_URL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateMerchantWebhookRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateMerchantWebhookRequest.class));
            return new TypeAdapter<CreateMerchantWebhookRequest>(){

                public void write(JsonWriter out, CreateMerchantWebhookRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateMerchantWebhookRequest read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateMerchantWebhookRequest.validateJsonObject(jsonObj);
                    return (CreateMerchantWebhookRequest)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SslVersionEnum {
        HTTP("HTTP"),
        SSL("SSL"),
        SSLV3("SSLV3"),
        SSL_INSECURE_CIPHERS("SSL_INSECURE_CIPHERS"),
        TLS("TLS"),
        TLSV1("TLSV1"),
        TLSV1_1("TLSV1_1"),
        TLSV1_2("TLSV1_2"),
        TLSV1_3("TLSV1_3"),
        TLSV1_INSECURE_CIPHERS("TLSV1_INSECURE_CIPHERS");

        private String value;

        private SslVersionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SslVersionEnum fromValue(String value) {
            for (SslVersionEnum b : SslVersionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SslVersionEnum> {
            public void write(JsonWriter jsonWriter, SslVersionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SslVersionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SslVersionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum NetworkTypeEnum {
        LOCAL("LOCAL"),
        PUBLIC("PUBLIC");

        private String value;

        private NetworkTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static NetworkTypeEnum fromValue(String value) {
            for (NetworkTypeEnum b : NetworkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<NetworkTypeEnum> {
            public void write(JsonWriter jsonWriter, NetworkTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public NetworkTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return NetworkTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CommunicationFormatEnum {
        HTTP("HTTP"),
        JSON("JSON"),
        SOAP("SOAP");

        private String value;

        private CommunicationFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CommunicationFormatEnum fromValue(String value) {
            for (CommunicationFormatEnum b : CommunicationFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CommunicationFormatEnum> {
            public void write(JsonWriter jsonWriter, CommunicationFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CommunicationFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CommunicationFormatEnum.fromValue(value);
            }
        }
    }
}

