/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CardDetails {
    public static final String SERIALIZED_NAME_BRAND = "brand";
    @SerializedName(value="brand")
    private String brand;
    public static final String SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID = "checkoutAttemptId";
    @SerializedName(value="checkoutAttemptId")
    private String checkoutAttemptId;
    public static final String SERIALIZED_NAME_CUPSECUREPLUS_SMSCODE = "cupsecureplus.smscode";
    @SerializedName(value="cupsecureplus.smscode")
    private String cupsecureplusSmscode;
    public static final String SERIALIZED_NAME_CVC = "cvc";
    @SerializedName(value="cvc")
    private String cvc;
    public static final String SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER = "encryptedCardNumber";
    @SerializedName(value="encryptedCardNumber")
    private String encryptedCardNumber;
    public static final String SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH = "encryptedExpiryMonth";
    @SerializedName(value="encryptedExpiryMonth")
    private String encryptedExpiryMonth;
    public static final String SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR = "encryptedExpiryYear";
    @SerializedName(value="encryptedExpiryYear")
    private String encryptedExpiryYear;
    public static final String SERIALIZED_NAME_ENCRYPTED_SECURITY_CODE = "encryptedSecurityCode";
    @SerializedName(value="encryptedSecurityCode")
    private String encryptedSecurityCode;
    public static final String SERIALIZED_NAME_EXPIRY_MONTH = "expiryMonth";
    @SerializedName(value="expiryMonth")
    private String expiryMonth;
    public static final String SERIALIZED_NAME_EXPIRY_YEAR = "expiryYear";
    @SerializedName(value="expiryYear")
    private String expiryYear;
    public static final String SERIALIZED_NAME_FUNDING_SOURCE = "fundingSource";
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource;
    public static final String SERIALIZED_NAME_HOLDER_NAME = "holderName";
    @SerializedName(value="holderName")
    private String holderName;
    public static final String SERIALIZED_NAME_NETWORK_PAYMENT_REFERENCE = "networkPaymentReference";
    @SerializedName(value="networkPaymentReference")
    private String networkPaymentReference;
    public static final String SERIALIZED_NAME_NUMBER = "number";
    @SerializedName(value="number")
    private String number;
    public static final String SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE = "recurringDetailReference";
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference;
    public static final String SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE = "shopperNotificationReference";
    @SerializedName(value="shopperNotificationReference")
    private String shopperNotificationReference;
    public static final String SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID = "storedPaymentMethodId";
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId;
    public static final String SERIALIZED_NAME_THREE_D_S2_SDK_VERSION = "threeDS2SdkVersion";
    @SerializedName(value="threeDS2SdkVersion")
    private String threeDS2SdkVersion;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.SCHEME;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CardDetails brand(String brand) {
        this.brand = brand;
        return this;
    }

    @ApiModelProperty(value="Secondary brand of the card. For example: **plastix**, **hmclub**.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public CardDetails checkoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
        return this;
    }

    @ApiModelProperty(value="The checkout attempt identifier.")
    public String getCheckoutAttemptId() {
        return this.checkoutAttemptId;
    }

    public void setCheckoutAttemptId(String checkoutAttemptId) {
        this.checkoutAttemptId = checkoutAttemptId;
    }

    public CardDetails cupsecureplusSmscode(String cupsecureplusSmscode) {
        this.cupsecureplusSmscode = cupsecureplusSmscode;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="")
    public String getCupsecureplusSmscode() {
        return this.cupsecureplusSmscode;
    }

    public void setCupsecureplusSmscode(String cupsecureplusSmscode) {
        this.cupsecureplusSmscode = cupsecureplusSmscode;
    }

    public CardDetails cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @ApiModelProperty(value="The card verification code. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getCvc() {
        return this.cvc;
    }

    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public CardDetails encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted card number.")
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CardDetails encryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted card expiry month.")
    public String getEncryptedExpiryMonth() {
        return this.encryptedExpiryMonth;
    }

    public void setEncryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
    }

    public CardDetails encryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
        return this;
    }

    @ApiModelProperty(required=true, value="The encrypted card expiry year.")
    public String getEncryptedExpiryYear() {
        return this.encryptedExpiryYear;
    }

    public void setEncryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
    }

    public CardDetails encryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
        return this;
    }

    @ApiModelProperty(value="The encrypted card verification code.")
    public String getEncryptedSecurityCode() {
        return this.encryptedSecurityCode;
    }

    public void setEncryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
    }

    public CardDetails expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @ApiModelProperty(value="The card expiry month. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CardDetails expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @ApiModelProperty(value="The card expiry year. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public CardDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @ApiModelProperty(value="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public CardDetails holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @ApiModelProperty(value="The name of the card holder.")
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public CardDetails networkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
        return this;
    }

    @ApiModelProperty(value="The network token reference. This is the [`networkTxReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference) from the response to the first payment.")
    public String getNetworkPaymentReference() {
        return this.networkPaymentReference;
    }

    public void setNetworkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
    }

    public CardDetails number(String number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The card number. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public CardDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Deprecated
    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public CardDetails shopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
        return this;
    }

    @ApiModelProperty(value="The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used only for recurring payments in India.")
    public String getShopperNotificationReference() {
        return this.shopperNotificationReference;
    }

    public void setShopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
    }

    public CardDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @ApiModelProperty(value="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public CardDetails threeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
        return this;
    }

    @ApiModelProperty(value="Version of the 3D Secure 2 mobile SDK.")
    public String getThreeDS2SdkVersion() {
        return this.threeDS2SdkVersion;
    }

    public void setThreeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
    }

    public CardDetails type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Default payment method details. Common for scheme payment methods, and for simple payment method details.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardDetails cardDetails = (CardDetails)o;
        return Objects.equals(this.brand, cardDetails.brand) && Objects.equals(this.checkoutAttemptId, cardDetails.checkoutAttemptId) && Objects.equals(this.cupsecureplusSmscode, cardDetails.cupsecureplusSmscode) && Objects.equals(this.cvc, cardDetails.cvc) && Objects.equals(this.encryptedCardNumber, cardDetails.encryptedCardNumber) && Objects.equals(this.encryptedExpiryMonth, cardDetails.encryptedExpiryMonth) && Objects.equals(this.encryptedExpiryYear, cardDetails.encryptedExpiryYear) && Objects.equals(this.encryptedSecurityCode, cardDetails.encryptedSecurityCode) && Objects.equals(this.expiryMonth, cardDetails.expiryMonth) && Objects.equals(this.expiryYear, cardDetails.expiryYear) && Objects.equals((Object)this.fundingSource, (Object)cardDetails.fundingSource) && Objects.equals(this.holderName, cardDetails.holderName) && Objects.equals(this.networkPaymentReference, cardDetails.networkPaymentReference) && Objects.equals(this.number, cardDetails.number) && Objects.equals(this.recurringDetailReference, cardDetails.recurringDetailReference) && Objects.equals(this.shopperNotificationReference, cardDetails.shopperNotificationReference) && Objects.equals(this.storedPaymentMethodId, cardDetails.storedPaymentMethodId) && Objects.equals(this.threeDS2SdkVersion, cardDetails.threeDS2SdkVersion) && Objects.equals((Object)this.type, (Object)cardDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.checkoutAttemptId, this.cupsecureplusSmscode, this.cvc, this.encryptedCardNumber, this.encryptedExpiryMonth, this.encryptedExpiryYear, this.encryptedSecurityCode, this.expiryMonth, this.expiryYear, this.fundingSource, this.holderName, this.networkPaymentReference, this.number, this.recurringDetailReference, this.shopperNotificationReference, this.storedPaymentMethodId, this.threeDS2SdkVersion, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardDetails {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    checkoutAttemptId: ").append(this.toIndentedString(this.checkoutAttemptId)).append("\n");
        sb.append("    cupsecureplusSmscode: ").append(this.toIndentedString(this.cupsecureplusSmscode)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    encryptedExpiryMonth: ").append(this.toIndentedString(this.encryptedExpiryMonth)).append("\n");
        sb.append("    encryptedExpiryYear: ").append(this.toIndentedString(this.encryptedExpiryYear)).append("\n");
        sb.append("    encryptedSecurityCode: ").append(this.toIndentedString(this.encryptedSecurityCode)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    networkPaymentReference: ").append(this.toIndentedString(this.networkPaymentReference)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperNotificationReference: ").append(this.toIndentedString(this.shopperNotificationReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    threeDS2SdkVersion: ").append(this.toIndentedString(this.threeDS2SdkVersion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in CardDetails is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CardDetails` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BRAND) != null && !jsonObj.get(SERIALIZED_NAME_BRAND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `brand` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BRAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID) != null && !jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `checkoutAttemptId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUPSECUREPLUS_SMSCODE) != null && !jsonObj.get(SERIALIZED_NAME_CUPSECUREPLUS_SMSCODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cupsecureplus.smscode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUPSECUREPLUS_SMSCODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CVC) != null && !jsonObj.get(SERIALIZED_NAME_CVC).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cvc` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CVC).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedCardNumber` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedExpiryMonth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedExpiryYear` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENCRYPTED_SECURITY_CODE) != null && !jsonObj.get(SERIALIZED_NAME_ENCRYPTED_SECURITY_CODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `encryptedSecurityCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENCRYPTED_SECURITY_CODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryMonth` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_MONTH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR) != null && !jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `expiryYear` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPIRY_YEAR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `fundingSource` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).toString()));
            }
            FundingSourceEnum.fromValue(jsonObj.get(SERIALIZED_NAME_FUNDING_SOURCE).getAsString());
        }
        if (jsonObj.get(SERIALIZED_NAME_HOLDER_NAME) != null && !jsonObj.get(SERIALIZED_NAME_HOLDER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `holderName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOLDER_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_PAYMENT_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_PAYMENT_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `networkPaymentReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORK_PAYMENT_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NUMBER) != null && !jsonObj.get(SERIALIZED_NAME_NUMBER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `number` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NUMBER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recurringDetailReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shopperNotificationReference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID) != null && !jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `storedPaymentMethodId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_THREE_D_S2_SDK_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_THREE_D_S2_SDK_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `threeDS2SdkVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_THREE_D_S2_SDK_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TYPE) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
                throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
            }
            TypeEnum.fromValue(jsonObj.get(SERIALIZED_NAME_TYPE).getAsString());
        }
    }

    public static CardDetails fromJson(String jsonString) throws IOException {
        return (CardDetails)JSON.getGson().fromJson(jsonString, CardDetails.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BRAND);
        openapiFields.add(SERIALIZED_NAME_CHECKOUT_ATTEMPT_ID);
        openapiFields.add(SERIALIZED_NAME_CUPSECUREPLUS_SMSCODE);
        openapiFields.add(SERIALIZED_NAME_CVC);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR);
        openapiFields.add(SERIALIZED_NAME_ENCRYPTED_SECURITY_CODE);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_MONTH);
        openapiFields.add(SERIALIZED_NAME_EXPIRY_YEAR);
        openapiFields.add(SERIALIZED_NAME_FUNDING_SOURCE);
        openapiFields.add(SERIALIZED_NAME_HOLDER_NAME);
        openapiFields.add(SERIALIZED_NAME_NETWORK_PAYMENT_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_NUMBER);
        openapiFields.add(SERIALIZED_NAME_RECURRING_DETAIL_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_SHOPPER_NOTIFICATION_REFERENCE);
        openapiFields.add(SERIALIZED_NAME_STORED_PAYMENT_METHOD_ID);
        openapiFields.add(SERIALIZED_NAME_THREE_D_S2_SDK_VERSION);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENCRYPTED_CARD_NUMBER);
        openapiRequiredFields.add(SERIALIZED_NAME_ENCRYPTED_EXPIRY_MONTH);
        openapiRequiredFields.add(SERIALIZED_NAME_ENCRYPTED_EXPIRY_YEAR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CardDetails.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CardDetails.class));
            return new TypeAdapter<CardDetails>(){

                public void write(JsonWriter out, CardDetails value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CardDetails read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CardDetails.validateJsonObject(jsonObj);
                    return (CardDetails)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        SCHEME("scheme"),
        NETWORKTOKEN("networkToken"),
        GIFTCARD("giftcard"),
        ALLIANCEDATA("alliancedata"),
        CARD("card");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

