/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.Address;
import com.adyen.model.Amount;
import com.adyen.model.Name;
import com.adyen.model.Split;
import com.adyen.model.applicationinfo.ApplicationInfo;
import com.adyen.model.checkout.InstallmentOption;
import com.adyen.model.checkout.LineItem;
import com.adyen.model.checkout.RiskData;
import com.adyen.serializer.DateTimeISO8601Serializer;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreatePaymentLinkRequest {
    @SerializedName(value="allowedPaymentMethods")
    private List<String> allowedPaymentMethods = null;
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="applicationInfo")
    private ApplicationInfo applicationInfo = null;
    @SerializedName(value="billingAddress")
    private Address billingAddress = null;
    @SerializedName(value="blockedPaymentMethods")
    private List<String> blockedPaymentMethods = null;
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours = null;
    @SerializedName(value="countryCode")
    private String countryCode = null;
    @SerializedName(value="dateOfBirth")
    @JsonAdapter(value=DateTimeISO8601Serializer.class)
    private Date dateOfBirth = null;
    @SerializedName(value="deliverAt")
    @JsonAdapter(value=DateTimeISO8601Serializer.class)
    private Date deliverAt = null;
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="expiresAt")
    private String expiresAt = null;
    @SerializedName(value="installmentOptions")
    private Map<String, InstallmentOption> installmentOptions = null;
    @SerializedName(value="lineItems")
    private List<LineItem> lineItems = null;
    @SerializedName(value="mcc")
    private String mcc = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference = null;
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    @SerializedName(value="recurringProcessingModel")
    private RecurringProcessingModelEnum recurringProcessingModel = null;
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="requiredShopperFields")
    private List<RequiredShopperFieldsEnum> requiredShopperFields = null;
    @SerializedName(value="returnUrl")
    private String returnUrl = null;
    @SerializedName(value="reusable")
    private Boolean reusable = null;
    @SerializedName(value="riskData")
    private RiskData riskData = null;
    @SerializedName(value="shopperEmail")
    private String shopperEmail = null;
    @SerializedName(value="shopperLocale")
    private String shopperLocale = null;
    @SerializedName(value="shopperName")
    private Name shopperName = null;
    @SerializedName(value="shopperReference")
    private String shopperReference = null;
    @SerializedName(value="shopperStatement")
    private String shopperStatement = null;
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber = null;
    @SerializedName(value="splitCardFundingSources")
    private Boolean splitCardFundingSources = false;
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="store")
    private String store = null;
    @SerializedName(value="storePaymentMethodMode")
    private StorePaymentMethodModeEnum storePaymentMethodMode = null;
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber = null;
    @SerializedName(value="themeId")
    private String themeId = null;

    public CreatePaymentLinkRequest allowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
        return this;
    }

    public CreatePaymentLinkRequest addAllowedPaymentMethodsItem(String allowedPaymentMethodsItem) {
        if (this.allowedPaymentMethods == null) {
            this.allowedPaymentMethods = new ArrayList<String>();
        }
        this.allowedPaymentMethods.add(allowedPaymentMethodsItem);
        return this;
    }

    @Schema(description="List of payment methods to be presented to the shopper. To refer to payment methods, use their `paymentMethod.type` from [Payment methods overview](https://docs.adyen.com/payment-methods).  Example: `\"allowedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getAllowedPaymentMethods() {
        return this.allowedPaymentMethods;
    }

    public void setAllowedPaymentMethods(List<String> allowedPaymentMethods) {
        this.allowedPaymentMethods = allowedPaymentMethods;
    }

    public CreatePaymentLinkRequest amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @Schema(required=true, description="")
    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public CreatePaymentLinkRequest applicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
        return this;
    }

    @Schema(description="")
    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public void setApplicationInfo(ApplicationInfo applicationInfo) {
        this.applicationInfo = applicationInfo;
    }

    public CreatePaymentLinkRequest billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @Schema(description="")
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public CreatePaymentLinkRequest blockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
        return this;
    }

    public CreatePaymentLinkRequest addBlockedPaymentMethodsItem(String blockedPaymentMethodsItem) {
        if (this.blockedPaymentMethods == null) {
            this.blockedPaymentMethods = new ArrayList<String>();
        }
        this.blockedPaymentMethods.add(blockedPaymentMethodsItem);
        return this;
    }

    @Schema(description="List of payment methods to be hidden from the shopper. To refer to payment methods, use their `paymentMethod.type` from [Payment methods overview](https://docs.adyen.com/payment-methods).  Example: `\"blockedPaymentMethods\":[\"ideal\",\"giropay\"]`")
    public List<String> getBlockedPaymentMethods() {
        return this.blockedPaymentMethods;
    }

    public void setBlockedPaymentMethods(List<String> blockedPaymentMethods) {
        this.blockedPaymentMethods = blockedPaymentMethods;
    }

    public CreatePaymentLinkRequest captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return this;
    }

    @Schema(description="The delay between the authorisation and scheduled auto-capture, specified in hours.")
    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public CreatePaymentLinkRequest countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Schema(description="The shopper's two-letter country code.")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public CreatePaymentLinkRequest dateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    @Schema(description="The shopper's date of birth.  Format [ISO-8601](https://www.w3.org/TR/NOTE-datetime): YYYY-MM-DD")
    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public CreatePaymentLinkRequest deliverAt(Date deliverAt) {
        this.deliverAt = deliverAt;
        return this;
    }

    @Schema(description="The date and time when the purchased goods should be delivered.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
    public Date getDeliverAt() {
        return this.deliverAt;
    }

    public void setDeliverAt(Date deliverAt) {
        this.deliverAt = deliverAt;
    }

    public CreatePaymentLinkRequest deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return this;
    }

    @Schema(description="")
    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public CreatePaymentLinkRequest description(String description) {
        this.description = description;
        return this;
    }

    @Schema(description="A short description visible on the payment page. Maximum length: 280 characters.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreatePaymentLinkRequest expiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Schema(description="The date when the payment link expires.  [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.  The maximum expiry date is 70 days after the payment link is created.  If not provided, the payment link expires 24 hours after it was created.")
    public String getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(String expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreatePaymentLinkRequest installmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
        return this;
    }

    public CreatePaymentLinkRequest putInstallmentOptionsItem(String key, InstallmentOption installmentOptionsItem) {
        if (this.installmentOptions == null) {
            this.installmentOptions = new HashMap<String, InstallmentOption>();
        }
        this.installmentOptions.put(key, installmentOptionsItem);
        return this;
    }

    @Schema(description="A set of key-value pairs that specifies the installment options available per payment method. The key must be a payment method name in lowercase. For example, **card** to specify installment options for all cards, or **visa** or **mc**. The value must be an object containing the installment options.")
    public Map<String, InstallmentOption> getInstallmentOptions() {
        return this.installmentOptions;
    }

    public void setInstallmentOptions(Map<String, InstallmentOption> installmentOptions) {
        this.installmentOptions = installmentOptions;
    }

    public CreatePaymentLinkRequest lineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
        return this;
    }

    public CreatePaymentLinkRequest addLineItemsItem(LineItem lineItemsItem) {
        if (this.lineItems == null) {
            this.lineItems = new ArrayList<LineItem>();
        }
        this.lineItems.add(lineItemsItem);
        return this;
    }

    @Schema(description="Price and product information about the purchased items, to be included on the invoice sent to the shopper. This parameter is required for open invoice (_buy now, pay later_) payment methods such Afterpay, Clearpay, Klarna, RatePay, and Zip.")
    public List<LineItem> getLineItems() {
        return this.lineItems;
    }

    public void setLineItems(List<LineItem> lineItems) {
        this.lineItems = lineItems;
    }

    public CreatePaymentLinkRequest mcc(String mcc) {
        this.mcc = mcc;
        return this;
    }

    @Schema(description="The [merchant category code](https://en.wikipedia.org/wiki/Merchant_category_code) (MCC) is a four-digit number, which relates to a particular market segment. This code reflects the predominant activity that is conducted by the merchant.")
    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public CreatePaymentLinkRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @Schema(required=true, description="The merchant account identifier for which the payment link is created.")
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CreatePaymentLinkRequest merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return this;
    }

    @Schema(description="This reference allows linking multiple transactions to each other for reporting purposes (for example, order auth-rate). The reference should be unique per billing cycle.")
    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public CreatePaymentLinkRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public CreatePaymentLinkRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Schema(description="Metadata consists of entries, each of which includes a key and a value. Limitations: * Maximum 20 key-value pairs per request. Otherwise, error \"177\" occurs: \"Metadata size exceeds limit\" * Maximum 20 characters per key. Otherwise, error \"178\" occurs: \"Metadata key size exceeds limit\" * A key cannot have the name `checkout.linkId`. Any value that you provide with this key is going to be replaced by the real payment link ID.")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public CreatePaymentLinkRequest recurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
        return this;
    }

    @Schema(description="Defines a recurring payment type. Possible values: * **Subscription** \u2013 A transaction for a fixed or variable amount, which follows a fixed schedule. * **CardOnFile** \u2013 With a card-on-file (CoF) transaction, card details are stored to enable one-click or omnichannel journeys, or simply to streamline the checkout process. Any subscription not following a fixed schedule is also considered a card-on-file transaction. * **UnscheduledCardOnFile** \u2013 An unscheduled card-on-file (UCoF) transaction is a transaction that occurs on a non-fixed schedule and/or has variable amounts. For example, automatic top-ups when a cardholder's balance drops below a certain amount. ")
    public RecurringProcessingModelEnum getRecurringProcessingModel() {
        return this.recurringProcessingModel;
    }

    public void setRecurringProcessingModel(RecurringProcessingModelEnum recurringProcessingModel) {
        this.recurringProcessingModel = recurringProcessingModel;
    }

    public CreatePaymentLinkRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @Schema(required=true, description="A reference that is used to uniquely identify the payment in future communications about the payment status.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public CreatePaymentLinkRequest requiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
        return this;
    }

    public CreatePaymentLinkRequest addRequiredShopperFieldsItem(RequiredShopperFieldsEnum requiredShopperFieldsItem) {
        if (this.requiredShopperFields == null) {
            this.requiredShopperFields = new ArrayList<RequiredShopperFieldsEnum>();
        }
        this.requiredShopperFields.add(requiredShopperFieldsItem);
        return this;
    }

    @Schema(description="List of fields that the shopper has to provide on the payment page before completing the payment. For more information, refer to [Provide shopper information](https://docs.adyen.com/unified-commerce/pay-by-link/payment-links/api#shopper-information).  Possible values: * **billingAddress** \u2013 The address where to send the invoice. * **deliveryAddress** \u2013 The address where the purchased goods should be delivered. * **shopperEmail** \u2013 The shopper's email address. * **shopperName** \u2013 The shopper's full name. * **telephoneNumber** \u2013 The shopper's phone number. ")
    public List<RequiredShopperFieldsEnum> getRequiredShopperFields() {
        return this.requiredShopperFields;
    }

    public void setRequiredShopperFields(List<RequiredShopperFieldsEnum> requiredShopperFields) {
        this.requiredShopperFields = requiredShopperFields;
    }

    public CreatePaymentLinkRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @Schema(description="Website URL used for redirection after payment is completed. If provided, a **Continue** button will be shown on the payment page. If shoppers select the button, they are redirected to the specified URL.")
    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public CreatePaymentLinkRequest reusable(Boolean reusable) {
        this.reusable = reusable;
        return this;
    }

    @Schema(description="Indicates whether the payment link can be reused for multiple payments. If not provided, this defaults to **false** which means the link can be used for one successful payment only.")
    public Boolean isReusable() {
        return this.reusable;
    }

    public void setReusable(Boolean reusable) {
        this.reusable = reusable;
    }

    public CreatePaymentLinkRequest riskData(RiskData riskData) {
        this.riskData = riskData;
        return this;
    }

    @Schema(description="")
    public RiskData getRiskData() {
        return this.riskData;
    }

    public void setRiskData(RiskData riskData) {
        this.riskData = riskData;
    }

    public CreatePaymentLinkRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return this;
    }

    @Schema(description="The shopper's email address.")
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public CreatePaymentLinkRequest shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return this;
    }

    @Schema(description="The language to be used in the payment page, specified by a combination of a language and country code. For example, `en-US`.  For a list of shopper locales that Pay by Link supports, refer to [Language and localization](https://docs.adyen.com/online-payments/pay-by-link#language-and-localization).")
    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public CreatePaymentLinkRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return this;
    }

    @Schema(description="")
    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public CreatePaymentLinkRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return this;
    }

    @Schema(description="Your reference to uniquely identify this shopper, for example user ID or account ID. Minimum length: 3 characters. > Your reference must not include personally identifiable information (PII), for example name or email address.")
    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public CreatePaymentLinkRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return this;
    }

    @Schema(description="The text to be shown on the shopper's bank statement.  We recommend sending a maximum of 22 characters, otherwise banks might truncate the string.  Allowed characters: **a-z**, **A-Z**, **0-9**, spaces, and special characters **. , ' _ - ? + * /_**.")
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public CreatePaymentLinkRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return this;
    }

    @Schema(description="The shopper's social security number.")
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public CreatePaymentLinkRequest splitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
        return this;
    }

    @Schema(description="Boolean value indicating whether the card payment method should be split into separate debit and credit options.")
    public Boolean isSplitCardFundingSources() {
        return this.splitCardFundingSources;
    }

    public void setSplitCardFundingSources(Boolean splitCardFundingSources) {
        this.splitCardFundingSources = splitCardFundingSources;
    }

    public CreatePaymentLinkRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public CreatePaymentLinkRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @Schema(description="An array of objects specifying how the payment should be split between accounts when using Adyen for Platforms. For details, refer to [Providing split information](https://docs.adyen.com/platforms/processing-payments#providing-split-information).")
    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public CreatePaymentLinkRequest store(String store) {
        this.store = store;
        return this;
    }

    @Schema(description="The physical store, for which this payment is processed.")
    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public CreatePaymentLinkRequest storePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
        return this;
    }

    @Schema(description="Indicates if the details of the payment method will be stored for the shopper. Possible values: * **disabled** \u2013 No details will be stored (default). * **askForConsent** \u2013 If the `shopperReference` is provided, the UI lets the shopper choose if they want their payment details to be stored. * **enabled** \u2013 If the `shopperReference` is provided, the details will be stored without asking the shopper for consent.")
    public StorePaymentMethodModeEnum getStorePaymentMethodMode() {
        return this.storePaymentMethodMode;
    }

    public void setStorePaymentMethodMode(StorePaymentMethodModeEnum storePaymentMethodMode) {
        this.storePaymentMethodMode = storePaymentMethodMode;
    }

    public CreatePaymentLinkRequest telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return this;
    }

    @Schema(description="The shopper's telephone number.")
    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public CreatePaymentLinkRequest themeId(String themeId) {
        this.themeId = themeId;
        return this;
    }

    @Schema(description="A [theme](https://docs.adyen.com/unified-commerce/pay-by-link/api#themes) to customize the appearance of the payment page. If not specified, the payment page is rendered according to the theme set as default in your Customer Area.")
    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePaymentLinkRequest createPaymentLinkRequest = (CreatePaymentLinkRequest)o;
        return Objects.equals(this.allowedPaymentMethods, createPaymentLinkRequest.allowedPaymentMethods) && Objects.equals(this.amount, createPaymentLinkRequest.amount) && Objects.equals(this.applicationInfo, createPaymentLinkRequest.applicationInfo) && Objects.equals(this.billingAddress, createPaymentLinkRequest.billingAddress) && Objects.equals(this.blockedPaymentMethods, createPaymentLinkRequest.blockedPaymentMethods) && Objects.equals(this.captureDelayHours, createPaymentLinkRequest.captureDelayHours) && Objects.equals(this.countryCode, createPaymentLinkRequest.countryCode) && Objects.equals(this.dateOfBirth, createPaymentLinkRequest.dateOfBirth) && Objects.equals(this.deliverAt, createPaymentLinkRequest.deliverAt) && Objects.equals(this.deliveryAddress, createPaymentLinkRequest.deliveryAddress) && Objects.equals(this.description, createPaymentLinkRequest.description) && Objects.equals(this.expiresAt, createPaymentLinkRequest.expiresAt) && Objects.equals(this.installmentOptions, createPaymentLinkRequest.installmentOptions) && Objects.equals(this.lineItems, createPaymentLinkRequest.lineItems) && Objects.equals(this.mcc, createPaymentLinkRequest.mcc) && Objects.equals(this.merchantAccount, createPaymentLinkRequest.merchantAccount) && Objects.equals(this.merchantOrderReference, createPaymentLinkRequest.merchantOrderReference) && Objects.equals(this.metadata, createPaymentLinkRequest.metadata) && Objects.equals((Object)this.recurringProcessingModel, (Object)createPaymentLinkRequest.recurringProcessingModel) && Objects.equals(this.reference, createPaymentLinkRequest.reference) && Objects.equals(this.requiredShopperFields, createPaymentLinkRequest.requiredShopperFields) && Objects.equals(this.returnUrl, createPaymentLinkRequest.returnUrl) && Objects.equals(this.reusable, createPaymentLinkRequest.reusable) && Objects.equals(this.riskData, createPaymentLinkRequest.riskData) && Objects.equals(this.shopperEmail, createPaymentLinkRequest.shopperEmail) && Objects.equals(this.shopperLocale, createPaymentLinkRequest.shopperLocale) && Objects.equals(this.shopperName, createPaymentLinkRequest.shopperName) && Objects.equals(this.shopperReference, createPaymentLinkRequest.shopperReference) && Objects.equals(this.shopperStatement, createPaymentLinkRequest.shopperStatement) && Objects.equals(this.socialSecurityNumber, createPaymentLinkRequest.socialSecurityNumber) && Objects.equals(this.splitCardFundingSources, createPaymentLinkRequest.splitCardFundingSources) && Objects.equals(this.splits, createPaymentLinkRequest.splits) && Objects.equals(this.store, createPaymentLinkRequest.store) && Objects.equals((Object)this.storePaymentMethodMode, (Object)createPaymentLinkRequest.storePaymentMethodMode) && Objects.equals(this.telephoneNumber, createPaymentLinkRequest.telephoneNumber) && Objects.equals(this.themeId, createPaymentLinkRequest.themeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedPaymentMethods, this.amount, this.applicationInfo, this.billingAddress, this.blockedPaymentMethods, this.captureDelayHours, this.countryCode, this.dateOfBirth, this.deliverAt, this.deliveryAddress, this.description, this.expiresAt, this.installmentOptions, this.lineItems, this.mcc, this.merchantAccount, this.merchantOrderReference, this.metadata, this.recurringProcessingModel, this.reference, this.requiredShopperFields, this.returnUrl, this.reusable, this.riskData, this.shopperEmail, this.shopperLocale, this.shopperName, this.shopperReference, this.shopperStatement, this.socialSecurityNumber, this.splitCardFundingSources, this.splits, this.store, this.storePaymentMethodMode, this.telephoneNumber, this.themeId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreatePaymentLinkRequest {\n");
        sb.append("    allowedPaymentMethods: ").append(this.toIndentedString(this.allowedPaymentMethods)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    applicationInfo: ").append(this.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    blockedPaymentMethods: ").append(this.toIndentedString(this.blockedPaymentMethods)).append("\n");
        sb.append("    captureDelayHours: ").append(this.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    deliverAt: ").append(this.toIndentedString(this.deliverAt)).append("\n");
        sb.append("    deliveryAddress: ").append(this.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    installmentOptions: ").append(this.toIndentedString(this.installmentOptions)).append("\n");
        sb.append("    lineItems: ").append(this.toIndentedString(this.lineItems)).append("\n");
        sb.append("    mcc: ").append(this.toIndentedString(this.mcc)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    merchantOrderReference: ").append(this.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    recurringProcessingModel: ").append(this.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    requiredShopperFields: ").append(this.toIndentedString(this.requiredShopperFields)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("    reusable: ").append(this.toIndentedString(this.reusable)).append("\n");
        sb.append("    riskData: ").append(this.toIndentedString(this.riskData)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperLocale: ").append(this.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    splitCardFundingSources: ").append(this.toIndentedString(this.splitCardFundingSources)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    store: ").append(this.toIndentedString(this.store)).append("\n");
        sb.append("    storePaymentMethodMode: ").append(this.toIndentedString((Object)this.storePaymentMethodMode)).append("\n");
        sb.append("    telephoneNumber: ").append(this.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    themeId: ").append(this.toIndentedString(this.themeId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StorePaymentMethodModeEnum {
        ASKFORCONSENT("askForConsent"),
        DISABLED("disabled"),
        ENABLED("enabled");

        @JsonValue
        private final String value;

        private StorePaymentMethodModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StorePaymentMethodModeEnum fromValue(String input) {
            for (StorePaymentMethodModeEnum b : StorePaymentMethodModeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StorePaymentMethodModeEnum> {
            public void write(JsonWriter jsonWriter, StorePaymentMethodModeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StorePaymentMethodModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StorePaymentMethodModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RequiredShopperFieldsEnum {
        BILLINGADDRESS("billingAddress"),
        DELIVERYADDRESS("deliveryAddress"),
        SHOPPEREMAIL("shopperEmail"),
        SHOPPERNAME("shopperName"),
        TELEPHONENUMBER("telephoneNumber");

        @JsonValue
        private final String value;

        private RequiredShopperFieldsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RequiredShopperFieldsEnum fromValue(String input) {
            for (RequiredShopperFieldsEnum b : RequiredShopperFieldsEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RequiredShopperFieldsEnum> {
            public void write(JsonWriter jsonWriter, RequiredShopperFieldsEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RequiredShopperFieldsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RequiredShopperFieldsEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription"),
        UNSCHEDULEDCARDONFILE("UnscheduledCardOnFile");

        @JsonValue
        private final String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String input) {
            for (RecurringProcessingModelEnum b : RecurringProcessingModelEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(value);
            }
        }
    }
}

