/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout.details;

import com.adyen.model.checkout.PaymentMethodDetails;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class SamsungPayDetails
implements PaymentMethodDetails {
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference = null;
    @SerializedName(value="samsungPayToken")
    private String samsungPayToken = null;
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId = null;
    public static final String SAMSUNGPAY = "samsungpay";
    @SerializedName(value="type")
    private String type = "samsungpay";

    public SamsungPayDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @Schema(description="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public SamsungPayDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Schema(description="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public SamsungPayDetails samsungPayToken(String samsungPayToken) {
        this.samsungPayToken = samsungPayToken;
        return this;
    }

    @Schema(required=true, description="The payload you received from the Samsung Pay SDK response.")
    public String getSamsungPayToken() {
        return this.samsungPayToken;
    }

    public void setSamsungPayToken(String samsungPayToken) {
        this.samsungPayToken = samsungPayToken;
    }

    public SamsungPayDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @Schema(description="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public SamsungPayDetails type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="**samsungpay**")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamsungPayDetails samsungPayDetails = (SamsungPayDetails)o;
        return Objects.equals((Object)this.fundingSource, (Object)samsungPayDetails.fundingSource) && Objects.equals(this.recurringDetailReference, samsungPayDetails.recurringDetailReference) && Objects.equals(this.samsungPayToken, samsungPayDetails.samsungPayToken) && Objects.equals(this.storedPaymentMethodId, samsungPayDetails.storedPaymentMethodId) && Objects.equals(this.type, samsungPayDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fundingSource, this.recurringDetailReference, this.samsungPayToken, this.storedPaymentMethodId, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamsungPayDetails {\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    samsungPayToken: ").append(this.toIndentedString(this.samsungPayToken)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        @JsonValue
        private final String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String input) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

