/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout.details;

import com.adyen.model.checkout.PaymentMethodDetails;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

public class CardDetails
implements PaymentMethodDetails {
    public static final String SCHEME = "scheme";
    public static final String NETWORKTOKEN = "networkToken";
    public static final String GIFTCARD = "giftcard";
    public static final String ALLIANCEDATA = "alliancedata";
    public static final String CARD = "card";
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="cvc")
    private String cvc = null;
    @SerializedName(value="encryptedCardNumber")
    private String encryptedCardNumber = null;
    @SerializedName(value="encryptedExpiryMonth")
    private String encryptedExpiryMonth = null;
    @SerializedName(value="encryptedExpiryYear")
    private String encryptedExpiryYear = null;
    @SerializedName(value="encryptedSecurityCode")
    private String encryptedSecurityCode = null;
    @SerializedName(value="expiryMonth")
    private String expiryMonth = null;
    @SerializedName(value="expiryYear")
    private String expiryYear = null;
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="holderName")
    private String holderName = null;
    @SerializedName(value="networkPaymentReference")
    private String networkPaymentReference = null;
    @SerializedName(value="number")
    private String number = null;
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference = null;
    @SerializedName(value="shopperNotificationReference")
    private String shopperNotificationReference = null;
    @SerializedName(value="storedPaymentMethodId")
    private String storedPaymentMethodId = null;
    @SerializedName(value="threeDS2SdkVersion")
    private String threeDS2SdkVersion = null;
    @SerializedName(value="type")
    private String type = null;

    public CardDetails brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Schema(description="Secondary brand of the card. For example: **plastix**, **hmclub**.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public CardDetails cvc(String cvc) {
        this.cvc = cvc;
        return this;
    }

    @Schema(description="The card verification code. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getCvc() {
        return this.cvc;
    }

    public void setCvc(String cvc) {
        this.cvc = cvc;
    }

    public CardDetails encryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
        return this;
    }

    @Schema(required=true, description="The encrypted card number.")
    public String getEncryptedCardNumber() {
        return this.encryptedCardNumber;
    }

    public void setEncryptedCardNumber(String encryptedCardNumber) {
        this.encryptedCardNumber = encryptedCardNumber;
    }

    public CardDetails encryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
        return this;
    }

    @Schema(required=true, description="The encrypted card expiry month.")
    public String getEncryptedExpiryMonth() {
        return this.encryptedExpiryMonth;
    }

    public void setEncryptedExpiryMonth(String encryptedExpiryMonth) {
        this.encryptedExpiryMonth = encryptedExpiryMonth;
    }

    public CardDetails encryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
        return this;
    }

    @Schema(required=true, description="The encrypted card expiry year.")
    public String getEncryptedExpiryYear() {
        return this.encryptedExpiryYear;
    }

    public void setEncryptedExpiryYear(String encryptedExpiryYear) {
        this.encryptedExpiryYear = encryptedExpiryYear;
    }

    public CardDetails encryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
        return this;
    }

    @Schema(description="The encrypted card verification code.")
    public String getEncryptedSecurityCode() {
        return this.encryptedSecurityCode;
    }

    public void setEncryptedSecurityCode(String encryptedSecurityCode) {
        this.encryptedSecurityCode = encryptedSecurityCode;
    }

    public CardDetails expiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
        return this;
    }

    @Schema(description="The card expiry month. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getExpiryMonth() {
        return this.expiryMonth;
    }

    public void setExpiryMonth(String expiryMonth) {
        this.expiryMonth = expiryMonth;
    }

    public CardDetails expiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
        return this;
    }

    @Schema(description="The card expiry year. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getExpiryYear() {
        return this.expiryYear;
    }

    public void setExpiryYear(String expiryYear) {
        this.expiryYear = expiryYear;
    }

    public CardDetails fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @Schema(description="The funding source that should be used when multiple sources are available. For Brazilian combo cards, by default the funding source is credit. To use debit, set this value to **debit**.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public CardDetails holderName(String holderName) {
        this.holderName = holderName;
        return this;
    }

    @Schema(description="The name of the card holder.")
    public String getHolderName() {
        return this.holderName;
    }

    public void setHolderName(String holderName) {
        this.holderName = holderName;
    }

    public CardDetails networkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
        return this;
    }

    @Schema(description="The network token reference. This is the [`networkTxReference`](https://docs.adyen.com/api-explorer/#/CheckoutService/latest/post/payments__resParam_additionalData-ResponseAdditionalDataCommon-networkTxReference) from the response to the first payment.")
    public String getNetworkPaymentReference() {
        return this.networkPaymentReference;
    }

    public void setNetworkPaymentReference(String networkPaymentReference) {
        this.networkPaymentReference = networkPaymentReference;
    }

    public CardDetails number(String number) {
        this.number = number;
        return this;
    }

    @Schema(description="The card number. Only collect raw card data if you are [fully PCI compliant](https://docs.adyen.com/development-resources/pci-dss-compliance-guide).")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public CardDetails recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Schema(description="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public CardDetails shopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
        return this;
    }

    @Schema(description="The `shopperNotificationReference` returned in the response when you requested to notify the shopper. Used only for recurring payments in India.")
    public String getShopperNotificationReference() {
        return this.shopperNotificationReference;
    }

    public void setShopperNotificationReference(String shopperNotificationReference) {
        this.shopperNotificationReference = shopperNotificationReference;
    }

    public CardDetails storedPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
        return this;
    }

    @Schema(description="This is the `recurringDetailReference` returned in the response when you created the token.")
    public String getStoredPaymentMethodId() {
        return this.storedPaymentMethodId;
    }

    public void setStoredPaymentMethodId(String storedPaymentMethodId) {
        this.storedPaymentMethodId = storedPaymentMethodId;
    }

    public CardDetails threeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
        return this;
    }

    @Schema(description="Version of the 3D Secure 2 mobile SDK.")
    public String getThreeDS2SdkVersion() {
        return this.threeDS2SdkVersion;
    }

    public void setThreeDS2SdkVersion(String threeDS2SdkVersion) {
        this.threeDS2SdkVersion = threeDS2SdkVersion;
    }

    public CardDetails type(String type) {
        this.type = type;
        return this;
    }

    @Override
    @Schema(description="Default payment method details. Common for scheme payment methods, and for simple payment method details.")
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardDetails cardDetails = (CardDetails)o;
        return Objects.equals(this.brand, cardDetails.brand) && Objects.equals(this.cvc, cardDetails.cvc) && Objects.equals(this.encryptedCardNumber, cardDetails.encryptedCardNumber) && Objects.equals(this.encryptedExpiryMonth, cardDetails.encryptedExpiryMonth) && Objects.equals(this.encryptedExpiryYear, cardDetails.encryptedExpiryYear) && Objects.equals(this.encryptedSecurityCode, cardDetails.encryptedSecurityCode) && Objects.equals(this.expiryMonth, cardDetails.expiryMonth) && Objects.equals(this.expiryYear, cardDetails.expiryYear) && Objects.equals((Object)this.fundingSource, (Object)cardDetails.fundingSource) && Objects.equals(this.holderName, cardDetails.holderName) && Objects.equals(this.networkPaymentReference, cardDetails.networkPaymentReference) && Objects.equals(this.number, cardDetails.number) && Objects.equals(this.recurringDetailReference, cardDetails.recurringDetailReference) && Objects.equals(this.shopperNotificationReference, cardDetails.shopperNotificationReference) && Objects.equals(this.storedPaymentMethodId, cardDetails.storedPaymentMethodId) && Objects.equals(this.threeDS2SdkVersion, cardDetails.threeDS2SdkVersion) && Objects.equals(this.type, cardDetails.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.cvc, this.encryptedCardNumber, this.encryptedExpiryMonth, this.encryptedExpiryYear, this.encryptedSecurityCode, this.expiryMonth, this.expiryYear, this.fundingSource, this.holderName, this.networkPaymentReference, this.number, this.recurringDetailReference, this.shopperNotificationReference, this.storedPaymentMethodId, this.threeDS2SdkVersion, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardDetails {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    cvc: ").append(this.toIndentedString(this.cvc)).append("\n");
        sb.append("    encryptedCardNumber: ").append(this.toIndentedString(this.encryptedCardNumber)).append("\n");
        sb.append("    encryptedExpiryMonth: ").append(this.toIndentedString(this.encryptedExpiryMonth)).append("\n");
        sb.append("    encryptedExpiryYear: ").append(this.toIndentedString(this.encryptedExpiryYear)).append("\n");
        sb.append("    encryptedSecurityCode: ").append(this.toIndentedString(this.encryptedSecurityCode)).append("\n");
        sb.append("    expiryMonth: ").append(this.toIndentedString(this.expiryMonth)).append("\n");
        sb.append("    expiryYear: ").append(this.toIndentedString(this.expiryYear)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    holderName: ").append(this.toIndentedString(this.holderName)).append("\n");
        sb.append("    networkPaymentReference: ").append(this.toIndentedString(this.networkPaymentReference)).append("\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    shopperNotificationReference: ").append(this.toIndentedString(this.shopperNotificationReference)).append("\n");
        sb.append("    storedPaymentMethodId: ").append(this.toIndentedString(this.storedPaymentMethodId)).append("\n");
        sb.append("    threeDS2SdkVersion: ").append(this.toIndentedString(this.threeDS2SdkVersion)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        @JsonValue
        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String input) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

