/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.InputDetail;
import com.adyen.model.checkout.PaymentMethodGroup;
import com.adyen.model.checkout.PaymentMethodIssuer;
import com.adyen.model.checkout.StoredDetails;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RecurringDetail {
    @SerializedName(value="brand")
    private String brand = null;
    @SerializedName(value="brands")
    private List<String> brands = null;
    @SerializedName(value="configuration")
    private Map<String, String> configuration = null;
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="group")
    private PaymentMethodGroup group = null;
    @SerializedName(value="inputDetails")
    private List<InputDetail> inputDetails = null;
    @SerializedName(value="issuers")
    private List<PaymentMethodIssuer> issuers = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="recurringDetailReference")
    private String recurringDetailReference = null;
    @SerializedName(value="storedDetails")
    private StoredDetails storedDetails = null;
    @SerializedName(value="type")
    private String type = null;

    public RecurringDetail brand(String brand) {
        this.brand = brand;
        return this;
    }

    @Schema(description="Brand for the selected gift card. For example: plastix, hmclub.")
    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public RecurringDetail brands(List<String> brands) {
        this.brands = brands;
        return this;
    }

    public RecurringDetail addBrandsItem(String brandsItem) {
        if (this.brands == null) {
            this.brands = new ArrayList<String>();
        }
        this.brands.add(brandsItem);
        return this;
    }

    @Schema(description="List of possible brands. For example: visa, mc.")
    public List<String> getBrands() {
        return this.brands;
    }

    public void setBrands(List<String> brands) {
        this.brands = brands;
    }

    public RecurringDetail configuration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public RecurringDetail putConfigurationItem(String key, String configurationItem) {
        if (this.configuration == null) {
            this.configuration = new HashMap<String, String>();
        }
        this.configuration.put(key, configurationItem);
        return this;
    }

    @Schema(description="The configuration of the payment method.")
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public RecurringDetail fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return this;
    }

    @Schema(description="The funding source of the payment method.")
    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public RecurringDetail group(PaymentMethodGroup group) {
        this.group = group;
        return this;
    }

    @Schema(description="")
    public PaymentMethodGroup getGroup() {
        return this.group;
    }

    public void setGroup(PaymentMethodGroup group) {
        this.group = group;
    }

    public RecurringDetail inputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
        return this;
    }

    public RecurringDetail addInputDetailsItem(InputDetail inputDetailsItem) {
        if (this.inputDetails == null) {
            this.inputDetails = new ArrayList<InputDetail>();
        }
        this.inputDetails.add(inputDetailsItem);
        return this;
    }

    @Schema(description="All input details to be provided to complete the payment with this payment method.")
    public List<InputDetail> getInputDetails() {
        return this.inputDetails;
    }

    public void setInputDetails(List<InputDetail> inputDetails) {
        this.inputDetails = inputDetails;
    }

    public RecurringDetail issuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
        return this;
    }

    public RecurringDetail addIssuersItem(PaymentMethodIssuer issuersItem) {
        if (this.issuers == null) {
            this.issuers = new ArrayList<PaymentMethodIssuer>();
        }
        this.issuers.add(issuersItem);
        return this;
    }

    @Schema(description="A list of issuers for this payment method.")
    public List<PaymentMethodIssuer> getIssuers() {
        return this.issuers;
    }

    public void setIssuers(List<PaymentMethodIssuer> issuers) {
        this.issuers = issuers;
    }

    public RecurringDetail name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The displayable name of this payment method.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RecurringDetail recurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
        return this;
    }

    @Schema(description="The reference that uniquely identifies the recurring detail.")
    public String getRecurringDetailReference() {
        return this.recurringDetailReference;
    }

    public void setRecurringDetailReference(String recurringDetailReference) {
        this.recurringDetailReference = recurringDetailReference;
    }

    public RecurringDetail storedDetails(StoredDetails storedDetails) {
        this.storedDetails = storedDetails;
        return this;
    }

    @Schema(description="")
    public StoredDetails getStoredDetails() {
        return this.storedDetails;
    }

    public void setStoredDetails(StoredDetails storedDetails) {
        this.storedDetails = storedDetails;
    }

    public RecurringDetail type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The unique payment method code.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecurringDetail recurringDetail = (RecurringDetail)o;
        return Objects.equals(this.brand, recurringDetail.brand) && Objects.equals(this.brands, recurringDetail.brands) && Objects.equals(this.configuration, recurringDetail.configuration) && Objects.equals((Object)this.fundingSource, (Object)recurringDetail.fundingSource) && Objects.equals(this.group, recurringDetail.group) && Objects.equals(this.inputDetails, recurringDetail.inputDetails) && Objects.equals(this.issuers, recurringDetail.issuers) && Objects.equals(this.name, recurringDetail.name) && Objects.equals(this.recurringDetailReference, recurringDetail.recurringDetailReference) && Objects.equals(this.storedDetails, recurringDetail.storedDetails) && Objects.equals(this.type, recurringDetail.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brand, this.brands, this.configuration, this.fundingSource, this.group, this.inputDetails, this.issuers, this.name, this.recurringDetailReference, this.storedDetails, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecurringDetail {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    brands: ").append(this.toIndentedString(this.brands)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this.configuration)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    inputDetails: ").append(this.toIndentedString(this.inputDetails)).append("\n");
        sb.append("    issuers: ").append(this.toIndentedString(this.issuers)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    recurringDetailReference: ").append(this.toIndentedString(this.recurringDetailReference)).append("\n");
        sb.append("    storedDetails: ").append(this.toIndentedString(this.storedDetails)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FundingSourceEnum {
        DEBIT("debit");

        @JsonValue
        private final String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FundingSourceEnum fromValue(String input) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FundingSourceEnum> {
            public void write(JsonWriter jsonWriter, FundingSourceEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public FundingSourceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FundingSourceEnum.fromValue(value);
            }
        }
    }
}

