/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class ThreeDSecureData {
    @SerializedName(value="authenticationResponse")
    private AuthenticationResponseEnum authenticationResponse = null;
    @SerializedName(value="cavv")
    private byte[] cavv = null;
    @SerializedName(value="cavvAlgorithm")
    private String cavvAlgorithm = null;
    @SerializedName(value="challengeCancel")
    private ChallengeCancelEnum challengeCancel = null;
    @SerializedName(value="directoryResponse")
    private DirectoryResponseEnum directoryResponse = null;
    @SerializedName(value="dsTransID")
    private String dsTransID = null;
    @SerializedName(value="eci")
    private String eci = null;
    @SerializedName(value="riskScore")
    private String riskScore = null;
    @SerializedName(value="threeDSVersion")
    private String threeDSVersion = null;
    @SerializedName(value="tokenAuthenticationVerificationValue")
    private byte[] tokenAuthenticationVerificationValue = null;
    @SerializedName(value="transStatusReason")
    private String transStatusReason = null;
    @SerializedName(value="xid")
    private byte[] xid = null;

    public ThreeDSecureData authenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
        return this;
    }

    @Schema(description="In 3D Secure 1, the authentication response if the shopper was redirected.  In 3D Secure 2, this is the `transStatus` from the challenge result. If the transaction was frictionless, omit this parameter.")
    public AuthenticationResponseEnum getAuthenticationResponse() {
        return this.authenticationResponse;
    }

    public void setAuthenticationResponse(AuthenticationResponseEnum authenticationResponse) {
        this.authenticationResponse = authenticationResponse;
    }

    public ThreeDSecureData cavv(byte[] cavv) {
        this.cavv = cavv;
        return this;
    }

    @Schema(description="The cardholder authentication value (base64 encoded, 20 bytes in a decoded form).")
    public byte[] getCavv() {
        return this.cavv;
    }

    public void setCavv(byte[] cavv) {
        this.cavv = cavv;
    }

    public ThreeDSecureData cavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
        return this;
    }

    @Schema(description="The CAVV algorithm used. Include this only for 3D Secure 1.")
    public String getCavvAlgorithm() {
        return this.cavvAlgorithm;
    }

    public void setCavvAlgorithm(String cavvAlgorithm) {
        this.cavvAlgorithm = cavvAlgorithm;
    }

    public ThreeDSecureData challengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
        return this;
    }

    @Schema(description="Indicator informing the Access Control Server (ACS) and the Directory Server (DS) that the authentication has been cancelled. For possible values, refer to [3D Secure API reference](https://docs.adyen.com/online-payments/3d-secure/api-reference#mpidata).")
    public ChallengeCancelEnum getChallengeCancel() {
        return this.challengeCancel;
    }

    public void setChallengeCancel(ChallengeCancelEnum challengeCancel) {
        this.challengeCancel = challengeCancel;
    }

    public ThreeDSecureData directoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
        return this;
    }

    @Schema(description="In 3D Secure 1, this is the enrollment response from the 3D directory server.  In 3D Secure 2, this is the `transStatus` from the `ARes`.")
    public DirectoryResponseEnum getDirectoryResponse() {
        return this.directoryResponse;
    }

    public void setDirectoryResponse(DirectoryResponseEnum directoryResponse) {
        this.directoryResponse = directoryResponse;
    }

    public ThreeDSecureData dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @Schema(description="Supported for 3D Secure 2. The unique transaction identifier assigned by the Directory Server (DS) to identify a single transaction.")
    public String getDsTransID() {
        return this.dsTransID;
    }

    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public ThreeDSecureData eci(String eci) {
        this.eci = eci;
        return this;
    }

    @Schema(description="The electronic commerce indicator.")
    public String getEci() {
        return this.eci;
    }

    public void setEci(String eci) {
        this.eci = eci;
    }

    public ThreeDSecureData riskScore(String riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @Schema(description="Risk score calculated by Directory Server (DS). Required for Cartes Bancaires integrations.")
    public String getRiskScore() {
        return this.riskScore;
    }

    public void setRiskScore(String riskScore) {
        this.riskScore = riskScore;
    }

    public ThreeDSecureData threeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
        return this;
    }

    @Schema(description="The version of the 3D Secure protocol.")
    public String getThreeDSVersion() {
        return this.threeDSVersion;
    }

    public void setThreeDSVersion(String threeDSVersion) {
        this.threeDSVersion = threeDSVersion;
    }

    public ThreeDSecureData tokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
        return this;
    }

    @Schema(description="Network token authentication verification value (TAVV). The network token cryptogram.")
    public byte[] getTokenAuthenticationVerificationValue() {
        return this.tokenAuthenticationVerificationValue;
    }

    public void setTokenAuthenticationVerificationValue(byte[] tokenAuthenticationVerificationValue) {
        this.tokenAuthenticationVerificationValue = tokenAuthenticationVerificationValue;
    }

    public ThreeDSecureData transStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
        return this;
    }

    @Schema(description="Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
    public String getTransStatusReason() {
        return this.transStatusReason;
    }

    public void setTransStatusReason(String transStatusReason) {
        this.transStatusReason = transStatusReason;
    }

    public ThreeDSecureData xid(byte[] xid) {
        this.xid = xid;
        return this;
    }

    @Schema(description="Supported for 3D Secure 1. The transaction identifier (Base64-encoded, 20 bytes in a decoded form).")
    public byte[] getXid() {
        return this.xid;
    }

    public void setXid(byte[] xid) {
        this.xid = xid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreeDSecureData threeDSecureData = (ThreeDSecureData)o;
        return Objects.equals((Object)this.authenticationResponse, (Object)threeDSecureData.authenticationResponse) && Arrays.equals(this.cavv, threeDSecureData.cavv) && Objects.equals(this.cavvAlgorithm, threeDSecureData.cavvAlgorithm) && Objects.equals((Object)this.challengeCancel, (Object)threeDSecureData.challengeCancel) && Objects.equals((Object)this.directoryResponse, (Object)threeDSecureData.directoryResponse) && Objects.equals(this.dsTransID, threeDSecureData.dsTransID) && Objects.equals(this.eci, threeDSecureData.eci) && Objects.equals(this.riskScore, threeDSecureData.riskScore) && Objects.equals(this.threeDSVersion, threeDSecureData.threeDSVersion) && Arrays.equals(this.tokenAuthenticationVerificationValue, threeDSecureData.tokenAuthenticationVerificationValue) && Objects.equals(this.transStatusReason, threeDSecureData.transStatusReason) && Arrays.equals(this.xid, threeDSecureData.xid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationResponse, Arrays.hashCode(this.cavv), this.cavvAlgorithm, this.challengeCancel, this.directoryResponse, this.dsTransID, this.eci, this.riskScore, this.threeDSVersion, Arrays.hashCode(this.tokenAuthenticationVerificationValue), this.transStatusReason, Arrays.hashCode(this.xid)});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ThreeDSecureData {\n");
        sb.append("    authenticationResponse: ").append(this.toIndentedString((Object)this.authenticationResponse)).append("\n");
        sb.append("    cavv: ").append(this.toIndentedString(this.cavv)).append("\n");
        sb.append("    cavvAlgorithm: ").append(this.toIndentedString(this.cavvAlgorithm)).append("\n");
        sb.append("    challengeCancel: ").append(this.toIndentedString((Object)this.challengeCancel)).append("\n");
        sb.append("    directoryResponse: ").append(this.toIndentedString((Object)this.directoryResponse)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("    threeDSVersion: ").append(this.toIndentedString(this.threeDSVersion)).append("\n");
        sb.append("    tokenAuthenticationVerificationValue: ").append(this.toIndentedString(this.tokenAuthenticationVerificationValue)).append("\n");
        sb.append("    transStatusReason: ").append(this.toIndentedString(this.transStatusReason)).append("\n");
        sb.append("    xid: ").append(this.toIndentedString(this.xid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DirectoryResponseEnum {
        A("A"),
        C("C"),
        D("D"),
        I("I"),
        N("N"),
        R("R"),
        U("U"),
        Y("Y");

        @JsonValue
        private final String value;

        private DirectoryResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DirectoryResponseEnum fromValue(String input) {
            for (DirectoryResponseEnum b : DirectoryResponseEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DirectoryResponseEnum> {
            public void write(JsonWriter jsonWriter, DirectoryResponseEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public DirectoryResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DirectoryResponseEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ChallengeCancelEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06"),
        _07("07");

        @JsonValue
        private final String value;

        private ChallengeCancelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ChallengeCancelEnum fromValue(String input) {
            for (ChallengeCancelEnum b : ChallengeCancelEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ChallengeCancelEnum> {
            public void write(JsonWriter jsonWriter, ChallengeCancelEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ChallengeCancelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ChallengeCancelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AuthenticationResponseEnum {
        Y("Y"),
        N("N"),
        U("U"),
        A("A");

        @JsonValue
        private final String value;

        private AuthenticationResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AuthenticationResponseEnum fromValue(String input) {
            for (AuthenticationResponseEnum b : AuthenticationResponseEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AuthenticationResponseEnum> {
            public void write(JsonWriter jsonWriter, AuthenticationResponseEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public AuthenticationResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AuthenticationResponseEnum.fromValue(value);
            }
        }
    }
}

