/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.AbstractPaymentRequest;
import com.adyen.model.AccountInfo;
import com.adyen.model.MerchantRiskIndicator;
import com.adyen.model.Split;
import com.adyen.model.ThreeDS2RequestData;
import com.adyen.model.ThreeDS2Result;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class PaymentRequest3ds2
extends AbstractPaymentRequest {
    @SerializedName(value="accountInfo")
    private AccountInfo accountInfo = null;
    @SerializedName(value="merchantRiskIndicator")
    private MerchantRiskIndicator merchantRiskIndicator = null;
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="store")
    private String store = null;
    @SerializedName(value="threeDS2RequestData")
    private ThreeDS2RequestData threeDS2RequestData = null;
    @SerializedName(value="threeDS2Result")
    private ThreeDS2Result threeDS2Result = null;
    @SerializedName(value="threeDS2Token")
    private String threeDS2Token = null;
    @SerializedName(value="totalsGroup")
    private String totalsGroup = null;
    @SerializedName(value="trustedShopper")
    private Boolean trustedShopper = null;
    @SerializedName(value="recurringProcessingModel")
    private final RecurringProcessingModelEnum recurringProcessingModel = null;

    public PaymentRequest3ds2 accountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
        return this;
    }

    public AccountInfo getAccountInfo() {
        return this.accountInfo;
    }

    public void setAccountInfo(AccountInfo accountInfo) {
        this.accountInfo = accountInfo;
    }

    public MerchantRiskIndicator getMerchantRiskIndicator() {
        return this.merchantRiskIndicator;
    }

    public void setMerchantRiskIndicator(MerchantRiskIndicator merchantRiskIndicator) {
        this.merchantRiskIndicator = merchantRiskIndicator;
    }

    public PaymentRequest3ds2 addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public PaymentRequest3ds2 store(String store) {
        this.store = store;
        return this;
    }

    public String getStore() {
        return this.store;
    }

    public void setStore(String store) {
        this.store = store;
    }

    public PaymentRequest3ds2 threeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
        return this;
    }

    public ThreeDS2RequestData getThreeDS2RequestData() {
        return this.threeDS2RequestData;
    }

    public void setThreeDS2RequestData(ThreeDS2RequestData threeDS2RequestData) {
        this.threeDS2RequestData = threeDS2RequestData;
    }

    public PaymentRequest3ds2 threeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
        return this;
    }

    public ThreeDS2Result getThreeDS2Result() {
        return this.threeDS2Result;
    }

    public void setThreeDS2Result(ThreeDS2Result threeDS2Result) {
        this.threeDS2Result = threeDS2Result;
    }

    public PaymentRequest3ds2 threeDS2Token(String threeDS2Token) {
        this.threeDS2Token = threeDS2Token;
        return this;
    }

    public String getThreeDS2Token() {
        return this.threeDS2Token;
    }

    public void setThreeDS2Token(String threeDS2Token) {
        this.threeDS2Token = threeDS2Token;
    }

    public PaymentRequest3ds2 totalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
        return this;
    }

    public String getTotalsGroup() {
        return this.totalsGroup;
    }

    public void setTotalsGroup(String totalsGroup) {
        this.totalsGroup = totalsGroup;
    }

    public PaymentRequest3ds2 trustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
        return this;
    }

    public Boolean isTrustedShopper() {
        return this.trustedShopper;
    }

    public void setTrustedShopper(Boolean trustedShopper) {
        this.trustedShopper = trustedShopper;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentRequest3ds2 paymentRequest3ds2 = (PaymentRequest3ds2)o;
        return Objects.equals(this.accountInfo, paymentRequest3ds2.accountInfo) && Objects.equals(this.merchantRiskIndicator, paymentRequest3ds2.merchantRiskIndicator) && Objects.equals((Object)this.recurringProcessingModel, (Object)paymentRequest3ds2.recurringProcessingModel) && Objects.equals(this.splits, paymentRequest3ds2.splits) && Objects.equals(this.store, paymentRequest3ds2.store) && Objects.equals(this.threeDS2RequestData, paymentRequest3ds2.threeDS2RequestData) && Objects.equals(this.threeDS2Result, paymentRequest3ds2.threeDS2Result) && Objects.equals(this.threeDS2Token, paymentRequest3ds2.threeDS2Token) && Objects.equals(this.totalsGroup, paymentRequest3ds2.totalsGroup) && Objects.equals(this.trustedShopper, paymentRequest3ds2.trustedShopper);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.accountInfo, this.merchantRiskIndicator, this.recurringProcessingModel, this.splits, this.store, this.threeDS2RequestData, this.threeDS2Result, this.threeDS2Token, this.totalsGroup, this.trustedShopper});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentRequest3ds2 {\n");
        sb.append("    accountInfo: ").append(Util.toIndentedString(this.accountInfo)).append("\n");
        sb.append("    merchantRiskIndicator: ").append(Util.toIndentedString(this.merchantRiskIndicator)).append("\n");
        sb.append("    recurringProcessingModel: ").append(Util.toIndentedString((Object)this.recurringProcessingModel)).append("\n");
        sb.append("    threeDS2RequestData: ").append(Util.toIndentedString(this.threeDS2RequestData)).append("\n");
        sb.append("    threeDS2Result: ").append(Util.toIndentedString(this.threeDS2Result)).append("\n");
        sb.append("    threeDS2Token: ").append(Util.toIndentedString(this.threeDS2Token)).append("\n");
        sb.append("    totalsGroup: ").append(Util.toIndentedString(this.totalsGroup)).append("\n");
        sb.append("    trustedShopper: ").append(Util.toIndentedString(this.trustedShopper)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto"),
        POS("POS");

        @JsonValue
        private final String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShopperInteractionEnum fromValue(String text) {
            return Arrays.stream(ShopperInteractionEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<ShopperInteractionEnum> {
            public void write(JsonWriter jsonWriter, ShopperInteractionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShopperInteractionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShopperInteractionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecurringProcessingModelEnum {
        CARDONFILE("CardOnFile"),
        SUBSCRIPTION("Subscription");

        @JsonValue
        private final String value;

        private RecurringProcessingModelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecurringProcessingModelEnum fromValue(String text) {
            return Arrays.stream(RecurringProcessingModelEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<RecurringProcessingModelEnum> {
            public void write(JsonWriter jsonWriter, RecurringProcessingModelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecurringProcessingModelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecurringProcessingModelEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

