/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.Address;
import com.adyen.model.Amount;
import com.adyen.model.BrowserInfo;
import com.adyen.model.ForexQuote;
import com.adyen.model.Installments;
import com.adyen.model.Name;
import com.adyen.model.applicationinfo.ApplicationInfo;
import com.adyen.model.recurring.Recurring;
import com.adyen.serializer.DateSerializer;
import com.adyen.serializer.DateTimeGMTSerializer;
import com.adyen.util.Util;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractPaymentRequest<T extends AbstractPaymentRequest<T>> {
    @SerializedName(value="amount")
    private Amount amount = null;
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="billingAddress")
    private Address billingAddress = null;
    @SerializedName(value="shopperIP")
    private String shopperIP = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="browserInfo")
    private BrowserInfo browserInfo = null;
    @SerializedName(value="shopperInteraction")
    private ShopperInteractionEnum shopperInteraction = null;
    @SerializedName(value="shopperEmail")
    private String shopperEmail = null;
    @SerializedName(value="shopperReference")
    private String shopperReference = null;
    @SerializedName(value="recurring")
    private Recurring recurring = null;
    @SerializedName(value="shopperStatement")
    private String shopperStatement = null;
    @SerializedName(value="fraudOffset")
    private Integer fraudOffset = null;
    @SerializedName(value="fundingSource")
    private FundingSourceEnum fundingSource = null;
    @SerializedName(value="sessionId")
    private String sessionId = null;
    @SerializedName(value="additionalAmount")
    private Amount additionalAmount = null;
    @SerializedName(value="selectedRecurringDetailReference")
    private String selectedRecurringDetailReference = null;
    @SerializedName(value="orderReference")
    private String orderReference = null;
    @SerializedName(value="merchantOrderReference")
    private String merchantOrderReference = null;
    @SerializedName(value="dccQuote")
    private ForexQuote dccQuote = null;
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="shopperName")
    private Name shopperName = null;
    @SerializedName(value="shopperLocale")
    private String shopperLocale = null;
    @SerializedName(value="selectedBrand")
    private String selectedBrand = null;
    @SerializedName(value="deliveryAddress")
    private Address deliveryAddress = null;
    @SerializedName(value="deliveryDate")
    @JsonAdapter(value=DateTimeGMTSerializer.class)
    private Date deliveryDate = null;
    @SerializedName(value="deviceFingerprint")
    private String deviceFingerprint = null;
    @SerializedName(value="installments")
    private Installments installments = null;
    @SerializedName(value="socialSecurityNumber")
    private String socialSecurityNumber = null;
    @SerializedName(value="captureDelayHours")
    private Integer captureDelayHours = null;
    @SerializedName(value="dateOfBirth")
    @JsonAdapter(value=DateSerializer.class)
    private Date dateOfBirth = null;
    @SerializedName(value="telephoneNumber")
    private String telephoneNumber = null;
    @SerializedName(value="mcc")
    private String mcc = null;
    @SerializedName(value="metadata")
    private Map<String, String> metadata = null;
    @SerializedName(value="applicationInfo")
    private final ApplicationInfo applicationInfo = new ApplicationInfo();
    @SerializedName(value="enableRealTimeUpdate")
    private Boolean enableRealTimeUpdate = null;
    @SerializedName(value="threeDSAuthenticationOnly")
    private Boolean threeDSAuthenticationOnly = null;

    public T setBrowserInfoData(String userAgent, String acceptHeader) {
        BrowserInfo browserInfo = new BrowserInfo();
        browserInfo.setAcceptHeader(acceptHeader);
        browserInfo.setUserAgent(userAgent);
        this.setBrowserInfo(browserInfo);
        return (T)this;
    }

    public Map<String, String> getOrCreateAdditionalData() {
        if (this.getAdditionalData() == null) {
            this.setAdditionalData(new HashMap<String, String>());
        }
        return this.getAdditionalData();
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public T reference(String reference) {
        this.reference = reference;
        return (T)this;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public T billingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return (T)this;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    public T shopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
        return (T)this;
    }

    public String getShopperIP() {
        return this.shopperIP;
    }

    public void setShopperIP(String shopperIP) {
        this.shopperIP = shopperIP;
    }

    public T merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return (T)this;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public T browserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
        return (T)this;
    }

    public BrowserInfo getBrowserInfo() {
        return this.browserInfo;
    }

    public void setBrowserInfo(BrowserInfo browserInfo) {
        this.browserInfo = browserInfo;
    }

    public T shopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
        return (T)this;
    }

    public ShopperInteractionEnum getShopperInteraction() {
        return this.shopperInteraction;
    }

    public void setShopperInteraction(ShopperInteractionEnum shopperInteraction) {
        this.shopperInteraction = shopperInteraction;
    }

    public T shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        return (T)this;
    }

    public String getShopperEmail() {
        return this.shopperEmail;
    }

    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
    }

    public T shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        return (T)this;
    }

    public String getShopperReference() {
        return this.shopperReference;
    }

    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
    }

    public T recurring(Recurring recurring) {
        this.recurring = recurring;
        return (T)this;
    }

    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public T shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        return (T)this;
    }

    public String getShopperStatement() {
        return this.shopperStatement;
    }

    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
    }

    public T fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        return (T)this;
    }

    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
    }

    public T sessionId(String sessionId) {
        this.sessionId = sessionId;
        return (T)this;
    }

    public T fundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
        return (T)this;
    }

    public FundingSourceEnum getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(FundingSourceEnum fundingSource) {
        this.fundingSource = fundingSource;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public T additionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
        return (T)this;
    }

    public Amount getAdditionalAmount() {
        return this.additionalAmount;
    }

    public void setAdditionalAmount(Amount additionalAmount) {
        this.additionalAmount = additionalAmount;
    }

    public T selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        return (T)this;
    }

    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
    }

    public T orderReference(String orderReference) {
        this.orderReference = orderReference;
        return (T)this;
    }

    public String getOrderReference() {
        return this.orderReference;
    }

    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    public T merchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
        return (T)this;
    }

    public String getMerchantOrderReference() {
        return this.merchantOrderReference;
    }

    public void setMerchantOrderReference(String merchantOrderReference) {
        this.merchantOrderReference = merchantOrderReference;
    }

    public T dccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
        return (T)this;
    }

    public ForexQuote getDccQuote() {
        return this.dccQuote;
    }

    public void setDccQuote(ForexQuote dccQuote) {
        this.dccQuote = dccQuote;
    }

    public T additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return (T)this;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public T shopperName(Name shopperName) {
        this.shopperName = shopperName;
        return (T)this;
    }

    public Name getShopperName() {
        return this.shopperName;
    }

    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
    }

    public T shopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
        return (T)this;
    }

    public String getShopperLocale() {
        return this.shopperLocale;
    }

    public void setShopperLocale(String shopperLocale) {
        this.shopperLocale = shopperLocale;
    }

    public T selectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
        return (T)this;
    }

    public String getSelectedBrand() {
        return this.selectedBrand;
    }

    public void setSelectedBrand(String selectedBrand) {
        this.selectedBrand = selectedBrand;
    }

    public T deliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
        return (T)this;
    }

    public Address getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public void setDeliveryAddress(Address deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public T deliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
        return (T)this;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public T deviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
        return (T)this;
    }

    public String getDeviceFingerprint() {
        return this.deviceFingerprint;
    }

    public void setDeviceFingerprint(String deviceFingerprint) {
        this.deviceFingerprint = deviceFingerprint;
    }

    public T installments(Installments installments) {
        this.installments = installments;
        return (T)this;
    }

    public Installments getInstallments() {
        return this.installments;
    }

    public void setInstallments(Installments installments) {
        this.installments = installments;
    }

    public T socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        return (T)this;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public T captureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
        return (T)this;
    }

    public Integer getCaptureDelayHours() {
        return this.captureDelayHours;
    }

    public void setCaptureDelayHours(Integer captureDelayHours) {
        this.captureDelayHours = captureDelayHours;
    }

    public T dateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return (T)this;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public T telephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
        return (T)this;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public T mcc(String mcc) {
        this.mcc = mcc;
        return (T)this;
    }

    public String getMcc() {
        return this.mcc;
    }

    public void setMcc(String mcc) {
        this.mcc = mcc;
    }

    public T metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return (T)this;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public T enableRealTimeUpdate(Boolean enableRealTimeUpdate) {
        this.enableRealTimeUpdate = enableRealTimeUpdate;
        return (T)this;
    }

    public Boolean isEnableRealTimeUpdate() {
        return this.enableRealTimeUpdate;
    }

    public void setEnableRealTimeUpdate(Boolean enableRealTimeUpdate) {
        this.enableRealTimeUpdate = enableRealTimeUpdate;
    }

    public T threeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
        return (T)this;
    }

    public Boolean isThreeDSAuthenticationOnly() {
        return this.threeDSAuthenticationOnly;
    }

    public void setThreeDSAuthenticationOnly(Boolean threeDSAuthenticationOnly) {
        this.threeDSAuthenticationOnly = threeDSAuthenticationOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPaymentRequest paymentRequest = (AbstractPaymentRequest)o;
        return Objects.equals(this.amount, paymentRequest.amount) && Objects.equals(this.reference, paymentRequest.reference) && Objects.equals(this.billingAddress, paymentRequest.billingAddress) && Objects.equals(this.shopperIP, paymentRequest.shopperIP) && Objects.equals(this.merchantAccount, paymentRequest.merchantAccount) && Objects.equals(this.browserInfo, paymentRequest.browserInfo) && Objects.equals((Object)this.shopperInteraction, (Object)paymentRequest.shopperInteraction) && Objects.equals(this.shopperEmail, paymentRequest.shopperEmail) && Objects.equals(this.shopperReference, paymentRequest.shopperReference) && Objects.equals(this.recurring, paymentRequest.recurring) && Objects.equals(this.shopperStatement, paymentRequest.shopperStatement) && Objects.equals(this.fraudOffset, paymentRequest.fraudOffset) && Objects.equals((Object)this.fundingSource, (Object)paymentRequest.fundingSource) && Objects.equals(this.sessionId, paymentRequest.sessionId) && Objects.equals(this.additionalAmount, paymentRequest.additionalAmount) && Objects.equals(this.selectedRecurringDetailReference, paymentRequest.selectedRecurringDetailReference) && Objects.equals(this.orderReference, paymentRequest.orderReference) && Objects.equals(this.merchantOrderReference, paymentRequest.merchantOrderReference) && Objects.equals(this.dccQuote, paymentRequest.dccQuote) && Objects.equals(this.additionalData, paymentRequest.additionalData) && Objects.equals(this.shopperName, paymentRequest.shopperName) && Objects.equals(this.shopperLocale, paymentRequest.shopperLocale) && Objects.equals(this.selectedBrand, paymentRequest.selectedBrand) && Objects.equals(this.deliveryAddress, paymentRequest.deliveryAddress) && Objects.equals(this.deliveryDate, paymentRequest.deliveryDate) && Objects.equals(this.deviceFingerprint, paymentRequest.deviceFingerprint) && Objects.equals(this.installments, paymentRequest.installments) && Objects.equals(this.socialSecurityNumber, paymentRequest.socialSecurityNumber) && Objects.equals(this.captureDelayHours, paymentRequest.captureDelayHours) && Objects.equals(this.dateOfBirth, paymentRequest.dateOfBirth) && Objects.equals(this.telephoneNumber, paymentRequest.telephoneNumber) && Objects.equals(this.mcc, paymentRequest.mcc) && Objects.equals(this.metadata, paymentRequest.metadata) && Objects.equals(this.applicationInfo, paymentRequest.applicationInfo) && Objects.equals(this.enableRealTimeUpdate, paymentRequest.enableRealTimeUpdate) && Objects.equals(this.threeDSAuthenticationOnly, paymentRequest.threeDSAuthenticationOnly);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.reference, this.billingAddress, this.shopperIP, this.merchantAccount, this.browserInfo, this.shopperInteraction, this.shopperEmail, this.shopperReference, this.recurring, this.shopperStatement, this.fraudOffset, this.fundingSource, this.sessionId, this.additionalAmount, this.selectedRecurringDetailReference, this.orderReference, this.merchantOrderReference, this.dccQuote, this.additionalData, this.shopperName, this.shopperLocale, this.selectedBrand, this.deliveryAddress, this.deliveryDate, this.deviceFingerprint, this.installments, this.socialSecurityNumber, this.captureDelayHours, this.dateOfBirth, this.telephoneNumber, this.mcc, this.metadata, this.applicationInfo, this.enableRealTimeUpdate, this.threeDSAuthenticationOnly});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    amount: ").append(Util.toIndentedString(this.amount)).append("\n");
        sb.append("    reference: ").append(Util.toIndentedString(this.reference)).append("\n");
        sb.append("    billingAddress: ").append(Util.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    shopperIP: ").append(Util.toIndentedString(this.shopperIP)).append("\n");
        sb.append("    merchantAccount: ").append(Util.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    browserInfo: ").append(Util.toIndentedString(this.browserInfo)).append("\n");
        sb.append("    shopperInteraction: ").append(Util.toIndentedString((Object)this.shopperInteraction)).append("\n");
        sb.append("    shopperEmail: ").append(Util.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperReference: ").append(Util.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    recurring: ").append(Util.toIndentedString(this.recurring)).append("\n");
        sb.append("    shopperStatement: ").append(Util.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    fraudOffset: ").append(Util.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    fundingSource: ").append(Util.toIndentedString((Object)this.fundingSource)).append("\n");
        sb.append("    sessionId: ").append(Util.toIndentedString(this.sessionId)).append("\n");
        sb.append("    additionalAmount: ").append(Util.toIndentedString(this.additionalAmount)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(Util.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    orderReference: ").append(Util.toIndentedString(this.orderReference)).append("\n");
        sb.append("    merchantOrderReference: ").append(Util.toIndentedString(this.merchantOrderReference)).append("\n");
        sb.append("    dccQuote: ").append(Util.toIndentedString(this.dccQuote)).append("\n");
        sb.append("    additionalData: ").append(Util.toIndentedString(this.stringifyAdditionalData())).append("\n");
        sb.append("    shopperName: ").append(Util.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperLocale: ").append(Util.toIndentedString(this.shopperLocale)).append("\n");
        sb.append("    selectedBrand: ").append(Util.toIndentedString(this.selectedBrand)).append("\n");
        sb.append("    deliveryAddress: ").append(Util.toIndentedString(this.deliveryAddress)).append("\n");
        sb.append("    deliveryDate: ").append(Util.toIndentedString(this.deliveryDate)).append("\n");
        sb.append("    deviceFingerprint: ").append(Util.toIndentedString(this.deviceFingerprint)).append("\n");
        sb.append("    installments: ").append(Util.toIndentedString(this.installments)).append("\n");
        sb.append("    socialSecurityNumber: ").append(Util.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("    captureDelayHours: ").append(Util.toIndentedString(this.captureDelayHours)).append("\n");
        sb.append("    dateOfBirth: ").append(Util.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    telephoneNumber: ").append(Util.toIndentedString(this.telephoneNumber)).append("\n");
        sb.append("    mcc: ").append(Util.toIndentedString(this.mcc)).append("\n");
        sb.append("    metadata: ").append(Util.toIndentedString(this.metadata)).append("\n");
        sb.append("    applicationInfo: ").append(Util.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    enableRealTimeUpdate: ").append(Util.toIndentedString(this.enableRealTimeUpdate)).append("\n");
        sb.append("    threeDSAuthenticationOnly: ").append(Util.toIndentedString(this.threeDSAuthenticationOnly)).append("\n");
        return sb.toString();
    }

    private String stringifyAdditionalData() {
        if (this.additionalData == null) {
            return null;
        }
        HashMap<String, String> nonSensitiveAdditionalData = new HashMap<String, String>(this.additionalData);
        List<String> keys = Arrays.asList("card.encrypted.json", "encryptedCardNumber", "encryptedExpiryMonth", "encryptedExpiryYear", "encryptedSecurityCode");
        keys.stream().forEach(s -> nonSensitiveAdditionalData.computeIfPresent((String)s, (s1, s2) -> "***"));
        return ((Object)nonSensitiveAdditionalData).toString();
    }

    public static enum FundingSourceEnum {
        DEBIT("debit"),
        CREDIT("credit");

        @JsonValue
        private final String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum ShopperInteractionEnum {
        ECOMMERCE("Ecommerce"),
        CONTAUTH("ContAuth"),
        MOTO("Moto");

        @JsonValue
        private final String value;

        private ShopperInteractionEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

