/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.util;

import com.adyen.model.Amount;
import com.adyen.model.notification.NotificationRequestItem;
import com.adyen.util.Util;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.SortedMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class HMACValidator {
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final String DATA_SEPARATOR = ":";

    public String calculateHMAC(String data, String key) throws SignatureException {
        try {
            byte[] rawKey = Hex.decodeHex((char[])key.toCharArray());
            SecretKeySpec signingKey = new SecretKeySpec(rawKey, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
            return new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    public String calculateHMAC(NotificationRequestItem notificationRequestItem, String key) throws SignatureException {
        return this.calculateHMAC(this.getDataToSign(notificationRequestItem), key);
    }

    public boolean validateHMAC(NotificationRequestItem notificationRequestItem, String key) throws IllegalArgumentException, SignatureException {
        if (notificationRequestItem.getAdditionalData() == null || notificationRequestItem.getAdditionalData().get("hmacSignature").isEmpty()) {
            throw new IllegalArgumentException("Missing hmacSignature");
        }
        byte[] merchantSign = notificationRequestItem.getAdditionalData().get("hmacSignature").getBytes(StandardCharsets.UTF_8);
        byte[] expectedSign = this.calculateHMAC(notificationRequestItem, key).getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(merchantSign, expectedSign);
    }

    public String getDataToSign(NotificationRequestItem notificationRequestItem) {
        ArrayList<String> signedDataList = new ArrayList<String>(8);
        signedDataList.add(notificationRequestItem.getPspReference());
        signedDataList.add(notificationRequestItem.getOriginalReference());
        signedDataList.add(notificationRequestItem.getMerchantAccountCode());
        signedDataList.add(notificationRequestItem.getMerchantReference());
        Amount amount = notificationRequestItem.getAmount();
        signedDataList.add(amount.getValue().toString());
        signedDataList.add(amount.getCurrency());
        signedDataList.add(notificationRequestItem.getEventCode());
        signedDataList.add(String.valueOf(notificationRequestItem.isSuccess()));
        return Util.implode(DATA_SEPARATOR, signedDataList);
    }

    public String getDataToSign(SortedMap<String, String> postParameters) {
        ArrayList parts = new ArrayList();
        postParameters.keySet().stream().forEach(s -> parts.add(this.escapeVal((String)s)));
        postParameters.values().stream().forEach(s -> parts.add(this.escapeVal((String)s)));
        return Util.implode(DATA_SEPARATOR, parts);
    }

    private String escapeVal(String val) {
        if (val == null) {
            return "";
        }
        return val.replace("\\", "\\\\").replace(DATA_SEPARATOR, "\\:");
    }
}

