/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Config;
import com.adyen.Service;
import com.adyen.Util.HMACValidator;
import com.adyen.httpclient.ClientInterface;
import com.adyen.httpclient.HTTPClientException;
import com.adyen.model.hpp.DirectoryLookupRequest;
import com.adyen.model.hpp.DirectoryLookupResult;
import com.adyen.model.hpp.PaymentMethod;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.security.SignatureException;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class HostedPaymentPages
extends Service {
    public HostedPaymentPages(Client client) {
        super(client);
    }

    public String directoryLookup(Map<String, String> postParameters) throws HTTPClientException, IOException {
        String endpoint = this.getClient().getConfig().getHppEndpoint() + "/directory.shtml";
        ClientInterface httpClient = this.getClient().getHttpClient();
        Config config = this.getClient().getConfig();
        return httpClient.post(endpoint, postParameters, config);
    }

    public SortedMap<String, String> getPostParametersFromDLRequest(DirectoryLookupRequest request) throws SignatureException {
        Config config = this.getClient().getConfig();
        TreeMap<String, String> postParameters = new TreeMap<String, String>();
        postParameters.put("currencyCode", request.getCurrencyCode());
        if (request.getMerchantAccount() != null) {
            postParameters.put("merchantAccount", request.getMerchantAccount());
        } else {
            postParameters.put("merchantAccount", config.getMerchantAccount());
        }
        postParameters.put("paymentAmount", request.getPaymentAmount());
        if (request.getSkinCode() != null) {
            postParameters.put("skinCode", request.getSkinCode());
        } else {
            postParameters.put("skinCode", config.getSkinCode());
        }
        postParameters.put("merchantReference", request.getMerchantReference());
        postParameters.put("sessionValidity", request.getSessionValidity());
        postParameters.put("countryCode", request.getCountryCode());
        HMACValidator hmacValidator = new HMACValidator();
        String dataToSign = hmacValidator.getDataToSign(postParameters);
        String hmacKey = request.getHmacKey() != null ? request.getHmacKey() : config.getHmacKey();
        String merchantSig = hmacValidator.calculateHMAC(dataToSign, hmacKey);
        postParameters.put("merchantSig", merchantSig);
        return postParameters;
    }

    public List<PaymentMethod> getPaymentMethods(DirectoryLookupRequest request) throws SignatureException, IOException, HTTPClientException {
        SortedMap<String, String> postParameters = this.getPostParametersFromDLRequest(request);
        String jsonResult = this.directoryLookup(postParameters);
        DirectoryLookupResult directoryLookupResult = (DirectoryLookupResult)GSON.fromJson(jsonResult, new TypeToken<DirectoryLookupResult>(){}.getType());
        return directoryLookupResult.getPaymentMethods();
    }
}

