/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.store;

import com.adobe.testing.s3mock.dto.ChecksumAlgorithm;
import com.adobe.testing.s3mock.dto.LegalHold;
import com.adobe.testing.s3mock.dto.Owner;
import com.adobe.testing.s3mock.dto.Retention;
import com.adobe.testing.s3mock.dto.StorageClass;
import com.adobe.testing.s3mock.dto.Tag;
import com.adobe.testing.s3mock.util.EtagUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public record S3ObjectMetadata(UUID id, String key, String size, String modificationDate, String etag, String contentType, long lastModified, Path dataPath, Map<String, String> userMetadata, List<Tag> tags, LegalHold legalHold, Retention retention, Owner owner, Map<String, String> storeHeaders, Map<String, String> encryptionHeaders, ChecksumAlgorithm checksumAlgorithm, String checksum, StorageClass storageClass) {
    public S3ObjectMetadata {
        etag = EtagUtil.normalizeEtag(etag);
        contentType = Objects.requireNonNullElse(contentType, "application/octet-stream");
        userMetadata = userMetadata == null ? Collections.emptyMap() : userMetadata;
        tags = Objects.requireNonNullElse(tags, new ArrayList());
        storeHeaders = storeHeaders == null ? Collections.emptyMap() : storeHeaders;
        encryptionHeaders = encryptionHeaders == null ? Collections.emptyMap() : encryptionHeaders;
        storageClass = storageClass == StorageClass.STANDARD ? null : storageClass;
    }
}

