/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import software.amazon.awssdk.core.checksums.Algorithm;

public enum ChecksumAlgorithm {
    CRC32("CRC32"),
    CRC32C("CRC32C"),
    SHA1("SHA1"),
    SHA256("SHA256");

    private final String value;

    @JsonCreator
    private ChecksumAlgorithm(String value) {
        this.value = value;
    }

    public static ChecksumAlgorithm fromString(String value) {
        return switch (value) {
            case "sha256", "SHA256" -> SHA256;
            case "sha1", "SHA1" -> SHA1;
            case "crc32", "CRC32" -> CRC32;
            case "crc32c", "CRC32C" -> CRC32C;
            default -> null;
        };
    }

    public static ChecksumAlgorithm fromHeader(String value) {
        return switch (value) {
            case "x-amz-checksum-sha256" -> SHA256;
            case "x-amz-checksum-sha1" -> SHA1;
            case "x-amz-checksum-crc32" -> CRC32;
            case "x-amz-checksum-crc32c" -> CRC32C;
            default -> null;
        };
    }

    public Algorithm toAlgorithm() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> Algorithm.CRC32;
            case 1 -> Algorithm.CRC32C;
            case 2 -> Algorithm.SHA1;
            case 3 -> Algorithm.SHA256;
        };
    }

    @JsonValue
    public String toString() {
        return String.valueOf(this.value);
    }
}

