/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.testing.s3mock.testcontainers;

import java.nio.file.Path;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class S3MockContainer
extends GenericContainer<S3MockContainer> {
    public static final String IMAGE_NAME = "adobe/s3mock";
    private static final int S3MOCK_DEFAULT_HTTP_PORT = 9090;
    private static final int S3MOCK_DEFAULT_HTTPS_PORT = 9191;
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"adobe/s3mock");

    public S3MockContainer(String tag) {
        this(DEFAULT_IMAGE_NAME.withTag(tag));
    }

    public S3MockContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitingFor((WaitStrategy)Wait.forHttp((String)"/favicon.ico").forPort(9090).withMethod("GET").forStatusCode(200));
        this.addExposedPort(9090);
        this.addExposedPort(9191);
    }

    public S3MockContainer withValidKmsKeys(String kmsKeys) {
        this.addEnv("validKmsKeys", kmsKeys);
        return (S3MockContainer)this.self();
    }

    public S3MockContainer withInitialBuckets(String initialBuckets) {
        this.addEnv("initialBuckets", initialBuckets);
        return (S3MockContainer)this.self();
    }

    public S3MockContainer withVolumeAsRoot(String root) {
        this.withFileSystemBind(root, "/s3mockroot", BindMode.READ_WRITE);
        this.addEnv("root", "/s3mockroot");
        return (S3MockContainer)this.self();
    }

    public S3MockContainer withVolumeAsRoot(Path root) {
        return this.withVolumeAsRoot(root.toString());
    }

    public String getHttpEndpoint() {
        return String.format("http://%s:%d", this.getHost(), this.getHttpServerPort());
    }

    public String getHttpsEndpoint() {
        return String.format("https://%s:%d", this.getHost(), this.getHttpsServerPort());
    }

    public Integer getHttpServerPort() {
        return this.getMappedPort(9090);
    }

    public Integer getHttpsServerPort() {
        return this.getMappedPort(9191);
    }
}

