/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.extensions;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.RemoteViews;
import com.adobe.marketing.mobile.notificationbuilder.PushTemplateConstants;
import com.adobe.marketing.mobile.notificationbuilder.internal.PendingIntentUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.PushTemplateImageUtils;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.AppResourceExtensionsKt;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.ServiceProvider;
import com.adobe.marketing.mobile.util.UrlUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a.\u0010\b\u001a\u00020\t*\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u000e\u001a\u00020\t*\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u0010\u001a\u00020\t*\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u0012\u001a\u00020\t*\u00020\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010\u0014\u001a\u00020\u0003*\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aV\u0010\u0016\u001a\u00020\t*\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0000\u001a\u001e\u0010#\u001a\u00020\u0003*\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u001e\u0010$\u001a\u00020\t*\u00020\u00042\b\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"SELF_TAG", "", "setBundledImage", "", "Landroid/widget/RemoteViews;", "image", "containerViewId", "", "setElementColor", "", "elementId", "colorHex", "methodName", "viewFriendlyName", "setNotificationBackgroundColor", "backgroundColor", "setNotificationBodyTextColor", "expandedBodyTextColor", "setNotificationTitleTextColor", "titleTextColor", "setRemoteImage", "imageUrl", "setRemoteViewClickAction", "context", "Landroid/content/Context;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "targetViewResourceId", "actionUri", "actionId", "actionType", "Lcom/adobe/marketing/mobile/notificationbuilder/PushTemplateConstants$ActionType;", "intentExtra", "Landroid/os/Bundle;", "setRemoteViewImage", "setTimerTextColor", "timerTextColor", "notificationbuilder_phoneRelease"})
public final class RemoteViewsExtensionsKt {
    @NotNull
    private static final String SELF_TAG = "RemoteViewExtensions";

    public static final void setElementColor(@NotNull RemoteViews $this$setElementColor, int elementId, @Nullable String colorHex, @NotNull String methodName, @NotNull String viewFriendlyName) {
        Intrinsics.checkNotNullParameter((Object)$this$setElementColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)viewFriendlyName, (String)"viewFriendlyName");
        CharSequence charSequence = colorHex;
        if (charSequence == null || charSequence.length() == 0) {
            Log.debug((String)"PushTemplates", (String)SELF_TAG, (String)("Empty color hex string found, custom color will not be applied to " + viewFriendlyName + '.'), (Object[])new Object[0]);
            return;
        }
        try {
            $this$setElementColor.setInt(elementId, methodName, Color.parseColor((String)colorHex));
        }
        catch (IllegalArgumentException exception) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Unrecognized hex string passed to Color.parseColor(), custom color will not be applied to " + viewFriendlyName + '.'), (Object[])new Object[0]);
        }
    }

    public static final void setNotificationBackgroundColor(@NotNull RemoteViews $this$setNotificationBackgroundColor, @Nullable String backgroundColor, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotificationBackgroundColor, (String)"<this>");
        RemoteViewsExtensionsKt.setElementColor($this$setNotificationBackgroundColor, containerViewId, '#' + backgroundColor, "setBackgroundColor", "notification background");
    }

    public static final void setTimerTextColor(@NotNull RemoteViews $this$setTimerTextColor, @Nullable String timerTextColor, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setTimerTextColor, (String)"<this>");
        RemoteViewsExtensionsKt.setElementColor($this$setTimerTextColor, containerViewId, '#' + timerTextColor, "setTextColor", "Timer Text");
    }

    public static final void setNotificationTitleTextColor(@NotNull RemoteViews $this$setNotificationTitleTextColor, @Nullable String titleTextColor, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotificationTitleTextColor, (String)"<this>");
        RemoteViewsExtensionsKt.setElementColor($this$setNotificationTitleTextColor, containerViewId, '#' + titleTextColor, "setTextColor", "notification title");
    }

    public static final void setNotificationBodyTextColor(@NotNull RemoteViews $this$setNotificationBodyTextColor, @Nullable String expandedBodyTextColor, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setNotificationBodyTextColor, (String)"<this>");
        RemoteViewsExtensionsKt.setElementColor($this$setNotificationBodyTextColor, containerViewId, '#' + expandedBodyTextColor, "setTextColor", "notification body text");
    }

    public static final boolean setRemoteViewImage(@NotNull RemoteViews $this$setRemoteViewImage, @Nullable String image, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setRemoteViewImage, (String)"<this>");
        CharSequence charSequence = image;
        if (charSequence == null || charSequence.length() == 0) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)"Null or empty image string found, image will not be applied.", (Object[])new Object[0]);
            $this$setRemoteViewImage.setViewVisibility(containerViewId, 8);
            return false;
        }
        return RemoteViewsExtensionsKt.setRemoteImage($this$setRemoteViewImage, image, containerViewId) || RemoteViewsExtensionsKt.setBundledImage($this$setRemoteViewImage, image, containerViewId);
    }

    public static final void setRemoteViewClickAction(@NotNull RemoteViews $this$setRemoteViewClickAction, @NotNull Context context, @Nullable Class<? extends Activity> trackerActivityClass, int targetViewResourceId, @Nullable String actionUri, @Nullable String actionId, @Nullable PushTemplateConstants.ActionType actionType, @Nullable Bundle intentExtra) {
        Intrinsics.checkNotNullParameter((Object)$this$setRemoteViewClickAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Setting remote view click action uri: " + actionUri + '.'), (Object[])new Object[0]);
        PushTemplateConstants.ActionType actionType2 = actionType;
        if (actionType2 != null) {
            PushTemplateConstants.ActionType it = actionType2;
            boolean bl = false;
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Setting remote view click action type: " + actionType.name() + '.'), (Object[])new Object[0]);
        }
        PendingIntent pendingIntent = PendingIntentUtils.INSTANCE.createPendingIntentForTrackerActivity$notificationbuilder_phoneRelease(context, trackerActivityClass, actionUri, actionId, actionType, intentExtra);
        $this$setRemoteViewClickAction.setOnClickPendingIntent(targetViewResourceId, pendingIntent);
    }

    public static final boolean setRemoteImage(@NotNull RemoteViews $this$setRemoteImage, @Nullable String imageUrl, int containerViewId) {
        Intrinsics.checkNotNullParameter((Object)$this$setRemoteImage, (String)"<this>");
        if (!UrlUtils.isValidUrl((String)imageUrl)) {
            return false;
        }
        int downloadedIconCount = PushTemplateImageUtils.INSTANCE.cacheImages$notificationbuilder_phoneRelease(CollectionsKt.listOf((Object)imageUrl));
        if (downloadedIconCount == 0) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Unable to download an image from URL " + imageUrl + ", image will not be applied."), (Object[])new Object[0]);
            $this$setRemoteImage.setViewVisibility(containerViewId, 8);
            return false;
        }
        $this$setRemoteImage.setImageViewBitmap(containerViewId, PushTemplateImageUtils.INSTANCE.getCachedImage$notificationbuilder_phoneRelease(imageUrl));
        return true;
    }

    public static final boolean setBundledImage(@NotNull RemoteViews $this$setBundledImage, @Nullable String image, int containerViewId) {
        Integer bundledIconId;
        Intrinsics.checkNotNullParameter((Object)$this$setBundledImage, (String)"<this>");
        Context context = ServiceProvider.getInstance().getAppContextService().getApplicationContext();
        Integer n = bundledIconId = context != null ? Integer.valueOf(AppResourceExtensionsKt.getIconWithResourceName(context, image)) : null;
        if (bundledIconId == null || bundledIconId == 0) {
            Log.warning((String)"PushTemplates", (String)SELF_TAG, (String)("Unable to find a bundled image with name " + image + ", image will not be applied."), (Object[])new Object[0]);
            $this$setBundledImage.setViewVisibility(containerViewId, 8);
            return false;
        }
        $this$setBundledImage.setImageViewResource(containerViewId, bundledIconId.intValue());
        return true;
    }
}

