/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.extensions;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.AppResourceExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.AEPPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"SELF_TAG", "", "createNotificationChannelIfRequired", "Landroid/app/NotificationManager;", "context", "Landroid/content/Context;", "template", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/AEPPushTemplate;", "notificationbuilder_phoneRelease"})
public final class NotificationManagerExtensionsKt {
    @NotNull
    private static final String SELF_TAG = "NotificationManagerExtensions";

    @NotNull
    public static final String createNotificationChannelIfRequired(@NotNull NotificationManager $this$createNotificationChannelIfRequired, @NotNull Context context, @NotNull AEPPushTemplate template) {
        String channelIdToUse;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$createNotificationChannelIfRequired, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        if (template.isFromIntent$notificationbuilder_phoneRelease()) {
            string = "AEPSDKSilentPushChannel";
        } else {
            string = template.getChannelId$notificationbuilder_phoneRelease();
            if (string == null) {
                string = channelIdToUse = "AEPSDKPushChannel";
            }
        }
        if (Build.VERSION.SDK_INT < 26) {
            return channelIdToUse;
        }
        if ($this$createNotificationChannelIfRequired.getNotificationChannel(channelIdToUse) != null) {
            Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Using previously created notification channel: " + channelIdToUse + '.'), (Object[])new Object[0]);
            return channelIdToUse;
        }
        NotificationChannel channel = new NotificationChannel(channelIdToUse, (CharSequence)(template.isFromIntent$notificationbuilder_phoneRelease() ? "Silent Notifications" : "General Notifications"), template.getNotificationImportance());
        if (template.isFromIntent$notificationbuilder_phoneRelease()) {
            channel.setSound(null, null);
        } else {
            CharSequence charSequence = template.getSound$notificationbuilder_phoneRelease();
            Uri sound = charSequence == null || charSequence.length() == 0 ? RingtoneManager.getDefaultUri((int)2) : AppResourceExtensionsKt.getSoundUriForResourceName(context, template.getSound$notificationbuilder_phoneRelease());
            channel.setSound(sound, null);
        }
        CharSequence charSequence = template.getSound$notificationbuilder_phoneRelease();
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Creating a new notification channel with ID: " + template.getChannelId$notificationbuilder_phoneRelease() + ". " + (charSequence == null || charSequence.length() == 0 ? "and default sound." : "and custom sound: " + template.getSound$notificationbuilder_phoneRelease() + '.')), (Object[])new Object[0]);
        $this$createNotificationChannelIfRequired.createNotificationChannel(channel);
        return channelIdToUse;
    }
}

