/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.notificationbuilder.internal.builders;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.RemoteViews;
import androidx.core.app.NotificationCompat;
import androidx.core.app.RemoteInput;
import com.adobe.marketing.mobile.notificationbuilder.NotificationConstructionFailedException;
import com.adobe.marketing.mobile.notificationbuilder.R;
import com.adobe.marketing.mobile.notificationbuilder.internal.builders.AEPPushNotificationBuilder;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.NotificationManagerExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.extensions.RemoteViewsExtensionsKt;
import com.adobe.marketing.mobile.notificationbuilder.internal.templates.InputBoxPushTemplate;
import com.adobe.marketing.mobile.services.Log;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J:\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\u0010\u0010\u0012\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0013\u0018\u00010\nJ2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/adobe/marketing/mobile/notificationbuilder/internal/builders/InputBoxNotificationBuilder;", "", "()V", "SELF_TAG", "", "addInputTextAction", "", "context", "Landroid/content/Context;", "trackerActivityClass", "Ljava/lang/Class;", "Landroid/app/Activity;", "builder", "Landroidx/core/app/NotificationCompat$Builder;", "channelId", "pushTemplate", "Lcom/adobe/marketing/mobile/notificationbuilder/internal/templates/InputBoxPushTemplate;", "construct", "broadcastReceiverClass", "Landroid/content/BroadcastReceiver;", "createInputReceivedPendingIntent", "Landroid/app/PendingIntent;", "notificationbuilder_phoneRelease"})
public final class InputBoxNotificationBuilder {
    @NotNull
    public static final InputBoxNotificationBuilder INSTANCE = new InputBoxNotificationBuilder();
    @NotNull
    private static final String SELF_TAG = "InputBoxNotificationBuilder";

    private InputBoxNotificationBuilder() {
    }

    @NotNull
    public final NotificationCompat.Builder construct(@NotNull Context context, @NotNull InputBoxPushTemplate pushTemplate, @Nullable Class<? extends Activity> trackerActivityClass, @Nullable Class<? extends BroadcastReceiver> broadcastReceiverClass) throws NotificationConstructionFailedException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)pushTemplate, (String)"pushTemplate");
        if (Build.VERSION.SDK_INT < 24) {
            throw new NotificationConstructionFailedException("Input box push notification on devices below Android N is not supported.");
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)"Building an input box template push notification.", (Object[])new Object[0]);
        String packageName = context.getPackageName();
        RemoteViews smallLayout = new RemoteViews(packageName, R.layout.push_template_collapsed);
        RemoteViews expandedLayout = new RemoteViews(packageName, R.layout.push_template_expanded);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager notificationManager = (NotificationManager)object;
        String channelIdToUse = NotificationManagerExtensionsKt.createNotificationChannelIfRequired(notificationManager, context, pushTemplate);
        NotificationCompat.Builder notificationBuilder = AEPPushNotificationBuilder.INSTANCE.construct(context, pushTemplate, channelIdToUse, trackerActivityClass, smallLayout, expandedLayout, R.id.basic_expanded_layout);
        String imageUri = pushTemplate.isFromIntent$notificationbuilder_phoneRelease() ? pushTemplate.getFeedbackImage$notificationbuilder_phoneRelease() : pushTemplate.getImageUrl$notificationbuilder_phoneRelease();
        RemoteViewsExtensionsKt.setRemoteViewImage(expandedLayout, imageUri, R.id.expanded_template_image);
        String expandedBodyText = pushTemplate.isFromIntent$notificationbuilder_phoneRelease() ? pushTemplate.getFeedbackText$notificationbuilder_phoneRelease() : pushTemplate.getExpandedBodyText$notificationbuilder_phoneRelease();
        String collapsedBodyText = pushTemplate.isFromIntent$notificationbuilder_phoneRelease() ? pushTemplate.getFeedbackText$notificationbuilder_phoneRelease() : pushTemplate.getBody$notificationbuilder_phoneRelease();
        smallLayout.setTextViewText(R.id.notification_title, (CharSequence)pushTemplate.getTitle$notificationbuilder_phoneRelease());
        smallLayout.setTextViewText(R.id.notification_body, (CharSequence)collapsedBodyText);
        expandedLayout.setTextViewText(R.id.notification_title, (CharSequence)pushTemplate.getTitle$notificationbuilder_phoneRelease());
        expandedLayout.setTextViewText(R.id.notification_body_expanded, (CharSequence)expandedBodyText);
        if (pushTemplate.isFromIntent$notificationbuilder_phoneRelease()) {
            return notificationBuilder;
        }
        Log.trace((String)"PushTemplates", (String)SELF_TAG, (String)("Adding an input box to capture text input. The input box receiver name is " + pushTemplate.getInputBoxReceiverName$notificationbuilder_phoneRelease() + '.'), (Object[])new Object[0]);
        this.addInputTextAction(context, trackerActivityClass, notificationBuilder, channelIdToUse, pushTemplate);
        return notificationBuilder;
    }

    private final void addInputTextAction(Context context, Class<? extends Activity> trackerActivityClass, NotificationCompat.Builder builder, String channelId, InputBoxPushTemplate pushTemplate) {
        CharSequence charSequence = pushTemplate.getInputTextHint$notificationbuilder_phoneRelease();
        String inputHint = charSequence == null || charSequence.length() == 0 ? "Reply" : pushTemplate.getInputTextHint$notificationbuilder_phoneRelease();
        RemoteInput remoteInput = new RemoteInput.Builder(pushTemplate.getInputBoxReceiverName$notificationbuilder_phoneRelease()).setLabel((CharSequence)inputHint).build();
        Intrinsics.checkNotNullExpressionValue((Object)remoteInput, (String)"Builder(pushTemplate.inp\u2026int)\n            .build()");
        RemoteInput remoteInput2 = remoteInput;
        PendingIntent replyPendingIntent = this.createInputReceivedPendingIntent(context, trackerActivityClass, channelId, pushTemplate);
        NotificationCompat.Action action = new NotificationCompat.Action.Builder(null, (CharSequence)inputHint, replyPendingIntent).addRemoteInput(remoteInput2).build();
        Intrinsics.checkNotNullExpressionValue((Object)action, (String)"Builder(null, inputHint,\u2026\n                .build()");
        NotificationCompat.Action action2 = action;
        builder.addAction(action2);
    }

    private final PendingIntent createInputReceivedPendingIntent(Context context, Class<? extends Activity> trackerActivityClass, String channelId, InputBoxPushTemplate pushTemplate) {
        Bundle inputReceivedIntentExtras = pushTemplate.getData().getBundle();
        inputReceivedIntentExtras.putString("adb_channel_id", channelId);
        Intent intent = new Intent("Input Received");
        Class<? extends Activity> clazz = trackerActivityClass;
        if (clazz != null) {
            Class<? extends Activity> it = clazz;
            boolean bl = false;
            intent.setClass(context.getApplicationContext(), trackerActivityClass);
        }
        intent.setFlags(0x24000000);
        intent.putExtras(inputReceivedIntentExtras);
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)intent, (int)0xA000000);
        Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getActivity(\n           \u2026nt.FLAG_MUTABLE\n        )");
        return pendingIntent;
    }
}

