/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import com.adobe.marketing.mobile.lifecycle.LifecycleUtil;
import com.adobe.marketing.mobile.lifecycle.LifecycleV2DataConverter;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleApplication;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleCloseTypeEnum;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleDevice;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleEnvironment;
import com.adobe.marketing.mobile.lifecycle.XDMLifecycleMobileDetails;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class LifecycleV2MetricsBuilder {
    private static final String SELF_LOG_TAG = "LifecycleV2MetricsBuilder";
    private final DeviceInforming deviceInfoService;
    private XDMLifecycleDevice xdmDeviceInfo;
    private XDMLifecycleEnvironment xdmEnvironmentInfo;

    LifecycleV2MetricsBuilder(DeviceInforming deviceInfoService) {
        this.deviceInfoService = deviceInfoService;
        if (deviceInfoService == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"%s (Device Info Services), while creating XDMLifecycleMetricsBuilder.", (Object[])new Object[]{"Unexpected Null Value"});
        }
    }

    Map<String, Object> buildAppLaunchXDMData(long launchTimestampMillis, boolean isInstall, boolean isUpgrade) {
        XDMLifecycleMobileDetails appLaunchXDMData = new XDMLifecycleMobileDetails();
        appLaunchXDMData.setApplication(this.computeAppLaunchData(isInstall, isUpgrade));
        appLaunchXDMData.setDevice(this.computeDeviceData());
        appLaunchXDMData.setEnvironment(this.computeEnvironmentData());
        appLaunchXDMData.setEventType("application.launch");
        appLaunchXDMData.setTimestamp(new Date(launchTimestampMillis));
        return appLaunchXDMData.serializeToXdm();
    }

    Map<String, Object> buildAppCloseXDMData(long launchTimestampMillis, long closeTimestampMillis, long fallbackCloseEventTimestampMillis, boolean isCloseUnknown) {
        XDMLifecycleMobileDetails appCloseXDMData = new XDMLifecycleMobileDetails();
        appCloseXDMData.setApplication(this.computeAppCloseData(launchTimestampMillis, closeTimestampMillis, isCloseUnknown));
        appCloseXDMData.setEventType("application.close");
        long unwrappedCloseTimestamp = closeTimestampMillis > 0L ? closeTimestampMillis : fallbackCloseEventTimestampMillis;
        appCloseXDMData.setTimestamp(new Date(unwrappedCloseTimestamp));
        return appCloseXDMData.serializeToXdm();
    }

    private XDMLifecycleApplication computeAppLaunchData(boolean isInstall, boolean isUpgrade) {
        XDMLifecycleApplication xdmApplicationInfoLaunch = new XDMLifecycleApplication();
        xdmApplicationInfoLaunch.setIsLaunch(true);
        if (isInstall) {
            xdmApplicationInfoLaunch.setIsInstall(true);
        } else if (isUpgrade) {
            xdmApplicationInfoLaunch.setIsUpgrade(true);
        }
        if (this.deviceInfoService == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Unable to add XDM Application data for app launch due to DeviceInfoService being not initialized.", (Object[])new Object[0]);
            return xdmApplicationInfoLaunch;
        }
        xdmApplicationInfoLaunch.setName(this.deviceInfoService.getApplicationName());
        xdmApplicationInfoLaunch.setId(this.deviceInfoService.getApplicationPackageName());
        xdmApplicationInfoLaunch.setVersion(LifecycleUtil.getV2AppVersion(this.deviceInfoService));
        xdmApplicationInfoLaunch.setLanguage(LifecycleUtil.formatLocaleXDM(this.deviceInfoService.getActiveLocale()));
        return xdmApplicationInfoLaunch;
    }

    private XDMLifecycleApplication computeAppCloseData(long launchTimestampMillis, long closeTimestampMillis, boolean isCloseUnknown) {
        XDMLifecycleApplication xdmApplicationInfoClose = new XDMLifecycleApplication();
        xdmApplicationInfoClose.setIsClose(true);
        xdmApplicationInfoClose.setCloseType(isCloseUnknown ? XDMLifecycleCloseTypeEnum.UNKNOWN : XDMLifecycleCloseTypeEnum.CLOSE);
        xdmApplicationInfoClose.setSessionLength(this.computeSessionLengthSeconds(launchTimestampMillis, closeTimestampMillis));
        return xdmApplicationInfoClose;
    }

    private XDMLifecycleEnvironment computeEnvironmentData() {
        if (this.xdmEnvironmentInfo != null) {
            return this.xdmEnvironmentInfo;
        }
        if (this.deviceInfoService == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Unable to add XDM Environment data due to DeviceInfoService being not initialized.", (Object[])new Object[0]);
            return null;
        }
        this.xdmEnvironmentInfo = new XDMLifecycleEnvironment();
        this.xdmEnvironmentInfo.setCarrier(this.deviceInfoService.getMobileCarrierName());
        this.xdmEnvironmentInfo.setType(LifecycleV2DataConverter.toEnvironmentTypeEnum(this.deviceInfoService.getRunMode()));
        this.xdmEnvironmentInfo.setOperatingSystem(this.deviceInfoService.getOperatingSystemName());
        this.xdmEnvironmentInfo.setOperatingSystemVersion(this.deviceInfoService.getOperatingSystemVersion());
        this.xdmEnvironmentInfo.setLanguage(LifecycleUtil.formatLocaleXDM(this.deviceInfoService.getSystemLocale()));
        return this.xdmEnvironmentInfo;
    }

    private XDMLifecycleDevice computeDeviceData() {
        if (this.xdmDeviceInfo != null) {
            return this.xdmDeviceInfo;
        }
        if (this.deviceInfoService == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Unable to add XDM Device data due to DeviceInfoService being not initialized.", (Object[])new Object[0]);
            return null;
        }
        this.xdmDeviceInfo = new XDMLifecycleDevice();
        DeviceInforming.DisplayInformation displayInfo = this.deviceInfoService.getDisplayInformation();
        if (displayInfo != null) {
            this.xdmDeviceInfo.setScreenWidth(displayInfo.getWidthPixels());
            this.xdmDeviceInfo.setScreenHeight(displayInfo.getHeightPixels());
        }
        this.xdmDeviceInfo.setType(LifecycleV2DataConverter.toDeviceTypeEnum(this.deviceInfoService.getDeviceType()));
        this.xdmDeviceInfo.setModel(this.deviceInfoService.getDeviceName());
        this.xdmDeviceInfo.setModelNumber(this.deviceInfoService.getDeviceBuildId());
        this.xdmDeviceInfo.setManufacturer(this.deviceInfoService.getDeviceManufacturer());
        return this.xdmDeviceInfo;
    }

    private int computeSessionLengthSeconds(long launchTimestampMillis, long closeTimestampMillis) {
        long sessionLengthSeconds;
        long sessionLength = 0L;
        if (launchTimestampMillis > 0L && closeTimestampMillis > 0L && closeTimestampMillis > launchTimestampMillis) {
            sessionLength = closeTimestampMillis - launchTimestampMillis;
        }
        return (sessionLengthSeconds = TimeUnit.MILLISECONDS.toSeconds(sessionLength)) <= Integer.MAX_VALUE ? (int)sessionLengthSeconds : 0;
    }
}

