/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.marketing.mobile.lifecycle;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.adobe.marketing.mobile.Event;
import com.adobe.marketing.mobile.lifecycle.LifecycleMetricsBuilder;
import com.adobe.marketing.mobile.lifecycle.LifecycleSession;
import com.adobe.marketing.mobile.services.DeviceInforming;
import com.adobe.marketing.mobile.services.Log;
import com.adobe.marketing.mobile.services.NamedCollection;
import com.adobe.marketing.mobile.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class LifecycleState {
    private static final String SELF_LOG_TAG = "LifecycleState";
    private final NamedCollection namedCollection;
    private final DeviceInforming deviceInfoService;
    private final LifecycleSession lifecycleSession;
    private final Map<String, String> lifecycleContextData = new HashMap<String, String>();
    private final Map<String, String> previousSessionLifecycleContextData = new HashMap<String, String>();

    LifecycleState(NamedCollection namedCollection, DeviceInforming deviceInfoService) {
        this.namedCollection = namedCollection;
        this.deviceInfoService = deviceInfoService;
        this.lifecycleSession = new LifecycleSession(namedCollection);
    }

    Map<String, String> computeBootData() {
        HashMap<String, String> contextData = new HashMap<String, String>();
        Map<String, String> currentContextData = this.getContextData();
        if (currentContextData != null) {
            contextData.putAll(currentContextData);
        }
        Map<String, String> defaultData = new LifecycleMetricsBuilder(this.deviceInfoService, this.namedCollection, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).addCoreData().addGenericData().build();
        contextData.putAll(defaultData);
        return contextData;
    }

    LifecycleSession.SessionInfo start(long startTimestampInSeconds, Map<String, String> additionalContextData, String advertisingIdentifier, long sessionTimeoutInSeconds, boolean isInstall) {
        LifecycleSession.SessionInfo previousSessionInfo;
        String previousOsVersion = "";
        String previousAppId = "";
        if (this.namedCollection != null) {
            previousOsVersion = this.namedCollection.getString("OsVersion", "");
            previousAppId = this.namedCollection.getString("AppId", "");
        }
        LifecycleMetricsBuilder metricsBuilder = new LifecycleMetricsBuilder(this.deviceInfoService, this.namedCollection, startTimestampInSeconds);
        Map<String, String> defaultData = metricsBuilder.addCoreData().addGenericData().build();
        if (!isInstall) {
            this.checkForApplicationUpgrade(defaultData.get("appid"));
        }
        if ((previousSessionInfo = this.lifecycleSession.start(startTimestampInSeconds, sessionTimeoutInSeconds, defaultData)) == null) {
            return null;
        }
        this.lifecycleContextData.clear();
        HashMap<String, String> lifecycleData = new HashMap<String, String>();
        if (isInstall) {
            metricsBuilder.addInstallData().addGenericData().addCoreData();
            lifecycleData.putAll(metricsBuilder.build());
        } else {
            metricsBuilder.addLaunchData().addUpgradeData(this.isUpgrade()).addCrashData(previousSessionInfo.isCrash()).addGenericData().addCoreData();
            lifecycleData.putAll(metricsBuilder.build());
            Map<String, String> sessionContextData = this.lifecycleSession.getSessionData(startTimestampInSeconds, sessionTimeoutInSeconds, previousSessionInfo);
            lifecycleData.putAll(sessionContextData);
            if (!StringUtils.isNullOrEmpty((String)previousOsVersion)) {
                lifecycleData.put("previousosversion", previousOsVersion);
            }
            if (!StringUtils.isNullOrEmpty((String)previousAppId)) {
                lifecycleData.put("previousappid", previousAppId);
            }
        }
        if (additionalContextData != null) {
            lifecycleData.putAll(additionalContextData);
        }
        if (!StringUtils.isNullOrEmpty((String)advertisingIdentifier)) {
            lifecycleData.put("advertisingidentifier", advertisingIdentifier);
        }
        this.lifecycleContextData.putAll(lifecycleData);
        this.persistLifecycleContextData(startTimestampInSeconds);
        return previousSessionInfo;
    }

    void pause(Event event) {
        this.lifecycleSession.pause(event.getTimestampInSeconds());
    }

    void checkForApplicationUpgrade(String applicationIdentifier) {
        if (!this.isUpgrade()) {
            return;
        }
        Map<String, String> lifecycleData = this.getContextData();
        if (lifecycleData == null || lifecycleData.isEmpty()) {
            return;
        }
        lifecycleData.put("appid", applicationIdentifier);
        if (this.lifecycleContextData.isEmpty()) {
            this.previousSessionLifecycleContextData.put("appid", applicationIdentifier);
            if (this.namedCollection != null) {
                this.namedCollection.setMap("LifecycleData", lifecycleData);
            }
        } else {
            this.lifecycleContextData.putAll(lifecycleData);
        }
    }

    Map<String, String> getContextData() {
        if (!this.lifecycleContextData.isEmpty()) {
            return this.lifecycleContextData;
        }
        if (!this.previousSessionLifecycleContextData.isEmpty()) {
            return this.previousSessionLifecycleContextData;
        }
        this.previousSessionLifecycleContextData.putAll(this.getPersistedContextData());
        return this.previousSessionLifecycleContextData;
    }

    @VisibleForTesting
    void updateContextData(@NonNull Map<String, String> contextData) {
        this.lifecycleContextData.putAll(contextData);
    }

    @VisibleForTesting
    void updatePreviousSessionLifecycleContextData(@NonNull Map<String, String> contextData) {
        this.previousSessionLifecycleContextData.putAll(contextData);
    }

    Map<String, String> getPersistedContextData() {
        if (this.namedCollection == null) {
            Log.warning((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to read lifecycle data from persistence %s (DataStore)", (Object[])new Object[]{"Unexpected Null Value"});
            return new HashMap<String, String>();
        }
        Map lifecycleData = this.namedCollection.getMap("LifecycleData");
        return lifecycleData != null ? lifecycleData : new HashMap();
    }

    private boolean isUpgrade() {
        String previousAppVersion = "";
        if (this.namedCollection != null) {
            previousAppVersion = this.namedCollection.getString("LastVersion", "");
        }
        return this.deviceInfoService != null && !StringUtils.isNullOrEmpty((String)previousAppVersion) && !previousAppVersion.equalsIgnoreCase(this.deviceInfoService.getApplicationVersion());
    }

    private void persistLifecycleContextData(long startTimestamp) {
        if (this.namedCollection == null) {
            Log.debug((String)"Lifecycle", (String)SELF_LOG_TAG, (String)"Failed to update lifecycle data, %s (DataStore)", (Object[])new Object[]{"Unexpected Null Value"});
            return;
        }
        this.namedCollection.setMap("LifecycleData", this.lifecycleContextData);
        this.namedCollection.setLong("LastDateUsed", startTimestamp);
        if (this.deviceInfoService != null) {
            this.namedCollection.setString("LastVersion", this.deviceInfoService.getApplicationVersion());
        }
    }
}

